<?php

namespace App\Controllers;

use CodeIgniter\Controller;

class Auth extends Controller
{
    public function login()
    {
        // If already logged in, redirect to admin
        if (session()->get('isLoggedIn')) {
            return redirect()->to('/admin/biodata');
        }
        
        return view('auth/login');
    }
    
    public function processLogin()
    {
        $username = $this->request->getPost('username');
        $password = $this->request->getPost('password');
        
        // Simple authentication (you should use database in production)
        // Default credentials: admin / admin123
        if ($username === 'admin' && $password === 'admin123') {
            session()->set([
                'isLoggedIn' => true,
                'username' => $username,
                'loginTime' => date('Y-m-d H:i:s')
            ]);
            
            session()->setFlashdata('message', 'Login berhasil! Selamat datang');
            return redirect()->to('/admin/biodata');
        } else {
            session()->setFlashdata('error', 'Username atau password salah');
            return redirect()->to('/login');
        }
    }
    
    public function logout()
    {
        session()->destroy();
        session()->setFlashdata('message', 'Anda telah logout');
        return redirect()->to('/login');
    }
}
