<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */
$routes->get('/', 'Home::index');

$routes->get('about', 'Page::about');
$routes->get('contact', 'Page::contact');
$routes->get('faqs', 'Page::faqs');

// Authentication routes
$routes->get('login', 'Auth::login');
$routes->post('login/process', 'Auth::processLogin');
$routes->get('logout', 'Auth::logout');

// Frontend routes
$routes->get('activities', 'Activities::index');
$routes->get('biodata', 'Biodata::index');
$routes->get('education', 'Education::index');

$routes->group('admin', ['filter' => 'auth'], function($routes){
	// Redirect admin root to biodata
	$routes->get('/', 'BiodataAdmin::index');
	
	// Admin routes for Activities
	$routes->get('activities', 'ActivitiesAdmin::index');
	$routes->get('activities/(:segment)/preview', 'ActivitiesAdmin::preview/$1');
	$routes->add('activities/new', 'ActivitiesAdmin::create');
	$routes->add('activities/(:segment)/edit', 'ActivitiesAdmin::edit/$1');
	$routes->get('activities/(:segment)/delete', 'ActivitiesAdmin::delete/$1');
	
	// Admin routes for Biodata
	$routes->get('biodata', 'BiodataAdmin::index');
	$routes->get('biodata/(:segment)/preview', 'BiodataAdmin::preview/$1');
	$routes->add('biodata/new', 'BiodataAdmin::create');
	$routes->add('biodata/(:segment)/edit', 'BiodataAdmin::edit/$1');
	$routes->get('biodata/(:segment)/delete', 'BiodataAdmin::delete/$1');
	
	// Admin routes for Education
	$routes->get('education', 'EducationAdmin::index');
	$routes->get('education/(:segment)/preview', 'EducationAdmin::preview/$1');
	$routes->add('education/new', 'EducationAdmin::create');
	$routes->add('education/(:segment)/edit', 'EducationAdmin::edit/$1');
	$routes->get('education/(:segment)/delete', 'EducationAdmin::delete/$1');
});
