<x-app-layout>
    @php
        $adminWhatsapp = \App\Models\StoreSetting::getValue('store.whatsapp_admin', '6283879865012');
    @endphp
    <section class="py-10">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 grid gap-8 lg:grid-cols-[1.1fr,0.9fr]">
            <div class="space-y-4" data-product-gallery>
                <div class="relative overflow-hidden rounded-3xl border border-[#FAD4C2] bg-[#FFF0E6] group">
                    <button type="button" class="block w-full" data-gallery-open>
                        <img
                            src="{{ $product->primaryImage()?->path ?? $product->thumbnail }}"
                            alt="{{ $product->name }}"
                            class="w-full object-cover transition duration-300 group-hover:scale-105"
                            data-gallery-main
                        >
                        <span class="absolute bottom-3 right-3 inline-flex items-center gap-2 rounded-full bg-white/80 px-3 py-1 text-xs font-semibold text-slate-700 shadow-sm transition group-hover:bg-white">
                            <svg class="h-4 w-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.8" d="M15 10l4.553-4.553a1.5 1.5 0 10-2.122-2.122L12.879 7.879M9 14l-4.553 4.553a1.5 1.5 0 102.122 2.122L11.121 16.12M7.5 7.5l9 9" />
                            </svg>
                            Lihat Detail
                        </span>
                    </button>
                </div>
                @if ($product->images->count() > 1)
                    <div class="flex gap-3 overflow-x-auto" data-gallery-thumbnails>
                        @foreach ($product->images as $image)
                            <button type="button" class="group relative h-20 w-24 flex-shrink-0 overflow-hidden rounded-2xl border border-[#FAD4C2] transition hover:border-[#C26A3D]" data-gallery-thumb data-image="{{ $image->path }}">
                                <img src="{{ $image->path }}" alt="{{ $product->name }}" class="h-full w-full object-cover transition duration-300 group-hover:scale-105">
                                <span class="sr-only">Lihat {{ $product->name }}</span>
                            </button>
                        @endforeach
                    </div>
                @endif
            </div>
            <div class="space-y-6 rounded-3xl border border-[#FAD4C2] bg-white p-6 shadow-sm">
                <div class="space-y-3">
                    <span class="inline-flex items-center rounded-full bg-[#FFE2CF] px-3 py-1 text-[11px] font-semibold uppercase tracking-wider text-[#C26A3D]">{{ $product->category->name }}</span>
                    <h1 class="text-2xl font-semibold text-slate-900">{{ $product->name }}</h1>
                    <p class="text-sm text-slate-500">{{ $product->tagline }}</p>

                    @if(isset($totalReviews) && $totalReviews > 0)
                    <div class="flex items-center gap-3">
                        <div class="flex items-center gap-1">
                            @for($i = 1; $i <= 5; $i++)
                                @if($i <= floor($avgRating ?? 0))
                                    <svg class="h-5 w-5 text-yellow-400" fill="currentColor" viewBox="0 0 20 20">
                                        <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                                    </svg>
                                @elseif($i - 0.5 <= ($avgRating ?? 0))
                                    <svg class="h-5 w-5 text-yellow-400" fill="currentColor" viewBox="0 0 20 20">
                                        <defs>
                                            <linearGradient id="half-{{ $i }}">
                                                <stop offset="50%" stop-color="currentColor"></stop>
                                                <stop offset="50%" stop-color="rgb(229, 231, 235)" stop-opacity="1"></stop>
                                            </linearGradient>
                                        </defs>
                                        <path fill="url(#half-{{ $i }})" d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                                    </svg>
                                @else
                                    <svg class="h-5 w-5 text-slate-300" fill="currentColor" viewBox="0 0 20 20">
                                        <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                                    </svg>
                                @endif
                            @endfor
                        </div>
                        <span class="text-sm font-semibold text-slate-700">{{ number_format($avgRating ?? 0, 1) }}</span>
                        <span class="text-xs text-slate-500">({{ $totalReviews ?? 0 }} ulasan)</span>
                    </div>
                    @endif

                    <div class="flex flex-wrap items-center gap-3">
                        <p class="text-3xl font-semibold text-[#C26A3D]">Rp{{ number_format($product->final_price, 0, ',', '.') }}</p>
                        @if ($product->discount_percent > 0)
                            <span class="text-sm text-slate-400 line-through">Rp{{ number_format($product->price, 0, ',', '.') }}</span>
                            <span class="rounded-full bg-emerald-100 px-3 py-1 text-xs font-semibold text-emerald-700">Hemat {{ rtrim(rtrim(number_format($product->discount_percent, 2, ',', '.'), '0'), ',') }}%</span>
                        @endif
                    </div>
                    @if ($product->discount_percent > 0)
                        <p class="text-xs text-emerald-700">Selisih hemat Rp{{ number_format($product->price - $product->final_price, 0, ',', '.') }} dari harga normal.</p>
                    @endif
                </div>
                <div class="space-y-3 text-sm text-slate-600">
                    <p><strong class="text-slate-900">SKU:</strong> {{ $product->sku }}</p>
                    <p><strong class="text-slate-900">Stok tersedia:</strong> {{ $product->stock }} unit</p>
                    @php
                        $sizeSources = [
                            data_get($product->metadata, 'size_variants'),
                            data_get($product->metadata, 'sizes'),
                            data_get($product->metadata, 'variant_options'),
                        ];

                        $sizeOptions = collect();

                        foreach ($sizeSources as $source) {
                            if (! empty($source)) {
                                $sizeOptions = collect(is_array($source) ? $source : [$source]);
                                break;
                            }
                        }

                        if ($sizeOptions->isEmpty()) {
                            $fallbackVariant = data_get($product->metadata, 'variant');
                            if ($fallbackVariant) {
                                $sizeOptions = collect([$fallbackVariant]);
                            }
                        }

                        $sizeOptions = $sizeOptions
                            ->map(function ($option) {
                                if (is_array($option)) {
                                    return $option['label'] ?? $option['name'] ?? $option['value'] ?? implode(' ', array_filter($option));
                                }

                                return trim((string) $option);
                            })
                            ->filter()
                            ->values();
                    @endphp

                    <div>
                        <p><strong class="text-slate-900">Varian Ukuran:</strong></p>
                        @if ($sizeOptions->isNotEmpty())
                            <div class="mt-2 flex flex-wrap gap-2">
                                @foreach ($sizeOptions as $size)
                                    <span class="inline-flex items-center rounded-full border border-[#FAD4C2] bg-[#FFF8F3] px-3 py-1 text-xs font-semibold text-slate-700">{{ $size }}</span>
                                @endforeach
                            </div>
                        @else
                            <p class="mt-1 text-xs text-slate-500">Ukuran menyesuaikan produk. Silakan cek deskripsi atau konsultasikan dengan admin untuk detail varian.</p>
                        @endif
                    </div>
                </div>
                <div class="space-y-4 text-sm text-slate-600">
                    <h2 class="text-base font-semibold text-slate-900">Deskripsi Produk</h2>
                    <p class="whitespace-pre-line leading-relaxed">{{ $product->description }}</p>
                </div>
                <div class="space-y-4" data-product-actions>
                    <div class="flex items-center gap-3">
                        <label for="quantity" class="text-sm font-semibold text-slate-700">Jumlah</label>
                        <input
                            type="number"
                            name="quantity"
                            id="quantity"
                            value="{{ $product->min_order_qty }}"
                            min="{{ $product->min_order_qty }}"
                            @if($product->max_order_qty) max="{{ $product->max_order_qty }}" @endif
                            class="w-24 rounded-full border border-[#FAD4C2] bg-[#FFF8F3] px-4 py-2 text-sm focus:border-[#C26A3D] focus:ring-0"
                            data-quantity-input
                        />
                        <span class="text-xs text-slate-500">Minimal {{ $product->min_order_qty }} unit</span>
                    </div>
                    <div class="flex flex-wrap gap-3">
                        @auth
                            <form action="{{ route('cart.buy-now') }}" method="POST" class="flex-1 min-w-[180px]">
                                @csrf
                                <input type="hidden" name="product_id" value="{{ $product->id }}">
                                <input type="hidden" name="quantity" value="{{ $product->min_order_qty }}" data-buy-now-quantity>
                                <button type="submit" class="w-full inline-flex items-center justify-center gap-2 rounded-full bg-gradient-to-r from-[#C26A3D] to-orange-500 px-6 py-3 text-sm font-semibold text-white shadow-lg hover:from-[#a85327] hover:to-orange-600 transition transform hover:scale-105">
                                    <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 3h2l.4 2M7 13h10l4-8H5.4M7 13L5.4 5M7 13l-2.293 2.293c-.63.63-.184 1.707.707 1.707H17m0 0a2 2 0 100 4 2 2 0 000-4zm-8 2a2 2 0 11-4 0 2 2 0 014 0z"></path>
                                    </svg>
                                    Beli Sekarang
                                </button>
                            </form>
                        @else
                            <a href="{{ route('login') }}" class="flex-1 inline-flex items-center justify-center gap-2 rounded-full bg-gradient-to-r from-[#C26A3D] to-orange-500 px-6 py-3 text-sm font-semibold text-white shadow-lg hover:from-[#a85327] hover:to-orange-600 transition transform hover:scale-105 min-w-[180px]">
                                <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 3h2l.4 2M7 13h10l4-8H5.4M7 13L5.4 5M7 13l-2.293 2.293c-.63.63-.184 1.707.707 1.707H17m0 0a2 2 0 100 4 2 2 0 000-4zm-8 2a2 2 0 11-4 0 2 2 0 014 0z"></path>
                                </svg>
                                Login untuk Beli Sekarang
                            </a>
                        @endauth
                        <form
                            action="{{ route('cart.store') }}"
                            method="POST"
                            class="flex-1 min-w-[180px]"
                            data-add-to-cart-form
                            data-product-name="{{ $product->name }}"
                            data-product-image="{{ $product->primaryImage()?->path ?? $product->thumbnail ?? asset('images/placeholders/product.png') }}"
                        >
                            @csrf
                            <input type="hidden" name="product_id" value="{{ $product->id }}">
                            <input type="hidden" name="quantity" value="{{ $product->min_order_qty }}" data-cart-quantity>
                            <button type="submit" class="w-full inline-flex items-center justify-center gap-2 rounded-full bg-[#C26A3D] px-6 py-3 text-sm font-semibold text-white transition hover:bg-[#a85327]" data-add-to-cart-button>
                                <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 3h2l.4 2M7 13h10l4-8H5.4M7 13L5.4 5M7 13l-2.293 2.293c-.63.63-.184 1.707.707 1.707H17m0 0a2 2 0 100 4 2 2 0 000-4zm-8 2a2 2 0 11-4 0 2 2 0 014 0z"></path>
                                </svg>
                                Tambah ke Keranjang
                            </button>
                        </form>
                        {{-- Wishlist feature temporarily disabled --}}
                        <a href="https://wa.me/{{ $adminWhatsapp }}?text=Halo, saya tertarik dengan produk {{ urlencode($product->name) }}" class="inline-flex items-center gap-2 rounded-full border border-[#C26A3D] px-6 py-3 text-sm font-semibold text-[#C26A3D] hover:bg-[#FFE2CF] transition min-w-[180px] justify-center">
                            Hubungi Admin
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="py-10 bg-white">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex flex-col gap-4 sm:flex-row sm:items-center sm:justify-between mb-6">
                <div>
                    <h2 class="text-2xl font-semibold text-slate-900">Ulasan & Komentar</h2>
                    <p class="text-sm text-slate-500 mt-1">Lihat apa yang dikatakan pelanggan tentang produk ini</p>
                </div>
                @php
                    $avgRating = $avgRating ?? 0;
                    $totalReviews = $totalReviews ?? 0;
                @endphp
                <div class="text-center sm:text-right">
                    <div class="text-3xl font-bold text-[#C26A3D]">{{ number_format($avgRating, 1) }}</div>
                    <div class="flex items-center justify-center sm:justify-end gap-1 mt-1">
                        @for($i = 1; $i <= 5; $i++)
                            @if($i <= floor($avgRating))
                                <svg class="h-4 w-4 text-yellow-400" fill="currentColor" viewBox="0 0 20 20">
                                    <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                                </svg>
                            @else
                                <svg class="h-4 w-4 text-slate-300" fill="currentColor" viewBox="0 0 20 20">
                                    <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                                </svg>
                            @endif
                        @endfor
                    </div>
                    <p class="text-xs text-slate-500 mt-1">{{ $totalReviews }} ulasan</p>
                </div>
            </div>

            @auth
                @if(!$userReview)
                    <div class="rounded-3xl border border-[#FAD4C2] bg-[#FFF8F3] p-6 mb-8">
                        <h3 class="text-lg font-semibold text-slate-900 mb-4">Beri Ulasan</h3>
                        <form action="{{ route('products.reviews.store', $product) }}" method="POST">
                            @csrf
                            <div class="space-y-4">
                                <div>
                                    <label class="text-sm font-semibold text-slate-700 mb-2 block">Rating</label>
                                    <div class="flex gap-2" x-data="{ rating: 5 }">
                                        @for($i = 5; $i >= 1; $i--)
                                            <button type="button" @click="rating = {{ $i }}" :class="rating >= {{ $i }} ? 'text-yellow-400' : 'text-slate-300'" class="transition">
                                                <svg class="h-8 w-8" fill="currentColor" viewBox="0 0 20 20">
                                                    <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                                                </svg>
                                            </button>
                                        @endfor
                                        <input type="hidden" name="rating" x-model="rating" value="5">
                                    </div>
                                </div>
                                <div>
                                    <label for="comment" class="text-sm font-semibold text-slate-700 mb-2 block">Komentar</label>
                                    <textarea name="comment" id="comment" rows="4" class="w-full rounded-xl border border-[#FAD4C2] bg-white px-4 py-3 text-sm focus:border-[#C26A3D] focus:ring-2 focus:ring-[#FFE2CF] transition" placeholder="Bagikan pengalaman Anda dengan produk ini..."></textarea>
                                </div>
                                <button type="submit" class="inline-flex items-center rounded-full bg-[#C26A3D] px-6 py-2.5 text-sm font-semibold text-white hover:bg-[#a85327] transition">
                                    Kirim Ulasan
                                </button>
                            </div>
                        </form>
                    </div>
                @else
                    <div class="rounded-3xl border border-[#FAD4C2] bg-[#FFF8F3] p-6 mb-8">
                        <div class="flex items-start justify-between mb-4">
                            <div>
                                <h3 class="text-lg font-semibold text-slate-900">Ulasan Anda</h3>
                                <p class="text-xs text-slate-500">Anda sudah memberikan ulasan untuk produk ini</p>
                            </div>
                            <form action="{{ route('reviews.destroy', $userReview) }}" method="POST" onsubmit="return confirm('Yakin ingin menghapus ulasan ini?');">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="text-xs text-red-600 hover:text-red-700">Hapus</button>
                            </form>
                        </div>
                        <div class="flex items-center gap-2 mb-2">
                            @for($i = 1; $i <= 5; $i++)
                                @if($i <= $userReview->rating)
                                    <svg class="h-4 w-4 text-yellow-400" fill="currentColor" viewBox="0 0 20 20">
                                        <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                                    </svg>
                                @else
                                    <svg class="h-4 w-4 text-slate-300" fill="currentColor" viewBox="0 0 20 20">
                                        <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                                    </svg>
                                @endif
                            @endfor
                        </div>
                        <p class="text-sm text-slate-700">{{ $userReview->comment }}</p>
                        <p class="text-xs text-slate-500 mt-2">{{ $userReview->created_at->format('d M Y') }}</p>
                    </div>
                @endif
            @else
                <div class="rounded-3xl border border-[#FAD4C2] bg-[#FFF8F3] p-6 mb-8 text-center">
                    <p class="text-sm text-slate-600 mb-3">Login untuk memberikan ulasan</p>
                    <a href="{{ route('login') }}" class="inline-flex items-center rounded-full bg-[#C26A3D] px-6 py-2.5 text-sm font-semibold text-white hover:bg-[#a85327] transition">
                        Login
                    </a>
                </div>
            @endauth

            <div class="space-y-4">
                @forelse($reviews as $review)
                    <div class="rounded-2xl border border-[#FAD4C2] bg-white p-6">
                        <div class="flex items-start justify-between mb-3">
                            <div class="flex items-center gap-3">
                                <div class="h-10 w-10 rounded-full bg-gradient-to-br from-[#C26A3D] to-orange-500 flex items-center justify-center text-white font-semibold text-sm">
                                    {{ strtoupper(substr($review->user->name, 0, 2)) }}
                                </div>
                                <div>
                                    <p class="font-semibold text-slate-900">{{ $review->user->name }}</p>
                                    <p class="text-xs text-slate-500">{{ $review->created_at->diffForHumans() }}</p>
                                </div>
                            </div>
                            <div class="flex items-center gap-1">
                                @for($i = 1; $i <= 5; $i++)
                                    @if($i <= $review->rating)
                                        <svg class="h-4 w-4 text-yellow-400" fill="currentColor" viewBox="0 0 20 20">
                                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                                        </svg>
                                    @else
                                        <svg class="h-4 w-4 text-slate-300" fill="currentColor" viewBox="0 0 20 20">
                                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                                        </svg>
                                    @endif
                                @endfor
                            </div>
                        </div>
                        @if($review->comment)
                            <p class="text-sm text-slate-700 leading-relaxed">{{ $review->comment }}</p>
                        @endif
                    </div>
                @empty
                    <div class="rounded-2xl border border-[#FAD4C2] bg-white p-10 text-center text-slate-500">
                        <svg class="h-12 w-12 mx-auto mb-3 text-slate-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z"></path>
                        </svg>
                        <p class="font-medium">Belum ada ulasan</p>
                        <p class="text-xs mt-1">Jadilah yang pertama memberikan ulasan!</p>
                    </div>
                @endforelse
            </div>

            @if($reviews->hasPages())
                <div class="mt-6">
                    {{ $reviews->links() }}
                </div>
            @endif
        </div>
    </section>

    <section class="py-10 bg-[#FFF7F2]">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 space-y-6">
            <div class="flex flex-col gap-2 sm:flex-row sm:items-center sm:justify-between">
                <h2 class="text-lg font-semibold text-slate-900">Produk Terkait</h2>
                <span class="text-xs text-slate-500">Produk serupa dari kategori {{ $product->category->name }}</span>
            </div>
            <div class="grid gap-6 sm:grid-cols-2 lg:grid-cols-4">
                @forelse ($relatedProducts as $related)
                    <div class="rounded-3xl border border-[#FAD4C2] bg-white p-4 shadow-sm hover:-translate-y-1 hover:border-[#C26A3D] hover:shadow-lg transition">
                        <div class="relative h-40 overflow-hidden rounded-2xl bg-[#FFE7D4]">
                            <img src="{{ $related->thumbnail }}" alt="{{ $related->name }}" class="absolute inset-0 h-full w-full object-cover">
                        </div>
                        <div class="mt-4 space-y-2">
                            <span class="inline-flex items-center rounded-full bg-[#FFE2CF] px-3 py-1 text-[11px] font-semibold uppercase tracking-wider text-[#C26A3D]">{{ $related->category->name }}</span>
                            <a href="{{ route('products.show', $related) }}" class="block text-sm font-semibold text-slate-900 leading-tight">{{ $related->name }}</a>
                            <p class="text-xs text-slate-500 h-[40px] overflow-hidden">{{ $related->summary }}</p>
                            <p class="text-lg font-semibold text-[#C26A3D]">Rp{{ number_format($related->final_price, 0, ',', '.') }}</p>
                        </div>
                    </div>
                @empty
                    <div class="rounded-3xl border border-[#FAD4C2] bg-white p-10 text-center text-slate-500 sm:col-span-2 lg:col-span-4">
                        Belum ada produk terkait dalam kategori ini.
                    </div>
                @endforelse
            </div>
        </div>
    </section>
</x-app-layout>
