<nav x-data="{ open: false }" class="bg-white/90 dark:bg-slate-900/90 backdrop-blur-md border-b border-[#FAD4C2]/50 dark:border-slate-800 sticky top-0 z-40 shadow-sm">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="flex h-16 justify-between items-center">
            <div class="flex items-center gap-6">
                <a href="{{ route('home') }}" class="flex items-center gap-2.5 group">
                    @if(!empty($brandLogo))
                        <img src="{{ $brandLogo }}" alt="{{ $brandName }} Logo" class="h-9 w-9 rounded-lg border border-[#FAD4C2]/60 dark:border-slate-700 object-cover shadow-sm group-hover:shadow-md transition">
                    @else
                        <span class="inline-flex h-9 w-9 items-center justify-center rounded-lg font-bold text-white shadow-sm group-hover:shadow-md transition" style="background: linear-gradient(135deg, {{ $brandColor }}, {{ $brandColor }}dd);">
                            {{ \Illuminate\Support\Str::of($brandName)->substr(0, 2)->upper() }}
                        </span>
                    @endif
                    <div class="leading-tight">
                        <span class="block font-bold text-sm text-slate-900 dark:text-slate-100">{{ $brandName }}</span>
                        <span class="text-[10px] text-slate-500 dark:text-slate-400">Toko Online</span>
                    </div>
                </a>

                <div class="hidden lg:flex items-center gap-1 text-sm font-medium">
                    <a href="{{ route('home') }}" class="px-3 py-1.5 rounded-lg transition {{ request()->routeIs('home') ? 'bg-[#FFE2CF] text-[#C26A3D] font-semibold' : 'text-slate-600 dark:text-slate-300 hover:bg-[#FFF5EE] dark:hover:bg-slate-800' }}">Beranda</a>
                    <a href="{{ route('products.index') }}" class="px-3 py-1.5 rounded-lg transition {{ request()->routeIs('products.*') ? 'bg-[#FFE2CF] text-[#C26A3D] font-semibold' : 'text-slate-600 dark:text-slate-300 hover:bg-[#FFF5EE] dark:hover:bg-slate-800' }}">Produk</a>
                    @auth
                        <a href="{{ route('dashboard') }}" class="px-3 py-1.5 rounded-lg transition {{ request()->routeIs('dashboard') ? 'bg-[#FFE2CF] text-[#C26A3D] font-semibold' : 'text-slate-600 dark:text-slate-300 hover:bg-[#FFF5EE] dark:hover:bg-slate-800' }}">Profil Saya</a>
                    @endauth
                </div>
            </div>

            <div class="hidden lg:flex items-center gap-2">
                <button type="button" aria-label="Toggle theme" title="Theme"
                        class="inline-flex items-center justify-center rounded-lg p-2 border border-[#FAD4C2]/60 dark:border-slate-700 bg-white dark:bg-slate-800 text-[#C26A3D] dark:text-slate-100 hover:bg-[#FFE2CF] dark:hover:bg-slate-700 transition"
                        data-theme-toggle>
                    <svg class="h-4 w-4 block dark:hidden" viewBox="0 0 24 24" fill="none" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 3v2m0 14v2m9-9h-2M5 12H3m15.364 6.364-1.414-1.414M7.05 7.05 5.636 5.636m12.728 0-1.414 1.414M7.05 16.95l-1.414 1.414M12 8a4 4 0 100 8 4 4 0 000-8z" />
                    </svg>
                    <svg class="h-4 w-4 hidden dark:block" viewBox="0 0 24 24" fill="none" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 12.79A9 9 0 1111.21 3 7 7 0 0021 12.79z" />
                    </svg>
                </button>
                <a href="https://wa.me/{{ $adminWhatsapp }}" class="inline-flex items-center gap-2 rounded-lg border border-emerald-200 bg-gradient-to-r from-emerald-50 to-emerald-100 px-3 py-1.5 text-xs font-semibold text-emerald-700 hover:from-emerald-100 hover:to-emerald-200 dark:from-emerald-900/30 dark:to-emerald-800/30 dark:text-emerald-300 transition">
                    <svg class="h-3.5 w-3.5" fill="currentColor" viewBox="0 0 24 24">
                        <path d="M17.472 14.382c-.297-.149-1.758-.867-2.03-.967-.273-.099-.471-.148-.67.15-.197.297-.767.966-.94 1.164-.173.199-.347.223-.644.075-.297-.15-1.255-.463-2.39-1.475-.883-.788-1.48-1.761-1.653-2.059-.173-.297-.018-.458.13-.606.134-.133.298-.347.446-.52.149-.174.198-.298.298-.497.099-.198.05-.371-.025-.52-.075-.149-.669-1.612-.916-2.207-.242-.579-.487-.5-.669-.51-.173-.008-.371-.01-.57-.01-.198 0-.52.074-.792.372-.272.297-1.04 1.016-1.04 2.479 0 1.462 1.065 2.875 1.213 3.074.149.198 2.096 3.2 5.077 4.487.709.306 1.262.489 1.694.625.712.227 1.36.195 1.871.118.571-.085 1.758-.719 2.006-1.413.248-.694.248-1.289.173-1.413-.074-.124-.272-.198-.57-.347m-5.421 7.403h-.004a9.87 9.87 0 01-5.031-1.378l-.361-.214-3.741.982.998-3.648-.235-.374a9.86 9.86 0 01-1.51-5.26c.001-5.45 4.436-9.884 9.888-9.884 2.64 0 5.122 1.03 6.988 2.898a9.825 9.825 0 012.893 6.994c-.003 5.45-4.437 9.884-9.885 9.884m8.413-18.297A11.815 11.815 0 0012.05 0C5.495 0 .16 5.335.157 11.892c0 2.096.547 4.142 1.588 5.945L.057 24l6.305-1.654a11.882 11.882 0 005.683 1.448h.005c6.554 0 11.89-5.335 11.893-11.893a11.821 11.821 0 00-3.48-8.413Z"/>
                    </svg>
                    WhatsApp
                </a>

                @auth
                    @php
                        $userUnpaidOrders = \App\Models\Order::where('user_id', Auth::id())
                            ->where('payment_status', '!=', 'paid')
                            ->count();
                        $userPendingOrders = \App\Models\Order::where('user_id', Auth::id())
                            ->whereIn('status', ['pending', 'confirmed', 'processing', 'ready_to_ship', 'shipping'])
                            ->count();
                        $userNotificationCount = $userUnpaidOrders + $userPendingOrders;
                    @endphp
                    <div x-data="{ open: false }" class="relative">
                        <button type="button" @click="open = !open" class="relative inline-flex items-center justify-center rounded-lg p-2 text-[#C26A3D] hover:bg-[#FFE2CF] dark:hover:bg-slate-800 transition">
                            <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9"></path>
                            </svg>
                            @if($userNotificationCount > 0)
                                <span class="absolute -top-1 -right-1 flex h-5 w-5 items-center justify-center rounded-full bg-red-500 text-[10px] font-bold text-white">{{ $userNotificationCount > 9 ? '9+' : $userNotificationCount }}</span>
                            @endif
                        </button>
                        <div x-show="open" @click.away="open = false" x-cloak x-transition class="absolute right-0 mt-2 w-80 rounded-xl border border-[#FAD4C2]/60 dark:border-slate-700 bg-white dark:bg-slate-800 shadow-xl z-50">
                            <div class="p-4 border-b border-[#FAD4C2]/40 dark:border-slate-700">
                                <h3 class="text-sm font-bold text-slate-900 dark:text-white">Notifikasi</h3>
                            </div>
                            <div class="max-h-96 overflow-y-auto">
                                @if($userUnpaidOrders > 0)
                                    <a href="{{ route('orders.index', ['payment_status' => 'unpaid']) }}" class="flex items-start gap-3 p-4 hover:bg-[#FFF7F2] dark:hover:bg-slate-700 transition">
                                        <div class="flex h-10 w-10 items-center justify-center rounded-lg bg-amber-100 dark:bg-amber-900/30">
                                            <svg class="h-5 w-5 text-amber-600 dark:text-amber-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                            </svg>
                                        </div>
                                        <div class="flex-1">
                                            <p class="text-sm font-semibold text-slate-900 dark:text-white">Pembayaran Belum Diterima</p>
                                            <p class="text-xs text-slate-500 dark:text-slate-400 mt-1">{{ $userUnpaidOrders }} pesanan menunggu pembayaran</p>
                                        </div>
                                    </a>
                                @endif
                                @if($userPendingOrders > 0)
                                    <a href="{{ route('orders.index', ['status' => 'pending']) }}" class="flex items-start gap-3 p-4 hover:bg-[#FFF7F2] dark:hover:bg-slate-700 transition">
                                        <div class="flex h-10 w-10 items-center justify-center rounded-lg bg-blue-100 dark:bg-blue-900/30">
                                            <svg class="h-5 w-5 text-blue-600 dark:text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                            </svg>
                                        </div>
                                        <div class="flex-1">
                                            <p class="text-sm font-semibold text-slate-900 dark:text-white">Pesanan Diproses</p>
                                            <p class="text-xs text-slate-500 dark:text-slate-400 mt-1">{{ $userPendingOrders }} pesanan sedang diproses</p>
                                        </div>
                                    </a>
                                @endif
                                @if($userNotificationCount === 0)
                                    <div class="p-8 text-center">
                                        <svg class="mx-auto h-12 w-12 text-slate-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 13V6a2 2 0 00-2-2H6a2 2 0 00-2 2v7m16 0v5a2 2 0 01-2 2H6a2 2 0 01-2-2v-5m16 0h-2.586a1 1 0 00-.707.293l-2.414 2.414a1 1 0 01-.707.293h-3.172a1 1 0 01-.707-.293l-2.414-2.414A1 1 0 006.586 13H4"></path>
                                        </svg>
                                        <p class="mt-2 text-sm text-slate-500 dark:text-slate-400">Tidak ada notifikasi</p>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                @endauth

                <a href="{{ route('cart.index') }}" class="relative inline-flex items-center justify-center rounded-lg p-2 text-[#C26A3D] hover:bg-[#FFE2CF] dark:hover:bg-slate-800 transition" data-cart-link>
                    <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 3h2l.4 2M7 13h10l4-8H5.4M7 13L5.4 5M7 13l-2.293 2.293c-.63.63-.184 1.707.707 1.707H17m0 0a2 2 0 100 4 2 2 0 000-4zm-8 2a2 2 0 11-4 0 2 2 0 014 0z"></path>
                    </svg>
                    <span data-cart-count class="absolute -top-1 -right-1 inline-flex items-center justify-center min-w-[18px] h-[18px] px-1 rounded-full bg-gradient-to-r from-[#C26A3D] to-[#F5703B] text-[10px] font-bold text-white shadow-sm {{ $cartCount > 0 && ! request()->routeIs('checkout.*') ? '' : 'hidden' }}">{{ $cartCount > 99 ? '99+' : $cartCount }}</span>
                </a>

                @auth
                    <x-dropdown align="right" width="48">
                        <x-slot name="trigger">
                            <button class="inline-flex items-center gap-2 rounded-lg bg-gradient-to-r from-[#C26A3D] to-[#F5703B] px-3 py-1.5 text-xs font-semibold text-white shadow-md hover:shadow-lg hover:from-[#a85327] hover:to-[#C26A3D] transition">
                                <div class="flex h-6 w-6 items-center justify-center rounded bg-white/20 text-[10px] font-bold">
                                    {{ \Illuminate\Support\Str::take(Auth::user()->name, 1) }}
                                </div>
                                <span class="hidden sm:inline">{{ Auth::user()->name }}</span>
                                <svg class="h-3 w-3 hidden sm:inline" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7" />
                                </svg>
                            </button>
                        </x-slot>

                        <x-slot name="content">
                            <x-dropdown-link :href="route('orders.index')">
                                Pesanan Saya
                            </x-dropdown-link>

                            <x-dropdown-link :href="route('profile.edit')">
                                Akun Saya
                            </x-dropdown-link>

                            <form method="POST" action="{{ route('logout') }}">
                                @csrf
                                <x-dropdown-link :href="route('logout')" onclick="event.preventDefault(); this.closest('form').submit();">
                                    Keluar
                                </x-dropdown-link>
                            </form>
                        </x-slot>
                    </x-dropdown>
                @else
                    <x-dropdown align="right" width="48">
                        <x-slot name="trigger">
                            <button class="inline-flex items-center justify-center rounded-full p-2.5 text-[#C26A3D] border-2 border-[#C26A3D] bg-white hover:bg-[#FFE2CF] transition">
                                <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                                </svg>
                            </button>
                        </x-slot>

                        <x-slot name="content">
                            <x-dropdown-link :href="route('login')" class="flex items-center gap-2">
                                <svg class="h-4 w-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 16l-4-4m0 0l4-4m-4 4h14m-5 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h7a3 3 0 013 3v1"></path>
                                </svg>
                                Masuk
                            </x-dropdown-link>

                            <x-dropdown-link :href="route('register')" class="flex items-center gap-2">
                                <svg class="h-4 w-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18 9v3m0 0v3m0-3h3m-3 0h-3m-2-5a4 4 0 11-8 0 4 4 0 018 0zM3 20a6 6 0 0112 0v1H3v-1z"></path>
                                </svg>
                                Daftar
                            </x-dropdown-link>
                        </x-slot>
                    </x-dropdown>
                @endauth
            </div>

            <div class="flex lg:hidden">
                <button @click="open = !open" class="inline-flex items-center justify-center rounded-md p-2 text-[#C26A3D] hover:bg-[#FFE2CF] focus:outline-none focus:ring">
                    <svg class="h-6 w-6" stroke="currentColor" fill="none" viewBox="0 0 24 24">
                        <path :class="{'hidden': open, 'inline-flex': !open }" class="inline-flex" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
                        <path :class="{'hidden': !open, 'inline-flex': open }" class="hidden" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                    </svg>
                </button>
            </div>
        </div>
    </div>

        <div :class="{'block': open, 'hidden': !open}" class="hidden lg:hidden border-t border-[#FAD4C2] bg-white">
            <div class="space-y-1 px-4 py-3 text-sm font-medium">
                <a href="{{ route('home') }}" class="block rounded-md px-3 py-2 {{ request()->routeIs('home') ? 'bg-[#FFE2CF] text-[#C26A3D]' : 'text-slate-600 hover:bg-[#FFF0E6]' }}">Beranda</a>
                <a href="{{ route('products.index') }}" class="block rounded-md px-3 py-2 {{ request()->routeIs('products.*') ? 'bg-[#FFE2CF] text-[#C26A3D]' : 'text-slate-600 hover:bg-[#FFF0E6]' }}">Katalog Produk</a>
                @auth
                    <a href="{{ route('dashboard') }}" class="block rounded-md px-3 py-2 {{ request()->routeIs('dashboard') ? 'bg-[#FFE2CF] text-[#C26A3D]' : 'text-slate-600 hover:bg-[#FFF0E6]' }}">Profil Saya</a>
                @endauth
                <a href="{{ route('cart.index') }}" class="relative inline-flex items-center gap-2 rounded-md px-3 py-2 {{ request()->routeIs('cart.*') ? 'bg-[#FFE2CF] text-[#C26A3D]' : 'text-slate-600 hover:bg-[#FFF0E6]' }}" data-cart-link>
                    <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 3h2l.4 2M7 13h10l4-8H5.4M7 13L5.4 5M7 13l-2.293 2.293c-.63.63-.184 1.707.707 1.707H17m0 0a2 2 0 100 4 2 2 0 000-4zm-8 2a2 2 0 11-4 0 2 2 0 014 0z"></path>
                    </svg>
                    Keranjang
                    <span data-cart-count class="inline-flex items-center justify-center min-w-[18px] h-[18px] px-1 rounded-full bg-[#C26A3D] text-[10px] font-bold text-white {{ $cartCount > 0 && ! request()->routeIs('checkout.*') ? '' : 'hidden' }}">{{ $cartCount > 99 ? '99+' : $cartCount }}</span>
                </a>
            </div>

            <div class="border-t border-[#FAD4C2] px-4 py-3 space-y-3">
                <button type="button" data-theme-toggle aria-label="Toggle theme" class="flex w-full items-center justify-center gap-2 rounded-full border border-[#FAD4C2] bg-white px-4 py-2 text-sm font-medium text-[#C26A3D] hover:bg-[#FFE2CF] transition">
                    <svg class="h-4 w-4" viewBox="0 0 24 24" fill="none" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.8" d="M12 3v2m0 14v2m9-9h-2M5 12H3m15.364 6.364-1.414-1.414M7.05 7.05 5.636 5.636m12.728 0-1.414 1.414M7.05 16.95l-1.414 1.414M12 8a4 4 0 100 8 4 4 0 000-8z" />
                    </svg>
                    Theme
                </button>
                <a href="https://wa.me/{{ $adminWhatsapp }}" class="inline-flex w-full items-center justify-center gap-2 rounded-full border border-[#FAD4C2] bg-[#FFF0E6] px-4 py-2 text-sm font-medium text-[#C26A3D] hover:bg-[#FFE2CF] transition">
                    <svg class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.8" d="M2.25 6.75A4.5 4.5 0 016.75 2.25h.5A4.5 4.5 0 0111.75 6.75v1.5a1.5 1.5 0 001.5 1.5h1.5a4.5 4.5 0 014.5 4.5v.5a4.5 4.5 0 01-4.5 4.5h-.5a4.5 4.5 0 01-4.5-4.5v-1.5a1.5 1.5 0 00-1.5-1.5h-1.5a4.5 4.5 0 01-4.5-4.5v-.5z" />
                    </svg>
                    Konsultasi Admin
                </a>

            @auth
                <div class="rounded-lg border border-[#FAD4C2] bg-[#FFF8F3] px-3 py-3">
                    <p class="text-sm font-semibold text-slate-800">{{ Auth::user()->name }}</p>
                    <p class="text-xs text-slate-500">{{ Auth::user()->email }}</p>
                    <div class="mt-3 space-y-2">
                        <a href="{{ route('orders.index') }}" class="block rounded-md bg-white px-3 py-2 text-sm font-medium text-slate-600 hover:bg-[#FFE2CF]">Pesanan Saya</a>
                        <a href="{{ route('profile.edit') }}" class="block rounded-md bg-white px-3 py-2 text-sm font-medium text-slate-600 hover:bg-[#FFE2CF]">Profil</a>
                        <form method="POST" action="{{ route('logout') }}">
                            @csrf
                            <button type="submit" class="w-full rounded-md bg-[#C26A3D] px-3 py-2 text-sm font-semibold text-white hover:bg-[#a85327]">Keluar</button>
                        </form>
                    </div>
                </div>
            @else
                <div class="space-y-2">
                    <div class="flex items-center gap-2">
                        <a href="{{ route('login') }}" class="flex-1 rounded-full border border-[#C26A3D] px-3 py-2 text-center text-sm font-semibold text-[#C26A3D] hover:bg-[#FFE2CF]">Masuk</a>
                        <a href="{{ route('register') }}" class="flex-1 rounded-full bg-[#C26A3D] px-3 py-2 text-center text-sm font-semibold text-white hover:bg-[#a85327]">Daftar</a>
                    </div>
                </div>
            @endauth
        </div>
    </div>
</nav>
