﻿@php
    $routeName = request()->route()?->getName() ?? '';
    $isCashierView = str_starts_with($routeName, 'cashier.');
    $isAdminView = str_starts_with($routeName, 'admin.');
    $shouldShowPreloader = ! ($isCashierView || $isAdminView) && request()->routeIs('home');
    $brandColor = \App\Models\StoreSetting::getValue('store.brand_color', '#F7BFA0');
    $brandName = \App\Models\StoreSetting::getValue('store.name', config('app.name', "D'Shop"));
    $brandLogo = \App\Models\StoreSetting::getValue('store.logo', 'assets/logo-dshop.png');
    $brandLogoUrl = (!empty($brandLogo) && !preg_match('/^(https?:)?\/\//', $brandLogo) && ! str_starts_with($brandLogo, 'data:'))
        ? asset($brandLogo)
        : $brandLogo;
    $brandTagline = \App\Models\StoreSetting::getValue('store.tagline', 'Solusi gaya dan kebutuhan UMKM Anda.');
    $adminWhatsapp = \App\Models\StoreSetting::getValue('store.whatsapp_admin', '6283879865012');
@endphp
<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="{{ csrf_token() }}">

        <title>{{ config('app.name', "D'Shop") }}</title>

        <link rel="icon" type="image/png" href="{{ $brandLogoUrl }}">
        <link rel="shortcut icon" href="{{ $brandLogoUrl }}" type="image/png">
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">

        <script>
            (function() {
                try {
                    var theme = localStorage.getItem('theme');
                    var isDark = theme === 'dark';
                    if (isDark) {
                        document.documentElement.classList.add('dark');
                    } else {
                        document.documentElement.classList.remove('dark');
                    }
                } catch (e) {}
            })();
        </script>
        @stack('scripts')

        @if ($isCashierView || request()->routeIs('home') || request()->routeIs('products.show') || $isAdminView)
            <!-- Alpine.js untuk Cashier View, Landing Page, Product Detail, dan Admin View - Load dengan defer -->
            <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.13.5/dist/cdn.min.js"></script>
        @endif

        @vite(['resources/css/app.css', 'resources/js/app.js'])
    </head>
    <body class="font-[Poppins] antialiased text-slate-800 dark:text-slate-100 {{ $isCashierView ? 'bg-[#FFF7F2] dark:bg-slate-950' : ($isAdminView ? 'bg-[#FFEFE6] dark:bg-slate-900' : 'bg-[#FFF7F2] dark:bg-slate-900') }}">
        @stack('scripts')
        @if ($shouldShowPreloader)
            <div id="dshop-preloader" class="dshop-preloader" role="status" aria-live="polite">
                <div class="dshop-preloader__logo">
                    @if (!empty($brandLogoUrl))
                        <img src="{{ $brandLogoUrl }}" alt="{{ $brandName }} Logo" class="dshop-preloader__image">
                    @else
                        <span class="dshop-preloader__fallback">
                            {{ \Illuminate\Support\Str::of($brandName)->substr(0, 2)->upper() }}
                        </span>
                    @endif
                </div>
                <p class="mt-1 text-sm font-semibold uppercase tracking-[0.2em] text-slate-600 dark:text-slate-300">
                    {{ $brandName }}
                </p>
                <p class="text-xs text-slate-500 dark:text-slate-400">
                    Memuat pengalaman D&apos;Shop...
                </p>
            </div>
            <script>
                (function () {
                    var key = 'dshop.preloader-shown';
                    try {
                        if (localStorage.getItem(key)) {
                            var preloader = document.getElementById('dshop-preloader');
                            preloader?.remove();
                        }
                        window.__dshopPreloaderLocalStorageKey = key;
                    } catch (e) {}
                })();
            </script>
        @endif
        <div class="min-h-screen flex flex-col">
            @unless ($isCashierView || $isAdminView)
                @include('layouts.navigation', [
                    'brandColor' => $brandColor,
                    'brandName' => $brandName,
                    'brandLogo' => $brandLogoUrl,
                    'adminWhatsapp' => $adminWhatsapp,
                ])
            @endunless

            @if (! $isCashierView && ! $isAdminView)
                @isset($header)
                    <header class="bg-white/80 backdrop-blur border-b border-[#FAD4C2]">
                        <div class="max-w-7xl mx-auto py-6 px-4 sm:px-6 lg:px-8">
                            {{ $header }}
                        </div>
                    </header>
                @endisset
            @endif

            <main class="flex-1">
                {{ $slot }}
            </main>

            @unless ($isCashierView || $isAdminView)
                <footer class="mt-12 bg-white border-t border-[#FAD4C2]">
                    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-10 grid gap-6 md:grid-cols-3 text-sm">
                        <div class="flex items-center gap-3">
                            @if(!empty($brandLogoUrl))
                                <img src="{{ $brandLogoUrl }}" alt="{{ $brandName }} Logo" class="h-12 w-12 rounded-full border border-[#FAD4C2] object-cover shadow-sm">
                            @endif
                            <div>
                                <h3 class="text-lg font-semibold text-slate-900">{{ $brandName }}</h3>
                                <p class="mt-2 text-slate-600">{{ $brandTagline }}</p>
                            </div>
                        </div>
                        <div>
                            <h4 class="font-semibold text-slate-900">Kontak</h4>
                            <div class="mt-3 flex flex-wrap gap-2">
                                <a href="https://wa.me/{{ $adminWhatsapp }}" class="inline-flex items-center gap-2 rounded-xl bg-gradient-to-r from-green-500 to-green-600 px-4 py-2.5 text-white font-semibold hover:from-green-600 hover:to-green-700 transition shadow-md hover:shadow-lg transform hover:scale-105">
                                    <svg class="h-5 w-5" fill="currentColor" viewBox="0 0 24 24">
                                        <path d="M17.472 14.382c-.297-.149-1.758-.867-2.03-.967-.273-.099-.471-.148-.67.15-.197.297-.767.966-.94 1.164-.173.199-.347.223-.644.075-.297-.15-1.255-.463-2.39-1.475-.883-.788-1.48-1.761-1.653-2.059-.173-.297-.018-.458.13-.606.134-.133.298-.347.446-.52.149-.174.198-.298.298-.497.099-.198.05-.371-.025-.52-.075-.149-.669-1.612-.916-2.207-.242-.579-.487-.5-.669-.51-.173-.008-.371-.01-.57-.01-.198 0-.52.074-.792.372-.272.297-1.04 1.016-1.04 2.479 0 1.462 1.065 2.875 1.213 3.074.149.198 2.096 3.2 5.077 4.487.709.306 1.262.489 1.694.625.712.227 1.36.195 1.871.118.571-.085 1.758-.719 2.006-1.413.248-.694.248-1.289.173-1.413-.074-.124-.272-.198-.57-.347m-5.421 7.403h-.004a9.87 9.87 0 01-5.031-1.378l-.361-.214-3.741.982.998-3.648-.235-.374a9.86 9.86 0 01-1.51-5.26c.001-5.45 4.436-9.884 9.888-9.884 2.64 0 5.122 1.03 6.988 2.898a9.825 9.825 0 012.893 6.994c-.003 5.45-4.437 9.884-9.885 9.884m8.413-18.297A11.815 11.815 0 0012.05 0C5.495 0 .16 5.335.157 11.892c0 2.096.547 4.142 1.588 5.945L.057 24l6.305-1.654a11.882 11.882 0 005.683 1.448h.005c6.554 0 11.89-5.335 11.893-11.893a11.821 11.821 0 00-3.48-8.413z"/>
                                    </svg>
                                    WhatsApp
                                </a>
                                <a href="https://instagram.com/dshop4101" target="_blank" class="inline-flex items-center gap-2 rounded-xl bg-gradient-to-r from-pink-500 via-purple-500 to-orange-500 px-4 py-2.5 text-white font-semibold hover:from-pink-600 hover:via-purple-600 hover:to-orange-600 transition shadow-md hover:shadow-lg transform hover:scale-105">
                                    <svg class="h-5 w-5" fill="currentColor" viewBox="0 0 24 24">
                                        <path d="M12 2.163c3.204 0 3.584.012 4.85.07 3.252.148 4.771 1.691 4.919 4.919.058 1.265.069 1.645.069 4.849 0 3.205-.012 3.584-.069 4.849-.149 3.225-1.664 4.771-4.919 4.919-1.266.058-1.644.07-4.85.07-3.204 0-3.584-.012-4.849-.07-3.26-.149-4.771-1.699-4.919-4.92-.058-1.265-.07-1.644-.07-4.849 0-3.204.013-3.583.07-4.849.149-3.227 1.664-4.771 4.919-4.919 1.266-.057 1.645-.069 4.849-.069zm0-2.163c-3.259 0-3.667.014-4.947.072-4.358.2-6.78 2.618-6.98 6.98-.059 1.281-.073 1.689-.073 4.948 0 3.259.014 3.668.072 4.948.2 4.358 2.618 6.78 6.98 6.98 1.281.058 1.689.072 4.948.072 3.259 0 3.668-.014 4.948-.072 4.354-.2 6.782-2.618 6.979-6.98.059-1.28.073-1.689.073-4.948 0-3.259-.014-3.667-.072-4.947-.196-4.354-2.617-6.78-6.979-6.98-1.281-.059-1.69-.073-4.949-.073zm0 5.838c-3.403 0-6.162 2.759-6.162 6.162s2.759 6.163 6.162 6.163 6.162-2.759 6.162-6.163c0-3.403-2.759-6.162-6.162-6.162zm0 10.162c-2.209 0-4-1.79-4-4 0-2.209 1.791-4 4-4s4 1.791 4 4c0 2.21-1.791 4-4 4zm6.406-11.845c-.796 0-1.441.645-1.441 1.44s.645 1.44 1.441 1.44c.795 0 1.439-.645 1.439-1.44s-.644-1.44-1.439-1.44z"/>
                                    </svg>
                                    Instagram
                                </a>
                            </div>
                        </div>
                        <div>
                            <h4 class="font-semibold text-slate-900">Ekspedisi & Pembayaran</h4>
                            <ul class="mt-2 text-slate-600 space-y-1">
                                <li>• Pembayaran ditanggung pembeli</li>
                                <li>• Pilihan ekspedisi: JNE, J&T, Anteraja</li>
                                <li>• Pembayaran via Midtrans, Transfer, atau Cash</li>
                            </ul>
                        </div>
                    </div>
                    <div class="border-t border-[#FAD4C2] bg-[#FFE6D8]">
                        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-4 text-xs text-slate-600 flex flex-col sm:flex-row justify-between gap-2">
                            <span>&copy; {{ date('Y') }} {{ $brandName }}. Semua Hak Dilindungi.</span>
                            <span>Dibangun untuk mendukung UMKM bertumbuh secara profesional.</span>
                        </div>
                    </div>
                </footer>
            @endunless
        </div>
    </body>
</html>
