<x-app-layout>
    <section class="py-10">
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 space-y-8">
            <header class="space-y-3 text-center">
                <h1 class="text-3xl font-semibold text-slate-900">Jurnal UMKM</h1>
                <p class="text-sm text-slate-500">Inspirasi bisnis, tips pemasaran, dan update tren produk terbaru dari D'Shop.</p>
            </header>

            <form method="GET" action="{{ route('journals.index') }}" class="flex flex-col gap-3 rounded-3xl border border-[#FAD4C2] bg-white p-4 shadow-sm sm:flex-row sm:items-center">
                <div class="flex-1">
                    <input type="text" name="search" value="{{ $search }}" placeholder="Cari artikel jurnal..." class="w-full rounded-full border border-[#FAD4C2] bg-[#FFF8F3] px-4 py-2 text-sm focus:border-[#C26A3D] focus:ring-0" />
                </div>
                <button type="submit" class="inline-flex items-center rounded-full bg-[#C26A3D] px-5 py-2 text-sm font-semibold text-white hover:bg-[#a85327] transition">Cari Artikel</button>
            </form>

            <div class="grid gap-6 sm:grid-cols-2">
                @forelse ($journals as $journal)
                    <article class="group flex flex-col rounded-3xl border border-[#FAD4C2]/70 bg-white shadow-sm transition hover:-translate-y-1 hover:border-[#C26A3D] hover:shadow-lg">
                        <a href="{{ route('journals.show', $journal) }}" class="block">
                            <div class="relative h-48 overflow-hidden rounded-t-3xl bg-[#FFE7D4]">
                                <img src="{{ $journal->hero_image ?? 'https://images.unsplash.com/photo-1515377905703-c4788e51af15?auto=format&fit=crop&w=1500&q=80' }}" alt="{{ $journal->title }}" class="absolute inset-0 h-full w-full object-cover transition duration-300 group-hover:scale-105">
                            </div>
                            <div class="space-y-3 px-6 py-5">
                                <span class="text-xs font-semibold uppercase tracking-wider text-[#C26A3D]">{{ $journal->published_at?->format('d M Y') }}</span>
                                <h2 class="text-lg font-semibold text-slate-900 leading-snug">{{ $journal->title }}</h2>
                                <p class="text-sm text-slate-500 h-[60px] overflow-hidden">{{ $journal->excerpt }}</p>
                                <span class="inline-flex items-center text-sm font-semibold text-[#C26A3D]">Baca selengkapnya &rarr;</span>
                            </div>
                        </a>
                    </article>
                @empty
                    <div class="rounded-3xl border border-[#FAD4C2] bg-white p-10 text-center text-slate-500 sm:col-span-2">
                        Belum ada artikel jurnal dipublikasikan.
                    </div>
                @endforelse
            </div>

            <div class="text-center">
                {{ $journals->onEachSide(1)->links() }}
            </div>
        </div>
    </section>
</x-app-layout>
