<table>
    <thead>
        <tr>
            <th colspan="5" style="font-weight:bold; font-size:14px;">Laporan Penghasilan - {{ $periodLabel }}</th>
        </tr>
        <tr>
            <th colspan="5" style="font-size:12px;">Dihasilkan pada {{ $generatedAt->format('d M Y H:i') }}</th>
        </tr>
        <tr></tr>
        <tr>
            <th style="border:1px solid #f4c7ad;">Invoice</th>
            <th style="border:1px solid #f4c7ad;">Tanggal</th>
            <th style="border:1px solid #f4c7ad;">Pelanggan</th>
            <th style="border:1px solid #f4c7ad;">Produk</th>
            <th style="border:1px solid #f4c7ad;">Items</th>
            <th style="border:1px solid #f4c7ad;">Subtotal</th>
            <th style="border:1px solid #f4c7ad;">Diskon</th>
            <th style="border:1px solid #f4c7ad;">Ongkir</th>
            <th style="border:1px solid #f4c7ad;">Total Bersih</th>
            <th style="border:1px solid #f4c7ad;">Metode</th>
        </tr>
    </thead>
    <tbody>
        @foreach ($orders as $order)
            @php
                $products = $order->items->pluck('product_name')->filter()->unique()->values();
                $productsLabel = $products->isNotEmpty() ? $products->join(', ') : '-';
            @endphp
            <tr>
                <td style="border:1px solid #f4c7ad;">{{ $order->invoice_number }}</td>
                <td style="border:1px solid #f4c7ad;">{{ $order->paid_at?->format('d M Y H:i') }}</td>
                <td style="border:1px solid #f4c7ad;">{{ $order->customer_name ?? '-' }}</td>
                <td style="border:1px solid #f4c7ad;">{{ $productsLabel }}</td>
                <td style="border:1px solid #f4c7ad;">{{ $order->total_items }}</td>
                <td style="border:1px solid #f4c7ad;">Rp{{ number_format($order->subtotal_amount, 0, ',', '.') }}</td>
                <td style="border:1px solid #f4c7ad;">Rp{{ number_format($order->discount_amount ?? 0, 0, ',', '.') }}</td>
                <td style="border:1px solid #f4c7ad;">Rp{{ number_format($order->shipping_cost ?? 0, 0, ',', '.') }}</td>
                <td style="border:1px solid #f4c7ad;">Rp{{ number_format($order->net_income, 0, ',', '.') }}</td>
                <td style="border:1px solid #f4c7ad;">{{ strtoupper($order->payment_method) }}</td>
            </tr>
        @endforeach
        <tr>
            <td colspan="8" style="border:1px solid #f4c7ad; font-weight:bold;">Total</td>
            <td style="border:1px solid #f4c7ad; font-weight:bold;">{{ $totalIncome }}</td>
            <td style="border:1px solid #f4c7ad;"></td>
        </tr>
    </tbody>
</table>
