<x-app-layout>
    <section class="py-10">
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 space-y-6">
            <header class="space-y-1">
                <h1 class="text-2xl font-semibold text-slate-900">{{ $order->invoice_number }}</h1>
                <p class="text-xs text-slate-500">{{ $order->created_at->format('d M Y, H:i') }}  Total Rp{{ number_format($order->grand_total, 0, ',', '.') }}</p>
            </header>

            <div class="rounded-3xl border border-[#FAD4C2] bg-white p-6 shadow-sm space-y-3 text-sm text-slate-600">
                <p><strong class="text-slate-900">Pelanggan:</strong> {{ $order->shipping_address['recipient_name'] ?? 'Walk-in' }}</p>
                <p><strong class="text-slate-900">Kontak:</strong> {{ $order->shipping_address['phone'] ?? '-' }}</p>
                <p><strong class="text-slate-900">Status:</strong> {{ strtoupper($order->payment_status) }}</p>
            </div>

            <div class="rounded-3xl border border-[#FAD4C2] bg-white p-6 shadow-sm space-y-3 text-sm text-slate-600">
                <h2 class="text-lg font-semibold text-slate-900">Detail Item</h2>
                @foreach ($order->items as $item)
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="font-semibold text-slate-900">{{ $item->product_name }}</p>
                            <span class="text-xs">{{ $item->quantity }} x Rp{{ number_format($item->unit_price, 0, ',', '.') }}</span>
                        </div>
                        <p class="font-semibold text-[#C26A3D]">Rp{{ number_format($item->subtotal, 0, ',', '.') }}</p>
                    </div>
                @endforeach
                <hr class="border-[#FAD4C2]">
                <div class="flex justify-between text-base font-semibold text-slate-900">
                    <span>Total</span>
                    <span>Rp{{ number_format($order->grand_total, 0, ',', '.') }}</span>
                </div>
            </div>

            <div class="flex gap-3">
                <form method="POST" action="{{ route('cashier.orders.markPaid', $order) }}">
                    @csrf
                    <button type="submit" class="inline-flex items-center rounded-full bg-[#C26A3D] px-5 py-3 text-sm font-semibold text-white hover:bg-[#a85327] transition">Tandai Sudah Dibayar</button>
                </form>
                <a href="{{ route('cashier.orders.print', $order) }}" target="_blank" class="inline-flex items-center rounded-full border border-[#C26A3D] px-5 py-3 text-sm font-semibold text-[#C26A3D] hover:bg-[#FFE2CF] transition">Cetak Struk</a>
            </div>
        </div>
    </section>
</x-app-layout>
