<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pembayaran Berhasil</title>
    <style>
        body {
            font-family: 'Poppins', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, sans-serif;
            line-height: 1.6;
            color: #334155;
            background-color: #f8fafc;
            margin: 0;
            padding: 0;
        }
        .email-container {
            max-width: 600px;
            margin: 0 auto;
            background-color: #ffffff;
            border-radius: 12px;
            overflow: hidden;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }
        .email-header {
            background: linear-gradient(135deg, #C26A3D 0%, #F5703B 100%);
            padding: 30px 20px;
            text-align: center;
            color: #ffffff;
        }
        .email-header h1 {
            margin: 0;
            font-size: 24px;
            font-weight: 700;
        }
        .email-body {
            padding: 30px 20px;
        }
        .success-icon {
            text-align: center;
            font-size: 48px;
            margin-bottom: 20px;
        }
        .greeting {
            font-size: 18px;
            font-weight: 600;
            color: #1e293b;
            margin-bottom: 10px;
        }
        .message {
            color: #64748b;
            margin-bottom: 30px;
        }
        .order-details {
            background-color: #f8fafc;
            border-radius: 8px;
            padding: 20px;
            margin-bottom: 20px;
        }
        .order-details h2 {
            font-size: 16px;
            font-weight: 600;
            color: #1e293b;
            margin-bottom: 15px;
            padding-bottom: 10px;
            border-bottom: 2px solid #e2e8f0;
        }
        .detail-row {
            display: flex;
            justify-content: space-between;
            padding: 8px 0;
            border-bottom: 1px solid #e2e8f0;
        }
        .detail-row:last-child {
            border-bottom: none;
        }
        .detail-label {
            color: #64748b;
            font-weight: 500;
        }
        .detail-value {
            color: #1e293b;
            font-weight: 600;
        }
        .total-row {
            background-color: #fff7ed;
            padding: 15px;
            border-radius: 6px;
            margin-top: 15px;
        }
        .total-label {
            font-size: 18px;
            font-weight: 700;
            color: #C26A3D;
        }
        .total-value {
            font-size: 20px;
            font-weight: 700;
            color: #C26A3D;
        }
        .items-list {
            margin-top: 20px;
        }
        .item-row {
            display: flex;
            justify-content: space-between;
            padding: 10px 0;
            border-bottom: 1px solid #e2e8f0;
        }
        .item-row:last-child {
            border-bottom: none;
        }
        .item-name {
            font-weight: 500;
            color: #1e293b;
        }
        .item-qty {
            color: #64748b;
            font-size: 14px;
        }
        .item-price {
            font-weight: 600;
            color: #1e293b;
        }
        .email-footer {
            background-color: #f8fafc;
            padding: 20px;
            text-align: center;
            color: #64748b;
            font-size: 14px;
        }
        .button {
            display: inline-block;
            padding: 12px 24px;
            background: linear-gradient(135deg, #C26A3D 0%, #F5703B 100%);
            color: #ffffff;
            text-decoration: none;
            border-radius: 8px;
            font-weight: 600;
            margin-top: 20px;
        }
        .status-badge {
            display: inline-block;
            padding: 6px 12px;
            background-color: #10b981;
            color: #ffffff;
            border-radius: 6px;
            font-size: 12px;
            font-weight: 600;
        }
    </style>
</head>
<body>
    <div class="email-container">
        <div class="email-header">
            <h1>🎉 Pembayaran Berhasil!</h1>
        </div>
        
        <div class="email-body">
            <div class="success-icon">✅</div>
            
            <p class="greeting">Halo {{ $order->customer_name ?? 'Pelanggan' }},</p>
            
            <p class="message">
                Terima kasih! Pembayaran Anda telah kami terima dan pesanan Anda sedang diproses.
            </p>
            
            <div class="order-details">
                <h2>📋 Detail Pesanan</h2>
                
                <div class="detail-row">
                    <span class="detail-label">No. Invoice:</span>
                    <span class="detail-value">{{ $order->invoice_number }}</span>
                </div>
                
                <div class="detail-row">
                    <span class="detail-label">Tanggal Pesanan:</span>
                    <span class="detail-value">{{ $order->created_at->translatedFormat('d F Y, H:i') }}</span>
                </div>
                
                @if($order->paid_at)
                <div class="detail-row">
                    <span class="detail-label">Tanggal Pembayaran:</span>
                    <span class="detail-value">{{ $order->paid_at->translatedFormat('d F Y, H:i') }}</span>
                </div>
                @endif
                
                <div class="detail-row">
                    <span class="detail-label">Status:</span>
                    <span class="detail-value">
                        <span class="status-badge">Pembayaran Berhasil ✅</span>
                    </span>
                </div>
                
                @if($order->items->count() > 0)
                <div class="items-list">
                    <h3 style="font-size: 14px; font-weight: 600; color: #1e293b; margin-bottom: 10px;">Item Pesanan:</h3>
                    @foreach($order->items as $item)
                    <div class="item-row">
                        <div>
                            <div class="item-name">{{ $item->product_name }}</div>
                            <div class="item-qty">Qty: {{ $item->quantity }} × Rp{{ number_format($item->unit_price, 0, ',', '.') }}</div>
                        </div>
                        <div class="item-price">Rp{{ number_format($item->subtotal, 0, ',', '.') }}</div>
                    </div>
                    @endforeach
                </div>
                @endif
                
                @if($order->shipping_cost > 0)
                <div class="detail-row">
                    <span class="detail-label">Biaya Pengiriman:</span>
                    <span class="detail-value">Rp{{ number_format($order->shipping_cost, 0, ',', '.') }}</span>
                </div>
                @endif
                
                @if($order->discount_amount > 0)
                <div class="detail-row">
                    <span class="detail-label">Diskon:</span>
                    <span class="detail-value" style="color: #10b981;">- Rp{{ number_format($order->discount_amount, 0, ',', '.') }}</span>
                </div>
                @endif
                
                <div class="total-row">
                    <div class="detail-row">
                        <span class="total-label">Total Pembayaran:</span>
                        <span class="total-value">Rp{{ number_format($order->grand_total, 0, ',', '.') }}</span>
                    </div>
                </div>
            </div>
            
            <p class="message">
                📦 Pesanan Anda sedang diproses dan akan segera dikirim. Kami akan mengirimkan notifikasi pengiriman melalui email dan WhatsApp.
            </p>
            
            <div style="text-align: center;">
                <a href="{{ route('orders.show', $order) }}" class="button">Lihat Detail Pesanan</a>
            </div>
        </div>
        
        <div class="email-footer">
            <p style="margin: 0 0 10px 0;">
                <strong>{{ $storeName }}</strong><br>
                {{ $storeTagline }}
            </p>
            <p style="margin: 0; font-size: 12px;">
                Terima kasih telah berbelanja di {{ $storeName }}! 🛍️
            </p>
        </div>
    </div>
</body>
</html>





