@php
    $user = auth()->user();
    $statusColors = [
        'pending' => 'bg-amber-100 text-amber-700 dark:bg-amber-900/30 dark:text-amber-300',
        'awaiting_payment' => 'bg-amber-100 text-amber-700 dark:bg-amber-900/30 dark:text-amber-300',
        'processing' => 'bg-sky-100 text-sky-700 dark:bg-sky-900/30 dark:text-sky-300',
        'ready_to_ship' => 'bg-blue-100 text-blue-700 dark:bg-blue-900/30 dark:text-blue-300',
        'shipping' => 'bg-blue-100 text-blue-700 dark:bg-blue-900/30 dark:text-blue-300',
        'completed' => 'bg-emerald-100 text-emerald-700 dark:bg-emerald-900/30 dark:text-emerald-300',
        'cancelled' => 'bg-rose-100 text-rose-700 dark:bg-rose-900/30 dark:text-rose-300',
    ];
    $statusLabels = [
        'pending' => 'Menunggu',
        'awaiting_payment' => 'Menunggu Bayar',
        'processing' => 'Diproses',
        'ready_to_ship' => 'Siap Kirim',
        'shipping' => 'Dikirim',
        'completed' => 'Selesai',
        'cancelled' => 'Dibatalkan',
    ];
    $paymentLabels = [
        'pending' => 'Belum Bayar',
        'paid' => 'Lunas',
        'failed' => 'Gagal',
        'refunded' => 'Refund',
    ];
    $paymentColors = [
        'pending' => 'bg-amber-100 text-amber-700 dark:bg-amber-900/30 dark:text-amber-300',
        'paid' => 'bg-emerald-100 text-emerald-700 dark:bg-emerald-900/30 dark:text-emerald-300',
        'failed' => 'bg-rose-100 text-rose-700 dark:bg-rose-900/30 dark:text-rose-300',
        'refunded' => 'bg-slate-100 text-slate-700 dark:bg-slate-800 dark:text-slate-300',
    ];
    $adminWhatsapp = \App\Models\StoreSetting::getValue('store.whatsapp_admin', '6283879865012');
@endphp

<x-app-layout>
    <x-slot name="header">
        <div class="flex flex-col gap-3 sm:flex-row sm:items-center sm:justify-between">
            <div>
                <p class="text-xs font-semibold uppercase tracking-wide text-[#C26A3D]/80 dark:text-amber-400/80">Selamat datang kembali</p>
                <h1 class="text-3xl font-bold text-slate-900 dark:text-slate-100">Hai, {{ $user->name }} 👋</h1>
                <p class="text-sm text-slate-500 dark:text-slate-400 mt-1">Ringkasan pesanan dan aktivitas terbaru Anda.</p>
            </div>
            <div class="flex flex-wrap gap-2">
                <a href="{{ route('products.index') }}" class="inline-flex items-center gap-2 rounded-xl border border-[#C26A3D] px-4 py-2.5 text-sm font-semibold text-[#C26A3D] dark:text-amber-400 dark:border-amber-400 transition hover:bg-[#FFE2CF] dark:hover:bg-amber-900/30">
                    <svg class="h-4 w-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z"/></svg>
                    Belanja Lagi
                </a>
                <a href="{{ route('orders.index') }}" class="inline-flex items-center gap-2 rounded-xl bg-gradient-to-r from-[#C26A3D] to-[#F5703B] px-4 py-2.5 text-sm font-semibold text-white shadow-md hover:shadow-lg transition">
                    <svg class="h-4 w-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"/></svg>
                    Pesanan Saya
                </a>
            </div>
        </div>
    </x-slot>

    <section class="py-8">
        <div class="max-w-7xl mx-auto space-y-8 px-4 sm:px-6 lg:px-8">

            {{-- Stats Cards --}}
            <div class="grid gap-4 sm:grid-cols-2 lg:grid-cols-4">
                <div class="rounded-2xl border border-[#FAD4C2]/60 dark:border-slate-800 bg-white dark:bg-slate-900 p-5 shadow-sm hover:shadow-md transition">
                    <div class="flex items-center gap-4">
                        <div class="flex h-12 w-12 items-center justify-center rounded-xl bg-gradient-to-br from-[#FFE7D6] to-[#FFECE2] dark:from-amber-900/30 dark:to-amber-800/20">
                            <svg class="h-6 w-6 text-[#C26A3D] dark:text-amber-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"/>
                            </svg>
                        </div>
                        <div>
                            <p class="text-xs font-medium text-slate-500 dark:text-slate-400">Total Pesanan</p>
                            <p class="text-2xl font-bold text-slate-900 dark:text-white">{{ number_format($stats['totalOrders']) }}</p>
                        </div>
                    </div>
                </div>
                <div class="rounded-2xl border border-[#FAD4C2]/60 dark:border-slate-800 bg-white dark:bg-slate-900 p-5 shadow-sm hover:shadow-md transition">
                    <div class="flex items-center gap-4">
                        <div class="flex h-12 w-12 items-center justify-center rounded-xl bg-gradient-to-br from-emerald-100 to-emerald-50 dark:from-emerald-900/30 dark:to-emerald-800/20">
                            <svg class="h-6 w-6 text-emerald-600 dark:text-emerald-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                        </div>
                        <div>
                            <p class="text-xs font-medium text-slate-500 dark:text-slate-400">Selesai</p>
                            <p class="text-2xl font-bold text-emerald-600 dark:text-emerald-400">{{ number_format($stats['completedOrders']) }}</p>
                        </div>
                    </div>
                </div>
                <div class="rounded-2xl border border-[#FAD4C2]/60 dark:border-slate-800 bg-white dark:bg-slate-900 p-5 shadow-sm hover:shadow-md transition">
                    <div class="flex items-center gap-4">
                        <div class="flex h-12 w-12 items-center justify-center rounded-xl bg-gradient-to-br from-amber-100 to-amber-50 dark:from-amber-900/30 dark:to-amber-800/20">
                            <svg class="h-6 w-6 text-amber-600 dark:text-amber-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                        </div>
                        <div>
                            <p class="text-xs font-medium text-slate-500 dark:text-slate-400">Belum Bayar</p>
                            <p class="text-2xl font-bold text-amber-600 dark:text-amber-400">{{ number_format($stats['waitingPayment']) }}</p>
                        </div>
                    </div>
                </div>
                <div class="rounded-2xl border border-[#FAD4C2]/60 dark:border-slate-800 bg-white dark:bg-slate-900 p-5 shadow-sm hover:shadow-md transition">
                    <div class="flex items-center gap-4">
                        <div class="flex h-12 w-12 items-center justify-center rounded-xl bg-gradient-to-br from-[#FFE2CF] to-[#FFDDF5] dark:from-pink-900/30 dark:to-pink-800/20">
                            <svg class="h-6 w-6 text-[#C26A3D] dark:text-pink-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                        </div>
                        <div>
                            <p class="text-xs font-medium text-slate-500 dark:text-slate-400">Total Belanja</p>
                            <p class="text-xl font-bold text-[#C26A3D] dark:text-pink-400">Rp{{ number_format($stats['totalSpend'], 0, ',', '.') }}</p>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Main Content Grid --}}
            <div class="grid gap-6 lg:grid-cols-[1.5fr,1fr]">
                {{-- Left Column --}}
                <div class="space-y-6">
                    {{-- Monthly Summary Card --}}
                    <div class="rounded-3xl bg-gradient-to-br from-[#FFE7D6] via-[#FFECE2] to-[#FFDDF5] dark:from-slate-800 dark:via-slate-800 dark:to-slate-900 p-6 shadow-sm">
                        <div class="flex flex-col gap-4 lg:flex-row lg:items-start lg:justify-between">
                            <div>
                                <h2 class="text-xl font-bold text-slate-900 dark:text-white">📊 Ringkasan Bulan Ini</h2>
                                <p class="text-sm text-slate-600 dark:text-slate-400 mt-1">Statistik pesanan bulan {{ now()->translatedFormat('F Y') }}</p>
                            </div>
                            <div class="flex flex-wrap gap-3">
                                <div class="flex flex-col items-center justify-center rounded-2xl bg-white/80 dark:bg-slate-800/80 px-5 py-3 text-center shadow-sm backdrop-blur-sm">
                                    <p class="text-xs uppercase text-slate-500 dark:text-slate-400 font-medium">Pesanan</p>
                                    <p class="text-2xl font-bold text-slate-900 dark:text-white">{{ number_format($insights['ordersThisMonth']) }}</p>
                                </div>
                                <div class="flex flex-col items-center justify-center rounded-2xl bg-white/80 dark:bg-slate-800/80 px-5 py-3 text-center shadow-sm backdrop-blur-sm">
                                    <p class="text-xs uppercase text-slate-500 dark:text-slate-400 font-medium">Pengeluaran</p>
                                    <p class="text-xl font-bold text-[#C26A3D] dark:text-amber-400">Rp{{ number_format($insights['spendThisMonth'], 0, ',', '.') }}</p>
                                </div>
                                <div class="flex flex-col items-center justify-center rounded-2xl bg-white/80 dark:bg-slate-800/80 px-5 py-3 text-center shadow-sm backdrop-blur-sm">
                                    <p class="text-xs uppercase text-slate-500 dark:text-slate-400 font-medium">Rata-rata</p>
                                    <p class="text-xl font-bold text-slate-900 dark:text-white">Rp{{ number_format($insights['averageOrderValue'], 0, ',', '.') }}</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    {{-- Quick Actions --}}
                    <div class="grid gap-3 sm:grid-cols-3">
                        <a href="{{ route('orders.index') }}" class="group flex items-center justify-between rounded-2xl border border-[#FAD4C2] dark:border-slate-800 bg-white dark:bg-slate-900 px-4 py-4 text-sm font-semibold text-slate-700 dark:text-slate-300 shadow-sm hover:shadow-md hover:border-[#C26A3D] dark:hover:border-amber-500 transition">
                            <span class="flex items-center gap-3">
                                <span class="flex h-8 w-8 items-center justify-center rounded-lg bg-blue-100 dark:bg-blue-900/30 text-blue-600 dark:text-blue-400">📦</span>
                                Lacak Pesanan
                            </span>
                            <span class="flex h-6 w-6 items-center justify-center rounded-full bg-[#C26A3D]/10 text-[#C26A3D] dark:text-amber-400 group-hover:bg-[#C26A3D] group-hover:text-white transition">→</span>
                        </a>
                        <a href="{{ route('account.notifications') }}" class="group flex items-center justify-between rounded-2xl border border-[#FAD4C2] dark:border-slate-800 bg-white dark:bg-slate-900 px-4 py-4 text-sm font-semibold text-slate-700 dark:text-slate-300 shadow-sm hover:shadow-md hover:border-[#C26A3D] dark:hover:border-amber-500 transition">
                            <span class="flex items-center gap-3">
                                <span class="flex h-8 w-8 items-center justify-center rounded-lg bg-amber-100 dark:bg-amber-900/30 text-amber-600 dark:text-amber-400">🔔</span>
                                Notifikasi
                                @if(($unpaidOrdersCount ?? 0) > 0)
                                    <span class="inline-flex items-center justify-center min-w-[18px] h-[18px] px-1 rounded-full bg-red-500 text-[10px] font-bold text-white">{{ $unpaidOrdersCount }}</span>
                                @endif
                            </span>
                            <span class="flex h-6 w-6 items-center justify-center rounded-full bg-[#C26A3D]/10 text-[#C26A3D] dark:text-amber-400 group-hover:bg-[#C26A3D] group-hover:text-white transition">→</span>
                        </a>
                        <a href="https://wa.me/{{ $adminWhatsapp }}" class="group flex items-center justify-between rounded-2xl border border-[#FAD4C2] dark:border-slate-800 bg-white dark:bg-slate-900 px-4 py-4 text-sm font-semibold text-slate-700 dark:text-slate-300 shadow-sm hover:shadow-md hover:border-emerald-500 transition">
                            <span class="flex items-center gap-3">
                                <span class="flex h-8 w-8 items-center justify-center rounded-lg bg-emerald-100 dark:bg-emerald-900/30 text-emerald-600 dark:text-emerald-400">💬</span>
                                WhatsApp Admin
                            </span>
                            <span class="flex h-6 w-6 items-center justify-center rounded-full bg-emerald-500/10 text-emerald-600 dark:text-emerald-400 group-hover:bg-emerald-500 group-hover:text-white transition">→</span>
                        </a>
                    </div>
                </div>

                {{-- Right Column - Active Order --}}
                <div class="space-y-4">
                    @if($nextOrder)
                        <div class="rounded-3xl border border-[#FAD4C2] dark:border-slate-800 bg-white dark:bg-slate-900 p-6 shadow-sm">
                            <div class="flex items-center gap-2 mb-4">
                                <span class="flex h-8 w-8 items-center justify-center rounded-lg bg-blue-100 dark:bg-blue-900/30 text-blue-600 dark:text-blue-400">📦</span>
                                <h3 class="text-base font-bold text-slate-900 dark:text-white">Pesanan Aktif</h3>
                            </div>
                            <div class="space-y-3">
                                <div class="flex items-center justify-between">
                                    <span class="text-sm text-slate-500 dark:text-slate-400">Invoice</span>
                                    <span class="font-semibold text-slate-900 dark:text-white">{{ $nextOrder->invoice_number }}</span>
                                </div>
                                <div class="flex items-center justify-between">
                                    <span class="text-sm text-slate-500 dark:text-slate-400">Status</span>
                                    <span class="inline-flex rounded-full px-3 py-1 text-xs font-semibold {{ $statusColors[$nextOrder->status] ?? 'bg-slate-100 text-slate-600' }}">
                                        {{ $statusLabels[$nextOrder->status] ?? ucfirst($nextOrder->status) }}
                                    </span>
                                </div>
                                <div class="flex items-center justify-between">
                                    <span class="text-sm text-slate-500 dark:text-slate-400">Total</span>
                                    <span class="font-bold text-[#C26A3D] dark:text-amber-400">Rp{{ number_format($nextOrder->grand_total, 0, ',', '.') }}</span>
                                </div>
                            </div>
                            <div class="mt-5 flex items-center justify-between gap-3">
                                <span class="text-xs text-slate-500 dark:text-slate-400">{{ $nextOrder->updated_at->diffForHumans() }}</span>
                                <a href="{{ route('orders.show', $nextOrder) }}" class="inline-flex items-center gap-2 rounded-xl bg-gradient-to-r from-[#C26A3D] to-[#F5703B] px-4 py-2 text-xs font-semibold text-white hover:shadow-md transition">
                                    Lihat Detail
                                    <svg class="h-3.5 w-3.5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/></svg>
                                </a>
                            </div>
                        </div>
                    @else
                        <div class="rounded-3xl border border-[#FAD4C2] dark:border-slate-800 bg-white dark:bg-slate-900 p-8 shadow-sm text-center">
                            <div class="mx-auto flex h-16 w-16 items-center justify-center rounded-2xl bg-slate-100 dark:bg-slate-800 text-4xl mb-4">📭</div>
                            <h3 class="text-base font-semibold text-slate-900 dark:text-white">Belum Ada Pesanan Aktif</h3>
                            <p class="text-sm text-slate-500 dark:text-slate-400 mt-1">Mulai belanja untuk membuat pesanan baru</p>
                            <a href="{{ route('products.index') }}" class="mt-4 inline-flex items-center gap-2 rounded-xl bg-gradient-to-r from-[#C26A3D] to-[#F5703B] px-5 py-2.5 text-sm font-semibold text-white hover:shadow-md transition">
                                Jelajahi Produk
                            </a>
                        </div>
                    @endif

                    {{-- Saved Addresses --}}
                    <div class="rounded-3xl border border-[#FAD4C2] dark:border-slate-800 bg-white dark:bg-slate-900 p-6 shadow-sm">
                        <div class="flex items-center justify-between mb-4">
                            <div class="flex items-center gap-2">
                                <span class="flex h-8 w-8 items-center justify-center rounded-lg bg-emerald-100 dark:bg-emerald-900/30 text-emerald-600 dark:text-emerald-400">📍</span>
                                <h3 class="text-base font-bold text-slate-900 dark:text-white">Alamat Pengiriman</h3>
                            </div>
                            <a href="{{ route('account.addresses') }}" class="text-xs font-semibold text-[#C26A3D] dark:text-amber-400 hover:underline">Kelola</a>
                        </div>
                        <div class="space-y-3">
                            @forelse ($savedAddresses as $address)
                                <div class="rounded-xl border border-[#FAD4C2]/60 dark:border-slate-800 bg-slate-50 dark:bg-slate-800/50 p-3">
                                    <div class="flex items-center justify-between mb-1">
                                        <p class="font-semibold text-sm text-slate-900 dark:text-white">{{ $address->label ?: 'Alamat' }}</p>
                                        @if($address->is_default)
                                            <span class="rounded-full bg-emerald-100 dark:bg-emerald-900/30 px-2 py-0.5 text-[10px] font-semibold text-emerald-700 dark:text-emerald-400">Utama</span>
                                        @endif
                                    </div>
                                    <p class="text-xs text-slate-500 dark:text-slate-400">{{ $address->recipient_name }} · {{ $address->phone }}</p>
                                    <p class="text-xs text-slate-500 dark:text-slate-400 truncate">{{ $address->address_line1 }}, {{ $address->city }}</p>
                                </div>
                            @empty
                                <p class="text-sm text-slate-500 dark:text-slate-400 text-center py-4">Belum ada alamat tersimpan.</p>
                            @endforelse
                        </div>
                    </div>
                </div>
            </div>

            {{-- Quick Navigation --}}
            <div class="grid gap-4 sm:grid-cols-3">
                <a href="{{ route('orders.index') }}" class="flex items-center gap-4 rounded-2xl border border-[#FAD4C2] dark:border-slate-800 bg-white dark:bg-slate-900 p-5 text-sm font-semibold text-slate-700 dark:text-slate-300 hover:bg-[#FFF7F2] dark:hover:bg-slate-800 hover:shadow-md transition">
                    <span class="flex h-10 w-10 items-center justify-center rounded-xl bg-blue-100 dark:bg-blue-900/30 text-xl">📦</span>
                    <span>Pesanan Saya</span>
                </a>
                <a href="{{ route('account.notifications') }}" class="flex items-center gap-4 rounded-2xl border border-[#FAD4C2] dark:border-slate-800 bg-white dark:bg-slate-900 p-5 text-sm font-semibold text-slate-700 dark:text-slate-300 hover:bg-[#FFF7F2] dark:hover:bg-slate-800 hover:shadow-md transition">
                    <span class="flex h-10 w-10 items-center justify-center rounded-xl bg-amber-100 dark:bg-amber-900/30 text-xl">🔔</span>
                    <span>Notifikasi</span>
                </a>
                <a href="{{ route('profile.edit') }}" class="flex items-center gap-4 rounded-2xl border border-[#FAD4C2] dark:border-slate-800 bg-white dark:bg-slate-900 p-5 text-sm font-semibold text-slate-700 dark:text-slate-300 hover:bg-[#FFF7F2] dark:hover:bg-slate-800 hover:shadow-md transition">
                    <span class="flex h-10 w-10 items-center justify-center rounded-xl bg-purple-100 dark:bg-purple-900/30 text-xl">👤</span>
                    <span>Profil & Alamat</span>
                </a>
            </div>

            {{-- Recent Orders Table --}}
            <div class="rounded-3xl border border-[#FAD4C2] dark:border-slate-800 bg-white dark:bg-slate-900 p-6 shadow-sm">
                <div class="flex items-center justify-between mb-6">
                    <h3 class="text-lg font-bold text-slate-900 dark:text-white flex items-center gap-2">
                        <span class="flex h-8 w-8 items-center justify-center rounded-lg bg-blue-100 dark:bg-blue-900/30 text-lg">📋</span>
                        Pesanan Terbaru
                    </h3>
                    <a href="{{ route('orders.index') }}" class="text-sm font-semibold text-[#C26A3D] dark:text-amber-400 hover:underline">Lihat Semua</a>
                </div>
                <div class="overflow-hidden rounded-2xl border border-[#FAD4C2]/60 dark:border-slate-800">
                    <div class="overflow-x-auto">
                        <table class="min-w-full divide-y divide-[#FAD4C2]/60 dark:divide-slate-800 text-sm">
                            <thead class="bg-[#FFF0E6] dark:bg-slate-800 text-left text-xs uppercase text-slate-500 dark:text-slate-400">
                                <tr>
                                    <th class="px-4 py-3 font-medium">Invoice</th>
                                    <th class="px-4 py-3 font-medium">Tanggal</th>
                                    <th class="px-4 py-3 font-medium">Total</th>
                                    <th class="px-4 py-3 font-medium">Status</th>
                                    <th class="px-4 py-3 font-medium">Pembayaran</th>
                                    <th class="px-4 py-3 text-right font-medium">Aksi</th>
                                </tr>
                            </thead>
                            <tbody class="divide-y divide-[#FAD4C2]/40 dark:divide-slate-800 bg-white dark:bg-slate-900">
                                @forelse ($recentOrders as $order)
                                    <tr class="transition hover:bg-[#FFF7F2] dark:hover:bg-slate-800">
                                        <td class="px-4 py-4 font-semibold text-slate-800 dark:text-slate-100">{{ $order->invoice_number }}</td>
                                        <td class="px-4 py-4 text-slate-600 dark:text-slate-400">{{ $order->created_at->format('d M Y') }}</td>
                                        <td class="px-4 py-4 font-semibold text-[#C26A3D] dark:text-amber-400">Rp{{ number_format($order->grand_total, 0, ',', '.') }}</td>
                                        <td class="px-4 py-4">
                                            <span class="inline-flex rounded-full px-2.5 py-1 text-[11px] font-semibold {{ $statusColors[$order->status] ?? 'bg-slate-100 text-slate-600' }}">
                                                {{ $statusLabels[$order->status] ?? ucfirst($order->status) }}
                                            </span>
                                        </td>
                                        <td class="px-4 py-4">
                                            <span class="inline-flex rounded-full px-2.5 py-1 text-[11px] font-semibold {{ $paymentColors[$order->payment_status] ?? 'bg-slate-100 text-slate-600' }}">
                                                {{ $paymentLabels[$order->payment_status] ?? ucfirst($order->payment_status) }}
                                            </span>
                                        </td>
                                        <td class="px-4 py-4 text-right">
                                            <a href="{{ route('orders.show', $order) }}" class="inline-flex items-center gap-1 rounded-lg border border-[#C26A3D] dark:border-amber-500 px-3 py-1.5 text-xs font-semibold text-[#C26A3D] dark:text-amber-400 hover:bg-[#FFE2CF] dark:hover:bg-amber-900/30 transition">
                                                Detail
                                            </a>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="6" class="px-4 py-12 text-center">
                                            <div class="text-4xl mb-2">📭</div>
                                            <p class="text-slate-500 dark:text-slate-400">Belum ada pesanan.</p>
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </section>
</x-app-layout>
