@props(['name' => 'star', 'class' => 'h-5 w-5'])
@switch($name)
    @case('heart')
        <svg {{ $attributes->merge(['class' => $class]) }} viewBox="0 0 24 24" fill="none" stroke="currentColor">
            <path stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" d="M20.84 4.61a5.5 5.5 0 0 0-7.78 0L12 5.67l-1.06-1.06a5.5 5.5 0 0 0-7.78 7.78L12 21.23l8.84-8.84a5.5 5.5 0 0 0 0-7.78z"/>
        </svg>
        @break
    @case('bell')
        <svg {{ $attributes->merge(['class' => $class]) }} viewBox="0 0 24 24" fill="none" stroke="currentColor">
            <path stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" d="M15 17h5l-1.4-1.4A2 2 0 0 1 18 14.2V11a6 6 0 1 0-12 0v3.2c0 .5-.2 1-.6 1.4L4 17h5m6 0a3 3 0 0 1-6 0"/>
        </svg>
        @break
    @case('map-pin')
        <svg {{ $attributes->merge(['class' => $class]) }} viewBox="0 0 24 24" fill="none" stroke="currentColor">
            <path stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" d="M12 21s7-4.35 7-10a7 7 0 1 0-14 0c0 5.65 7 10 7 10z" />
            <circle cx="12" cy="11" r="3" stroke-width="1.6" />
        </svg>
        @break
    @case('plus')
        <svg {{ $attributes->merge(['class' => $class]) }} viewBox="0 0 24 24" fill="none" stroke="currentColor">
            <path stroke-width="1.8" stroke-linecap="round" d="M12 5v14M5 12h14"/>
        </svg>
        @break
    @case('pencil')
        <svg {{ $attributes->merge(['class' => $class]) }} viewBox="0 0 24 24" fill="none" stroke="currentColor">
            <path stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" d="M12 20h9"/>
            <path stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" d="M16.5 3.5a2.12 2.12 0 1 1 3 3L7 19l-4 1 1-4 12.5-12.5z"/>
        </svg>
        @break
    @case('trash')
        <svg {{ $attributes->merge(['class' => $class]) }} viewBox="0 0 28 28" fill="none" stroke="currentColor">
            <path stroke-width="1.4" stroke-linecap="round" stroke-linejoin="round" d="M5 8h18" />
            <rect x="6" y="10.5" width="16" height="12" rx="3" stroke-width="1.4" stroke-linejoin="round" />
            <path stroke-width="1.4" stroke-linecap="round" d="M9.5 10.5V6.5h9V10.5" />
            <line x1="11" y1="14.5" x2="11" y2="18.5" stroke-width="1.4" stroke-linecap="round" />
            <line x1="17" y1="14.5" x2="17" y2="18.5" stroke-width="1.4" stroke-linecap="round" />
        </svg>
        @break
    @default
        <svg {{ $attributes->merge(['class' => $class]) }} viewBox="0 0 24 24" fill="none" stroke="currentColor">
            <path stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" d="M12 17.27 18.18 21l-1.64-7.03L22 9.24l-7.19-.61L12 2 9.19 8.63 2 9.24l5.46 4.73L5.82 21z"/>
        </svg>
@endswitch
