@props(['title', 'value', 'subtitle' => null, 'variant' => 'primary', 'href' => null])
@php
    $variants = [
        'primary' => [
            'gradient' => 'from-blue-500 to-blue-600',
            'shadow' => 'shadow-blue-500/30',
            'icon' => '<svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7h8m0 0v8m0-8l-8 8-4-4-6 6"></path></svg>',
            'ring' => 'ring-blue-400/20'
        ],
        'info' => [
            'gradient' => 'from-indigo-500 to-purple-600',
            'shadow' => 'shadow-indigo-500/30',
            'icon' => '<svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 12l3-3 3 3 4-4M8 21l4-4 4 4M3 4h18M4 4h16v12a1 1 0 01-1 1H5a1 1 0 01-1-1V4z"></path></svg>',
            'ring' => 'ring-indigo-400/20'
        ],
        'success' => [
            'gradient' => 'from-emerald-500 to-teal-600',
            'shadow' => 'shadow-emerald-500/30',
            'icon' => '<svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>',
            'ring' => 'ring-emerald-400/20'
        ],
        'warning' => [
            'gradient' => 'from-amber-400 to-orange-500',
            'shadow' => 'shadow-amber-400/30',
            'icon' => '<svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>',
            'ring' => 'ring-amber-400/20'
        ],
        'danger' => [
            'gradient' => 'from-rose-500 to-pink-600',
            'shadow' => 'shadow-rose-500/30',
            'icon' => '<svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"></path></svg>',
            'ring' => 'ring-rose-400/20'
        ],
    ];
    $style = $variants[$variant] ?? $variants['primary'];
@endphp

<div class="group relative overflow-hidden rounded-3xl bg-gradient-to-br {{ $style['gradient'] }} p-6 shadow-xl {{ $style['shadow'] }} transition-all duration-300 hover:scale-[1.02] hover:shadow-2xl {{ $href ? 'hover:shadow-' . $style['shadow'] : '' }}">
    {{-- Background Pattern --}}
    <div class="absolute inset-0 opacity-10">
        <div class="absolute -right-4 -top-4 h-24 w-24 rounded-full bg-white/30 blur-2xl"></div>
        <div class="absolute -bottom-8 -left-8 h-32 w-32 rounded-full bg-white/20 blur-3xl"></div>
    </div>
    
    {{-- Icon Decoration --}}
    <div class="absolute right-4 top-4 text-white/20 transition-all duration-300 group-hover:text-white/30 group-hover:scale-110">
        {!! $style['icon'] !!}
    </div>

    <div class="relative z-10">
        <div class="flex items-center justify-between">
            <div class="rounded-xl bg-white/20 backdrop-blur-sm px-3 py-1.5 ring-1 ring-white/30">
                <span class="text-sm font-semibold text-white">{{ $title }}</span>
            </div>
        @if (! empty($href))
                <a href="{{ $href }}" class="inline-flex items-center gap-1 rounded-lg bg-white/10 px-3 py-1.5 text-[11px] font-medium text-white backdrop-blur-sm ring-1 ring-white/20 transition-all hover:bg-white/20 hover:ring-white/40">
                    <span>Detail</span>
                    <svg class="h-3 w-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                    </svg>
                </a>
        @endif
        </div>
        
        <p class="mt-5 text-4xl font-bold text-white drop-shadow-lg transition-all duration-300 group-hover:scale-105">
            {{ $value }}
        </p>
        
        <div class="mt-3 flex items-center gap-2">
            <div class="h-1 w-12 rounded-full bg-white/40"></div>
            <p class="text-sm text-white/90 font-medium">{{ $subtitle }}</p>
        </div>
    </div>

    {{-- Shine Effect on Hover --}}
    <div class="absolute inset-0 -translate-x-full bg-gradient-to-r from-transparent via-white/10 to-transparent transition-transform duration-700 group-hover:translate-x-full"></div>
</div>
