﻿<x-app-layout>
    @php($adminWhatsapp = $adminWhatsapp ?? \App\Models\StoreSetting::getValue('store.whatsapp_admin', '6283879865012'))
    @php($subtotal = $items->sum('subtotal'))
    @php($discountEstimate = (int) round($subtotal * 0.05))
    @php($totalEstimate = $subtotal - $discountEstimate + ($selectedShipping['cost'] ?? 0))
    <section class="py-10">
        <div class="max-w-5xl mx-auto px-4 sm:px-6 lg:px-8 space-y-6">
            <header class="space-y-2">
                <h1 class="text-2xl font-semibold text-slate-900">Checkout</h1>
                <p class="text-sm text-slate-500">Lengkapi data pengiriman dan pilih metode pembayaran favoritmu.</p>
            </header>

            @if($errors->any())
                <div class="rounded-2xl border border-red-200 bg-red-50 px-4 py-3 text-sm text-red-800">
                    <div class="flex items-start gap-2">
                        <svg class="h-5 w-5 text-red-600 mt-0.5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                        <div>
                            <p class="font-semibold">Ada masalah dengan form Anda:</p>
                            <ul class="mt-1 list-disc list-inside text-xs space-y-1">
                                @foreach($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    </div>
                </div>
            @endif

            <div class="grid gap-6 lg:grid-cols-[1.2fr,0.8fr]">
                <form method="POST" action="{{ route('checkout.store') }}" class="space-y-6">
                    @csrf
                    <div class="rounded-3xl border border-[#FAD4C2] bg-white p-6 shadow-sm space-y-4">
                        <h2 class="text-lg font-semibold text-slate-900">Informasi Pengiriman</h2>
                        <p class="text-xs text-slate-600 bg-[#FFF8F3] rounded-full px-4 py-2 inline-flex items-center gap-2">
                            <svg class="h-4 w-4 text-[#C26A3D]" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                            Lengkapi semua data dengan benar untuk pengiriman yang akurat
                        </p>
                        <div class="grid gap-4 sm:grid-cols-2">
                            <div>
                                <label class="text-xs font-semibold text-slate-600">Nama Penerima <span class="text-red-500">*</span></label>
                                <input type="text" name="recipient_name" value="{{ old('recipient_name', $defaultAddress?->recipient_name) }}" required placeholder="Masukkan nama lengkap penerima" class="mt-1 w-full rounded-full border border-[#FAD4C2] bg-[#FFF8F3] px-4 py-2 text-sm focus:border-[#C26A3D] focus:ring-0 placeholder:text-slate-400" />
                                @error('recipient_name')
                                    <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                                @enderror
                            </div>
                            <div>
                                <label class="text-xs font-semibold text-slate-600">Nomor Telepon <span class="text-red-500">*</span></label>
                                <input type="tel" name="phone" value="{{ old('phone', $defaultAddress?->phone) }}" required placeholder="08xxxxxxxxxx" class="mt-1 w-full rounded-full border border-[#FAD4C2] bg-[#FFF8F3] px-4 py-2 text-sm focus:border-[#C26A3D] focus:ring-0 placeholder:text-slate-400" />
                                @error('phone')
                                    <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                                @enderror
                            </div>
                        </div>
                        <div class="grid gap-4">
                            <div>
                                <label class="text-xs font-semibold text-slate-600">Alamat Lengkap <span class="text-red-500">*</span></label>
                                <input type="text" name="address_line1" value="{{ old('address_line1', $defaultAddress?->address_line1) }}" required placeholder="Jl. Nama Jalan, No. Rumah, RT/RW" class="mt-1 w-full rounded-full border border-[#FAD4C2] bg-[#FFF8F3] px-4 py-2 text-sm focus:border-[#C26A3D] focus:ring-0 placeholder:text-slate-400" />
                                @error('address_line1')
                                    <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                                @enderror
                            </div>
                            <div>
                                <label class="text-xs font-semibold text-slate-600">Detail Tambahan</label>
                                <input type="text" name="address_line2" value="{{ old('address_line2', $defaultAddress?->address_line2) }}" placeholder="Patokan / Keterangan tambahan (opsional)" class="mt-1 w-full rounded-full border border-[#FAD4C2] bg-[#FFF8F3] px-4 py-2 text-sm focus:border-[#C26A3D] focus:ring-0 placeholder:text-slate-400" />
                                @error('address_line2')
                                    <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                                @enderror
                            </div>
                        </div>
                        <div class="grid gap-4 sm:grid-cols-3">
                            @if($citySearchEnabled ?? false)
                                <div class="relative space-y-1">
                                    <div class="flex items-center justify-between gap-2">
                                        <label class="text-xs font-semibold text-slate-600">Kota/Kabupaten <span class="text-red-500">*</span></label>
                                        
                                    </div>
                                    <div class="relative">
                                        <input type="text" id="city-search" placeholder="Ketik minimal 3 huruf..." value="{{ old('city', $defaultAddress?->city) }}" required autocomplete="off" class="mt-1 w-full rounded-full border border-[#FAD4C2] bg-[#FFF8F3] px-4 py-2 pr-10 text-sm focus:border-[#C26A3D] focus:ring-0 placeholder:text-slate-400" />
                                        <div class="absolute right-3 top-1/2 -translate-y-1/2 mt-0.5">
                                            <svg id="city-search-icon" class="h-4 w-4 text-slate-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                                            </svg>
                                            <svg id="city-loading-icon" class="h-4 w-4 text-[#C26A3D] animate-spin hidden" fill="none" viewBox="0 0 24 24">
                                                <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                                                <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                                            </svg>
                                        </div>
                                    </div>
                                    <input type="hidden" name="city" id="city-name" value="{{ old('city', $defaultAddress?->city) }}">
                                    <input type="hidden" name="city_id" id="city-id" value="{{ old('city_id', $defaultAddress?->city_id) }}">
                                    <div id="city-results" class="absolute z-10 mt-1 hidden w-full max-h-64 overflow-y-auto rounded-2xl border border-[#FAD4C2] bg-white shadow-xl"></div>
                                    <p id="city-helper-text" class="mt-1 text-xs text-slate-500">Ketik nama kota untuk mencari</p>
                                    @error('city')
                                        <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                                    @enderror
                                </div>
                            @else
                                <div>
                                    <label class="text-xs font-semibold text-slate-600">Kota/Kabupaten <span class="text-red-500">*</span></label>
                                    <input type="text" name="city" value="{{ old('city', $defaultAddress?->city) }}" required class="mt-1 w-full rounded-full border border-[#FAD4C2] bg-[#FFF8F3] px-4 py-2 text-sm focus:border-[#C26A3D] focus:ring-0" />
                                    @error('city')
                                        <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                                    @enderror
                                </div>
                            @endif
                            <div>
                                <label class="text-xs font-semibold text-slate-600">Provinsi <span class="text-red-500">*</span></label>
                                <input type="text" name="province" id="province-name" value="{{ old('province', $defaultAddress?->province) }}" required class="mt-1 w-full rounded-full border border-[#FAD4C2] bg-[#FFF8F3] px-4 py-2 text-sm focus:border-[#C26A3D] focus:ring-0" {{ ($citySearchEnabled ?? false) ? 'readonly' : '' }} />
                                @error('province')
                                    <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                                @enderror
                            </div>
                            <div>
                                <label class="text-xs font-semibold text-slate-600">Kode Pos</label>
                                <input type="text" name="postal_code" value="{{ old('postal_code', $defaultAddress?->postal_code) }}" placeholder="12345" maxlength="10" class="mt-1 w-full rounded-full border border-[#FAD4C2] bg-[#FFF8F3] px-4 py-2 text-sm focus:border-[#C26A3D] focus:ring-0 placeholder:text-slate-400" />
                                <p class="mt-1 text-xs text-slate-500">Opsional</p>
                                @error('postal_code')
                                    <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                                @enderror
                            </div>
                        </div>
                        <label class="inline-flex items-center gap-2 text-xs font-semibold text-slate-600">
                            <input type="checkbox" name="save_address" value="1" class="h-4 w-4 rounded border-[#FAD4C2] text-[#C26A3D] focus:ring-[#C26A3D]" checked>
                            Simpan sebagai alamat utama
                        </label>
                    </div>

                    <div class="rounded-3xl border border-[#FAD4C2] bg-white p-6 shadow-sm space-y-4">
                        <div class="flex items-center justify-between gap-3 flex-wrap">
                            <div>
                                <h2 class="text-lg font-semibold text-slate-900">Pengiriman</h2>
                                <p class="text-xs text-slate-500">Estimasi ongkir realtime via {{ $shippingProviderLabel ?? "-" }}.</p>
                            </div>
                            <span class="inline-flex items-center gap-1 rounded-full border border-[#C26A3D] bg-[#FFF0E6] px-3 py-1 text-[11px] font-semibold text-[#C26A3D]">
                                <svg class="h-3.5 w-3.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12h3m6 0h9m-9 0l-4 4m4-4l-4-4"></path>
                                </svg> {{ $shippingProviderLabel ?? "-" }} </span>
                        </div>
                        
                        @if($rajaOngkirEnabled)
                            <div>
                                <div class="rounded-2xl border border-dashed border-[#FAD4C2] bg-[#FFF8F3] px-4 py-3 text-xs text-slate-600 mb-3">
                                    <div class="flex items-center gap-2">
                                        <span class="inline-flex h-5 w-5 items-center justify-center rounded-full bg-white text-[11px] font-semibold text-[#C26A3D]">1</span>
                                        <span>Pilih kota tujuan</span>
                                    </div>
                                    <div class="flex items-center gap-2 mt-2">
                                        <span class="inline-flex h-5 w-5 items-center justify-center rounded-full bg-white text-[11px] font-semibold text-[#C26A3D]">2</span>
                                        <span>Ongkir akan diambil otomatis setelah memilih kota</span>
                                    </div>
                                    <div class="flex items-center gap-2 mt-2">
                                        <span class="inline-flex h-5 w-5 items-center justify-center rounded-full bg-white text-[11px] font-semibold text-[#C26A3D]">3</span>
                                        <span>Pilih layanan kurir favoritmu</span>
                                    </div>
                                </div>
                                
                                <button type="button" id="check-shipping-btn" class="hidden inline-flex items-center gap-2 rounded-full bg-[#C26A3D] px-4 py-2 text-sm font-semibold text-white hover:bg-[#a85327] transition disabled:opacity-50 disabled:cursor-not-allowed">
                                    <svg class="h-4 w-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"></path>
                                    </svg>
                                    Cek Ongkir
                                </button>
                                
                                <div id="shipping-loading" class="hidden mt-3 flex items-center gap-2 text-sm text-slate-600">
                                    <svg class="animate-spin h-4 w-4" fill="none" viewBox="0 0 24 24">
                                        <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                                        <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                                    </svg>
                                    Memuat opsi pengiriman...
                                </div>
                                
                                <div id="shipping-error" class="hidden mt-3 rounded-2xl border border-red-200 bg-red-50 px-4 py-3 text-sm text-red-600"></div>
                                
                                <div id="shipping-options" class="hidden mt-4 space-y-2 max-h-80 overflow-y-auto">
                                    <!-- Shipping options will be loaded here -->
                                </div>

                                <div id="shipping-selection" class="hidden mt-4 rounded-2xl border border-[#C26A3D]/40 bg-[#FFF0E6] px-4 py-3 text-sm">
                                    <div class="flex items-start justify-between gap-3">
                                        <div>
                                            <p class="font-semibold text-slate-900" id="shipping-selection-label"></p>
                                            <p class="text-xs text-slate-600" id="shipping-selection-etd"></p>
                                        </div>
                                        <button type="button" id="shipping-reset" class="text-xs font-semibold text-[#C26A3D] hover:underline">
                                            Ubah
                                        </button>
                                    </div>
                                </div>
                                
                                <input type="hidden" name="shipping_courier" id="shipping-courier">
                                <input type="hidden" name="shipping_service" id="shipping-service">
                                <input type="hidden" name="shipping_cost" id="shipping-cost">
                                
                                <div class="mt-3 rounded-2xl border border-dashed border-[#FAD4C2] bg-[#FFF8F3] px-4 py-3 text-xs text-slate-500">
                                    Total berat pesanan: <strong>{{ number_format($totalWeight) }} gram</strong>. Resi pengiriman akan dikirim secara online setelah paket diproses.
                                </div>
                            </div>
                        @else
                            <div class="space-y-3">
                                <div class="rounded-2xl border border-amber-200 bg-amber-50 px-4 py-3 text-sm">
                                    <div class="flex items-start gap-2">
                                        <svg class="h-5 w-5 text-amber-600 mt-0.5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                        </svg>
                                        <div>
                                            <p class="font-semibold text-amber-900">Estimasi Ongkir Manual</p>
                                            <p class="text-xs text-amber-700 mt-1">Biaya dan ekspedisi (JNE / J&T / Anteraja) akan dikonfirmasi oleh admin setelah pesanan dibuat.</p>
                                            <ul class="mt-2 list-disc list-inside text-[11px] text-amber-800 space-y-1">
                                                <li>Pilih kota tujuan melalui pencarian di atas agar alamat tervalidasi.</li>
                                                <li>Tulis preferensi ekspedisi di kolom catatan pesanan.</li>
                                                <li>Admin akan mengirim estimasi ongkir & total via WhatsApp sebelum pembayaran.</li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                                <div class="rounded-2xl border border-dashed border-[#FAD4C2] bg-[#FFF8F3] px-4 py-3 text-xs text-slate-600">
                                    <strong>Tips:</strong> semakin detail alamatmu, semakin cepat admin menghitung ongkir. Resi pengiriman akan dikirim secara online setelah paket diproses.
                                </div>
                            </div>
                        @endif

                        <div class="rounded-3xl border border-[#FAD4C2] bg-white p-6 shadow-sm space-y-4">
                            <div class="flex items-center justify-between gap-3 flex-wrap">
                                <div>
                                    <h2 class="text-lg font-semibold text-slate-900">Metode Pembayaran</h2>
                                    <p class="text-xs text-slate-500">Pilih cara bayar favoritmu.</p>
                                </div>
                                <span class="inline-flex items-center gap-1 rounded-full bg-[#FFF0E6] px-3 py-1 text-[11px] font-semibold text-[#C26A3D]">
                                    <span class="h-2 w-2 rounded-full bg-[#C26A3D]"></span>
                                    Terjamin Aman
                                </span>
                            </div>
                            <div class="grid gap-3">
                                @foreach ($paymentMethods as $method)
                                    <label class="flex items-center justify-between rounded-2xl border border-[#FAD4C2] bg-[#FFF8F3] px-4 py-3 text-sm transition hover:border-[#C26A3D]">
                                        <span class="font-semibold text-slate-900">{{ $method['label'] }}</span>
                                        <input type="radio" name="payment_method" value="{{ $method['code'] }}" class="h-4 w-4 border-[#FAD4C2] text-[#C26A3D] focus:ring-[#C26A3D]" {{ old('payment_method', 'midtrans') === $method['code'] ? 'checked' : '' }}>
                                    </label>
                                @endforeach
                            </div>
                            <label class="block">
                                <span class="text-xs font-semibold text-slate-600">Catatan untuk Admin</span>
                                <textarea name="notes" rows="3" class="mt-1 w-full rounded-2xl border border-[#FAD4C2] bg-[#FFF8F3] px-4 py-2 text-sm focus:border-[#C26A3D] focus:ring-0" placeholder="Contoh: Mohon bungkus sebagai hadiah.">{{ old('notes') }}</textarea>
                            </label>
                        </div>

                        <div class="rounded-3xl border border-[#FAD4C2] bg-[#FFF8F3] p-6 shadow-sm space-y-3">
                            <div>
                                <h2 class="text-lg font-semibold text-slate-900">Persetujuan Pembelian Online</h2>
                                <p class="mt-1 text-xs text-slate-500">Centang seluruh poin sebelum membuat pesanan.</p>
                            </div>
                            <label class="flex items-start gap-3 text-sm text-slate-700">
                                <input type="checkbox" name="confirm_payment_responsibility" value="1" {{ old('confirm_payment_responsibility', true) ? 'checked' : '' }} class="mt-1 h-4 w-4 rounded border-[#FAD4C2] text-[#C26A3D] focus:ring-[#C26A3D]">
                                <span>Saya bertanggung jawab atas pembayaran sesuai metode yang dipilih.</span>
                            </label>
                            <label class="flex items-start gap-3 text-sm text-slate-700">
                                <input type="checkbox" name="confirm_shipping_choice" value="1" {{ old('confirm_shipping_choice', true) ? 'checked' : '' }} class="mt-1 h-4 w-4 rounded border-[#FAD4C2] text-[#C26A3D] focus:ring-[#C26A3D]">
                                <span>Saya menyetujui estimasi ongkir yang akan diinformasikan admin.</span>
                            </label>
                            <label class="flex items-start gap-3 text-sm text-slate-700">
                                <input type="checkbox" name="confirm_online_receipt" value="1" {{ old('confirm_online_receipt', true) ? 'checked' : '' }} class="mt-1 h-4 w-4 rounded border-[#FAD4C2] text-[#C26A3D] focus:ring-[#C26A3D]">
                                <span>Resi pengiriman akan diterima secara online setelah paket diproses.</span>
                            </label>
                        </div>

                        <div class="flex flex-col gap-4 rounded-3xl border border-[#FAD4C2] bg-white p-6 shadow-sm sm:flex-row sm:items-center sm:justify-between">
                            <div class="text-xs text-slate-500">
                                Dengan menekan tombol di bawah, pesananmu akan dikirim ke admin untuk verifikasi.
                            </div>
                            <button type="submit" class="inline-flex items-center justify-center rounded-full bg-[#C26A3D] px-6 py-3 text-sm font-semibold text-white transition hover:bg-[#a85327]">
                                Buat Pesanan
                            </button>
                        </div>
                    </div>
                </form>

                <div class="space-y-6">
                    <div class="rounded-3xl border border-[#FAD4C2] bg-white p-6 shadow-sm space-y-4">
                        <div class="flex items-center justify-between">
                            <h2 class="text-lg font-semibold text-slate-900">Ringkasan Pesanan</h2>
                            <span class="text-xs text-slate-500">{{ $items->sum('quantity') }} barang</span>
                        </div>
                        <div class="divide-y divide-[#FAD4C2]/60">
                            @foreach ($items as $item)
                                <div class="flex items-start justify-between gap-3 py-3">
                                    <div>
                                        <p class="text-sm font-semibold text-slate-900">{{ $item->product->name }}</p>
                                        <p class="text-xs text-slate-500">Qty {{ $item->quantity }} â€¢ Rp{{ number_format($item->price) }}</p>
                                    </div>
                                    <p class="text-sm font-semibold text-slate-900">Rp{{ number_format($item->subtotal) }}</p>
                                </div>
                            @endforeach
                        </div>
                        <div class="space-y-3 text-sm">
                            <div class="flex items-center justify-between text-slate-600">
                                <span>Subtotal</span>
                                <span>Rp{{ number_format($subtotal) }}</span>
                            </div>
                            <div class="flex items-center justify-between text-emerald-600">
                                <span>Perkiraan Diskon 5%</span>
                                <span>- Rp{{ number_format($discountEstimate) }}</span>
                            </div>
                            <div class="flex items-center justify-between">
                                <div>
                                    <p class="text-sm font-semibold text-slate-900">Ongkir</p>
                                    <p id="summary-shipping-label" class="text-[11px] text-slate-400">Belum dipilih</p>
                                </div>
                                <p id="summary-shipping" class="text-sm font-semibold text-slate-900">Rp0</p>
                            </div>
                            <hr class="border-dashed border-[#FAD4C2]">
                            <div class="flex items-center justify-between text-base font-semibold text-slate-900">
                                <span>Total Pembayaran</span>
                                <span id="summary-total">Rp{{ number_format($totalEstimate) }}</span>
                            </div>
                        </div>
                    </div>

                    <div class="rounded-3xl border border-[#FAD4C2] bg-[#FFF8F3] p-6 shadow-sm space-y-3 text-sm text-slate-600">
                        <div class="flex items-center gap-3">
                            <div class="h-10 w-10 rounded-full bg-white text-[#C26A3D] flex items-center justify-center font-semibold">WA</div>
                            <div>
                                <p class="font-semibold text-slate-900">Butuh Bantuan?</p>
                                <p>Admin siap bantu via WhatsApp {{ $adminWhatsapp }}</p>
                            </div>
                        </div>
                        <p class="text-xs text-slate-500">Resi dan status pengiriman akan dikirim otomatis setelah paket diproses.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    @if($citySearchEnabled ?? false)
    <script>
        (function() {
            const subtotal = {{ $items->sum('subtotal') }};
            const discount = Math.round(subtotal * 0.05);
            const totalWeight = {{ $totalWeight }};
            const shippingEnabled = {{ $rajaOngkirEnabled ? 'true' : 'false' }};
            const cityLookupMode = 'live';
            let selectedShippingCost = 0;
            let selectedShippingLabel = '';
            let selectedShippingEtd = '';

            const citySearchInput = document.getElementById('city-search');
            const cityResults = document.getElementById('city-results');
            const cityNameInput = document.getElementById('city-name');
            const cityIdInput = document.getElementById('city-id');
            const provinceNameInput = document.getElementById('province-name');
            const cityHelperText = document.getElementById('city-helper-text');
            const citySearchIcon = document.getElementById('city-search-icon');
            const cityLoadingIcon = document.getElementById('city-loading-icon');
            const shippingSelectionCard = document.getElementById('shipping-selection');
            const shippingSelectionLabel = document.getElementById('shipping-selection-label');
            const shippingSelectionEtd = document.getElementById('shipping-selection-etd');
            const shippingResetBtn = document.getElementById('shipping-reset');
            const summaryShippingLabelEl = document.getElementById('summary-shipping-label');
            const shippingOptionsEl = document.getElementById('shipping-options');
            const shippingErrorEl = document.getElementById('shipping-error');
            const shippingLoadingEl = document.getElementById('shipping-loading');
            const checkShippingBtn = document.getElementById('check-shipping-btn');
            let searchTimeout;
            let selectedCityValid = Boolean(cityIdInput?.value && cityNameInput?.value);

            function describeServerMessage(text, fallback) {
                const trimmed = (text || '').trim();
                if (!trimmed) return fallback;
                if (trimmed.startsWith('<')) {
                    return 'Server mengembalikan halaman HTML daripada JSON.';
                }
                try {
                    const parsed = JSON.parse(trimmed);
                    if (parsed && parsed.message) {
                        return parsed.message;
                    }
                    return trimmed;
                } catch {
                    return trimmed;
                }
            }

            function fetchJson(url, options = {}) {
                const merged = { credentials: 'same-origin', ...options };
                return fetch(url, merged).then(async response => {
                    const raw = await response.text();
                    if (!response.ok) {
                        const message = describeServerMessage(raw, `HTTP ${response.status}`);
                        throw new Error(message);
                    }
                    try {
                        return raw ? JSON.parse(raw) : {};
                    } catch (e) {
                        throw new Error('Server tidak mengembalikan JSON yang valid.');
                    }
                });
            }

            if (selectedCityValid && cityHelperText) {
                cityHelperText.textContent = 'Alamat default digunakan. Ubah kota jika berbeda.';
                cityHelperText.className = 'mt-1 text-xs text-green-600';
            }

            citySearchInput?.addEventListener('input', function() {
                clearTimeout(searchTimeout);
                const query = this.value.trim();
                
                if (selectedCityValid && cityIdInput?.value) {
                    selectedCityValid = false;
                    cityIdInput.value = '';
                    cityNameInput.value = '';
                    provinceNameInput.value = '';
                }
                
                if (query.length === 0) {
                    cityResults?.classList.add('hidden');
                    cityHelperText.textContent = 'Ketik nama kota untuk mencari';
                    cityHelperText.className = 'mt-1 text-xs text-slate-500';
                    return;
                }
                
                if (query.length < 3) {
                    cityResults?.classList.add('hidden');
                    cityHelperText.textContent = `Ketik ${3 - query.length} huruf lagi untuk mencari...`;
                    cityHelperText.className = 'mt-1 text-xs text-slate-500';
                    return;
                }

                citySearchIcon?.classList.add('hidden');
                cityLoadingIcon?.classList.remove('hidden');
                cityHelperText.textContent = 'Sedang mencari kota...';
                cityHelperText.className = 'mt-1 text-xs text-[#C26A3D]';

                searchTimeout = setTimeout(() => {
                    fetchJson(`/api/shipping/search-city?q=${encodeURIComponent(query)}`)
                        .then(data => {
                            citySearchIcon?.classList.remove('hidden');
                            cityLoadingIcon?.classList.add('hidden');

                            if (data.success && data.data.length > 0) {
                                cityResults.innerHTML = data.data.map(city => {
                                    const cityName = `${city.type} ${city.city_name}`;
                                    const safeCityName = cityName.replace(/'/g, "\\'");
                                    const safeProvince = city.province.replace(/'/g, "\\'");
                                    
                                    return `
                                    <div class="cursor-pointer px-4 py-3 text-sm hover:bg-[#FFF8F3] transition border-b border-[#FAD4C2] last:border-b-0" 
                                         onclick="selectCity(${city.city_id}, '${safeCityName}', '${safeProvince}')">
                                        <div class="font-semibold text-slate-900">${cityName}</div>
                                        <div class="text-xs text-slate-500 flex items-center gap-1">
                                            <svg class="h-3 w-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"></path>
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                            </svg>
                                            ${city.province}
                                        </div>
                                    </div>
                                    `;
                                }).join('');
                                cityResults?.classList.remove('hidden');
                                cityHelperText.textContent = `Ditemukan ${data.data.length} kota`;
                                cityHelperText.className = 'mt-1 text-xs text-green-600';
                            } else if (data.success) {
                                cityResults.innerHTML = `
                                    <div class="px-4 py-3 text-xs text-slate-500">
                                        Tidak ada kota yang cocok. Coba nama lain atau cek ejaan.
                                    </div>
                                `;
                                cityResults?.classList.remove('hidden');
                                cityHelperText.textContent = 'Tidak ada kota dengan kata kunci tersebut';
                                cityHelperText.className = 'mt-1 text-xs text-amber-600';
                            } else {
                                throw new Error(data.message || 'Gagal memuat data kota');
                            }
                        })
                        .catch(error => {
                            console.error('Error searching city:', error);
                            citySearchIcon?.classList.remove('hidden');
                            cityLoadingIcon?.classList.add('hidden');
                            cityResults.innerHTML = `
                                <div class="px-4 py-3 text-xs text-red-600">
                                    Terjadi kesalahan saat mencari kota. Silakan coba lagi nanti.
                                </div>
                            `;
                            cityResults?.classList.remove('hidden');
                            cityHelperText.textContent = 'Gagal memuat data kota';
                            cityHelperText.className = 'mt-1 text-xs text-red-600';
                        });
                }, 400);
            });

            document.addEventListener('click', function(e) {
                if (!citySearchInput?.contains(e.target) && !cityResults?.contains(e.target)) {
                    cityResults?.classList.add('hidden');
                }
            });

            function loadShippingOptions() {
                if (!shippingEnabled) return;
                const cityId = cityIdInput?.value;
                if (!cityId) return;

                resetShippingSelection();
                shippingLoadingEl?.classList.remove('hidden');
                shippingErrorEl?.classList.add('hidden');
                shippingOptionsEl?.classList.add('hidden');
                if (checkShippingBtn) checkShippingBtn.disabled = true;

                fetchJson('/api/shipping/calculate-cost', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.getAttribute('content') || ''
                    },
                    body: JSON.stringify({
                        destination: cityId,
                        destination_name: cityNameInput?.value || citySearchInput?.value || '',
                        province: provinceNameInput?.value || '',
                        weight: totalWeight || 1000
                    })
                })
                .then(data => {
                    shippingLoadingEl?.classList.add('hidden');
                    if (checkShippingBtn) checkShippingBtn.disabled = false;
                    if (data.success && Array.isArray(data.data) && data.data.length) {
                        const html = data.data.map(option => {
                            const labelText = `${option.courier_name} - ${option.service}`;
                            const safeLabel = labelText.replace(/"/g, '&quot;').replace(/'/g, '&#39;');
                            const safeEtd = (option.etd || '-').replace(/"/g, '&quot;').replace(/'/g, '&#39;');
                            const price = Number(option.cost || 0).toLocaleString('id-ID');
                            return `
                                <label class="flex items-center justify-between rounded-2xl border border-[#FAD4C2] bg-[#FFF8F3] px-4 py-3 text-sm transition hover:border-[#C26A3D] cursor-pointer">
                                    <div>
                                        <div class="font-semibold text-slate-900">${labelText}</div>
                                        <div class="text-xs text-slate-500">${option.description || ''}</div>
                                        <div class="text-xs text-slate-500 mt-1">Estimasi: ${option.etd || '-'} hari</div>
                                    </div>
                                    <div class="text-right">
                                        <div class="font-semibold text-[#C26A3D]">Rp${price}</div>
                                        <input type="radio"
                                               name="shipping_option"
                                               value="${option.courier_code}|${option.service}|${option.cost}"
                                               data-label="${safeLabel}"
                                               data-etd="${safeEtd}"
                                               class="h-4 w-4 border-[#FAD4C2] text-[#C26A3D] focus:ring-[#C26A3D]">
                                    </div>
                                </label>`;
                        }).join('');
                        shippingOptionsEl.innerHTML = html;
                        shippingOptionsEl?.classList.remove('hidden');
                        shippingErrorEl?.classList.add('hidden');

                        shippingOptionsEl.querySelectorAll('input[name="shipping_option"]').forEach(input => {
                            input.addEventListener('change', () => {
                                const [courierCode, serviceName, costValue] = input.value.split('|');
                                selectShipping(
                                    courierCode,
                                    serviceName,
                                    Number(costValue),
                                    input.dataset.label,
                                    input.dataset.etd
                                );
                            });
                        });

                        const firstInput = shippingOptionsEl.querySelector('input[name="shipping_option"]');
                        if (firstInput && !selectedShippingLabel) {
                            firstInput.checked = true;
                            const [courierCode, serviceName, costValue] = firstInput.value.split('|');
                            selectShipping(
                                courierCode,
                                serviceName,
                                Number(costValue),
                                firstInput.dataset.label,
                                firstInput.dataset.etd
                            );
                        }
                    } else if (data.success) {
                        shippingOptionsEl.innerHTML = `<div class="px-4 py-3 text-xs text-slate-500">Tidak ada layanan untuk kota ini.</div>`;
                        shippingOptionsEl?.classList.remove('hidden');
                    } else {
                        throw new Error(data.message || 'Gagal mengambil tarif');
                    }
                })
                    .catch(err => {
                    console.error('loadShippingOptions error:', err);
                    shippingLoadingEl?.classList.add('hidden');
                    if (checkShippingBtn) checkShippingBtn.disabled = false;
                    shippingErrorEl.textContent = (err && err.message) ? `Gagal memuat tarif: ${err.message}` : 'Gagal memuat tarif pengiriman. Coba lagi.';
                    shippingErrorEl?.classList.remove('hidden');
                });
            }

            window.selectCity = function selectCity(cityId, cityName, provinceName) {
                if (!cityIdInput || !cityNameInput) {
                    return;
                }

                cityIdInput.value = cityId;
                cityNameInput.value = cityName;
                citySearchInput.value = cityName;
                if (provinceNameInput && provinceName) {
                    provinceNameInput.value = provinceName;
                }
                selectedCityValid = true;
                cityResults?.classList.add('hidden');
                
                cityHelperText.textContent = 'Kota dipilih: ' + cityName;
                cityHelperText.className = 'mt-1 text-xs text-green-600 font-semibold';
                
                citySearchInput.classList.add('border-green-500', 'bg-green-50');
                setTimeout(() => {
                    citySearchInput.classList.remove('border-green-500', 'bg-green-50');
                }, 1500);
                
                if (shippingEnabled) {
                    loadShippingOptions();
                }
            };

            if (shippingEnabled && checkShippingBtn) {
                checkShippingBtn.addEventListener('click', function() {
                    if (!selectedCityValid || !cityIdInput?.value) {
                        citySearchInput?.focus();
                        citySearchInput?.classList.add('border-red-500', 'ring-2', 'ring-red-200');
                        cityHelperText.textContent = 'Silakan pilih kota dari daftar terlebih dahulu';
                        cityHelperText.className = 'mt-1 text-xs text-red-600 font-semibold';
                        setTimeout(() => citySearchInput?.classList.remove('border-red-500', 'ring-2', 'ring-red-200'), 3000);
                        return;
                    }
                    loadShippingOptions();
                });
            }

            window.selectShipping = function selectShipping(courier, service, cost, label, etd) {
                if (!shippingEnabled) {
                    return;
                }

                const shippingCourierInput = document.getElementById('shipping-courier');
                const shippingServiceInput = document.getElementById('shipping-service');
                const shippingCostInput = document.getElementById('shipping-cost');
                if (shippingCourierInput) { shippingCourierInput.value = courier; shippingCourierInput.setAttribute('value', courier); }
                if (shippingServiceInput) { shippingServiceInput.value = service; shippingServiceInput.setAttribute('value', service); }
                if (shippingCostInput) { shippingCostInput.value = cost; shippingCostInput.setAttribute('value', cost); }
                selectedShippingCost = cost;
                selectedShippingLabel = label ?? '';
                selectedShippingEtd = etd ?? '-';

                if (shippingSelectionCard) {
                    shippingSelectionLabel.textContent = selectedShippingLabel;
                    shippingSelectionEtd.textContent = `Estimasi tiba ${selectedShippingEtd} hari`;
                    shippingSelectionCard.classList.remove('hidden');
                }

                updateSummary(cost);
            };

            function resetShippingSelection() {
                if (!shippingEnabled) {
                    return;
                }

                const shippingCourierInputReset = document.getElementById('shipping-courier');
                const shippingServiceInputReset = document.getElementById('shipping-service');
                const shippingCostInputReset = document.getElementById('shipping-cost');
                if (shippingCourierInputReset) { shippingCourierInputReset.value = ''; shippingCourierInputReset.setAttribute('value', ''); }
                if (shippingServiceInputReset) { shippingServiceInputReset.value = ''; shippingServiceInputReset.setAttribute('value', ''); }
                if (shippingCostInputReset) { shippingCostInputReset.value = ''; shippingCostInputReset.setAttribute('value', ''); }
                selectedShippingCost = 0;
                selectedShippingLabel = '';
                selectedShippingEtd = '';

                document.querySelectorAll('input[name="shipping_option"]').forEach(input => input.checked = false);
                shippingSelectionCard?.classList.add('hidden');
                updateSummary(0);
            }

            shippingResetBtn && shippingEnabled && shippingResetBtn.addEventListener('click', resetShippingSelection);

            function updateSummary(shippingCost) {
                const total = subtotal - discount + shippingCost;
                document.getElementById('summary-shipping').textContent = 'Rp' + shippingCost.toLocaleString('id-ID');
                summaryShippingLabelEl && (summaryShippingLabelEl.textContent = selectedShippingLabel
                    ? `${selectedShippingLabel} - ${selectedShippingEtd} hari`
                    : (shippingEnabled ? 'Belum dipilih' : 'Menunggu konfirmasi admin'));

                document.getElementById('summary-total').textContent = 'Rp' + total.toLocaleString('id-ID');
            }

            const checkoutForm = document.querySelector('form[action="{{ route('checkout.store') }}"]');
            checkoutForm?.addEventListener('submit', function(e) {
                if (!selectedCityValid || !cityIdInput?.value) {
                    e.preventDefault();
                    
                    citySearchInput?.scrollIntoView({ behavior: 'smooth', block: 'center' });
                    citySearchInput?.focus();
                    
                    citySearchInput?.classList.add('border-red-500', 'ring-2', 'ring-red-200');
                    cityHelperText.textContent = 'Pilih kota dari daftar pencarian terlebih dahulu';
                    cityHelperText.className = 'mt-1 text-xs text-red-600 font-semibold';
                    
                    const notification = document.createElement('div');
                    notification.className = 'fixed top-4 right-4 z-50 rounded-2xl border border-red-200 bg-red-50 px-6 py-4 shadow-lg max-w-md';
                    notification.innerHTML = `
                        <div class="flex items-start gap-3">
                            <svg class="h-5 w-5 text-red-600 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                            <div>
                                <p class="font-semibold text-red-900">Silakan pilih kota</p>
                                <p class="text-sm text-red-700 mt-1">Ketik nama kota dan pilih dari daftar yang muncul sebelum melanjutkan checkout.</p>
                            </div>
                            <button type="button" class="text-red-400 hover:text-red-600" aria-label="Tutup" onclick="this.closest('.notification')?.remove()">
                                <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                                </svg>
                            </button>
                        </div>
                    `;
                    notification.classList.add('notification');
                    document.body.appendChild(notification);
                    
                    setTimeout(() => {
                        notification.remove();
                        citySearchInput?.classList.remove('border-red-500', 'ring-2', 'ring-red-200');
                    }, 5000);
                    
                    return false;
                }
            });
        })();
    </script>
    @endif
</x-app-layout>










