<x-app-layout>
    <div class="min-h-screen bg-cashier-shell py-8 text-slate-900 dark:text-slate-100">
        <div class="mx-auto max-w-6xl space-y-8 px-4 sm:px-6 lg:px-10">
            <header class="flex flex-wrap items-center justify-between gap-4">
                <div>
                    <p class="cashier-chip text-xs uppercase">Ringkasan Transaksi</p>
                    <h1 class="text-3xl font-semibold">Invoice {{ $order->invoice_number }}</h1>
                    <p class="text-sm text-slate-600">{{ $order->created_at->translatedFormat('d F Y • H:i') }}</p>
                </div>
                <div class="flex flex-wrap gap-3 text-xs">
                    <a href="{{ route('cashier.dashboard') }}" class="inline-flex items-center gap-2 rounded-full border border-[#FAD4C2] bg-white/80 px-4 py-2 font-semibold text-[#C26A3D] transition hover:bg-white">&larr; Kembali ke POS</a>
                    <a href="{{ route('cashier.orders.print', $order) }}" class="inline-flex items-center gap-2 rounded-full border border-emerald-300/60 bg-emerald-100 px-4 py-2 font-semibold text-emerald-700 transition hover:bg-emerald-200">Cetak Struk</a>
                </div>
            </header>

            <div class="grid gap-6 lg:grid-cols-[1.2fr,1fr]">
                <section class="space-y-6">
                    <div class="rounded-3xl cashier-panel px-6 py-5">
                        <h2 class="text-lg font-semibold">Detail Customer</h2>
                        <dl class="mt-4 grid gap-3 text-sm sm:grid-cols-2">
                            <div>
                                <dt class="text-slate-500">Nama</dt>
                                <dd class="font-medium">{{ $order->metadata['customer_name'] ?? 'Pelanggan Umum' }}</dd>
                            </div>
                            <div>
                                <dt class="text-slate-500">Kontak</dt>
                                <dd class="font-medium">{{ $order->shipping_address['phone'] ?? '-' }}</dd>
                            </div>
                            <div>
                                <dt class="text-slate-500">Kasir</dt>
                                <dd class="font-medium">{{ $order->cashier?->name ?? '-' }}</dd>
                            </div>
                            <div>
                                <dt class="text-slate-500">Metode Pembayaran</dt>
                                <dd class="font-medium text-uppercase">{{ strtoupper($order->payment_method) }}</dd>
                            </div>
                        </dl>
                    </div>

                    <div class="rounded-3xl cashier-panel px-6 py-5">
                        <h2 class="text-lg font-semibold">Produk Dibeli</h2>
                        <div class="mt-4 overflow-hidden rounded-2xl border border-[#FAD4C2] bg-white/70">
                            <table class="min-w-full divide-y divide-[#FAD4C2] text-sm">
                                <thead class="bg-[#FFF4EC] text-slate-600">
                                    <tr>
                                        <th class="px-4 py-3 text-left font-medium">Produk</th>
                                        <th class="px-4 py-3 text-center font-medium">Jumlah</th>
                                        <th class="px-4 py-3 text-right font-medium">Harga</th>
                                        <th class="px-4 py-3 text-right font-medium">Subtotal</th>
                                    </tr>
                                </thead>
                                <tbody class="divide-y divide-[#FAD4C2]">
                                    @foreach ($order->items as $item)
                                        <tr>
                                            <td class="px-4 py-3">
                                                <p class="font-semibold">{{ $item->product_name }}</p>
                                                <p class="text-xs text-slate-500">SKU: {{ $item->sku ?? '-' }}</p>
                                            </td>
                                            <td class="px-4 py-3 text-center font-semibold">{{ $item->quantity }}</td>
                                            <td class="px-4 py-3 text-right">Rp{{ number_format($item->unit_price, 0, ',', '.') }}</td>
                                            <td class="px-4 py-3 text-right font-semibold text-[#C26A3D]">Rp{{ number_format($item->subtotal, 0, ',', '.') }}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </section>

                <section class="space-y-6">
                    <div class="rounded-3xl cashier-panel px-6 py-6">
                        <h2 class="text-lg font-semibold">Ringkasan Pembayaran</h2>
                        @php
                            $cashReceived = (int) ($order->metadata['cash_received'] ?? ($order->payments->first()->payload['cash_received'] ?? 0));
                            $cashChange = (int) ($order->metadata['cash_change'] ?? ($order->payments->first()->payload['cash_change'] ?? 0));
                        @endphp
                        <dl class="mt-5 space-y-3 text-sm">
                            <div class="flex items-center justify-between">
                                <dt>Subtotal</dt>
                                <dd>Rp{{ number_format($order->subtotal_amount, 0, ',', '.') }}</dd>
                            </div>
                            <div class="flex items-center justify-between">
                                <dt>Diskon</dt>
                                <dd>Rp{{ number_format($order->discount_amount, 0, ',', '.') }}</dd>
                            </div>
                            <div class="flex items-center justify-between">
                                <dt>Biaya Lain</dt>
                                <dd>Rp{{ number_format(($order->shipping_cost + $order->service_fee), 0, ',', '.') }}</dd>
                            </div>
                            <div class="flex items-center justify-between">
                                <dt>Tunai Diterima</dt>
                                <dd>Rp{{ number_format($cashReceived, 0, ',', '.') }}</dd>
                            </div>
                            <div class="flex items-center justify-between text-lg font-semibold text-[#C26A3D]">
                                <dt>Total Dibayar</dt>
                                <dd>Rp{{ number_format($order->grand_total, 0, ',', '.') }}</dd>
                            </div>
                            <div class="flex items-center justify-between text-base font-semibold">
                                <dt>Kembalian</dt>
                                <dd>Rp{{ number_format($cashChange, 0, ',', '.') }}</dd>
                            </div>
                        </dl>
                        <div class="mt-5 rounded-2xl border border-[#FAD4C2] bg-white/70 px-4 py-3 text-sm">
                            <p class="text-slate-600">Status Pembayaran:</p>
                            <p class="text-base font-semibold">{{ strtoupper($order->payment_status) }}</p>
                        </div>
                    </div>

                    @if ($order->payment_status !== 'paid')
                        <div class="rounded-3xl border border-emerald-300 bg-emerald-50 px-6 py-6 text-sm">
                            <h3 class="text-lg font-semibold text-emerald-700">Konfirmasi Pembayaran</h3>
                            <p class="mt-2 text-emerald-700/80">Jika pelanggan sudah membayar tunai, klik tombol di bawah untuk menyelesaikan transaksi.</p>
                            <form action="{{ route('cashier.orders.markPaid', $order) }}" method="POST" class="mt-4">
                                @csrf
                                <button type="submit" class="inline-flex w-full items-center justify-center rounded-full bg-emerald-500 px-4 py-2 font-semibold text-white transition hover:bg-emerald-400">Tandai Sudah Dibayar</button>
                            </form>
                        </div>
                    @endif
                </section>
            </div>
        </div>
    </div>
</x-app-layout>

