<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Struk Pembayaran - {{ $order->invoice_number }}</title>
    <style>
        * { box-sizing: border-box; font-family: 'Poppins', Arial, sans-serif; }
        body { background: #f3f4f6; margin: 0; padding: 20px; color: #111827; }
        .receipt { max-width: 420px; margin: 0 auto; background: #fff; padding: 24px; border-radius: 20px; box-shadow: 0 15px 35px rgba(15, 23, 42, 0.12); }
        .receipt header { text-align: center; border-bottom: 1px dashed #e5e7eb; padding-bottom: 16px; margin-bottom: 16px; }
        .receipt h1 { font-size: 20px; margin: 0; color: #111827; }
        .muted { color: #6b7280; font-size: 12px; margin: 4px 0 0; }
        table { width: 100%; border-collapse: collapse; margin-top: 12px; font-size: 13px; }
        th { text-align: left; color: #6b7280; font-weight: 500; padding-bottom: 6px; }
        td { padding: 6px 0; }
        tr + tr td { border-top: 1px dashed #e5e7eb; }
        .total { font-weight: 600; font-size: 16px; color: #1f2937; }
        .center { text-align: center; }
        .footnote { font-size: 11px; color: #9ca3af; margin-top: 16px; text-align: center; }
        .actions { margin-top: 20px; display: flex; gap: 8px; justify-content: center; flex-wrap: wrap; }
        .actions button, .actions a { 
            padding: 12px 20px; 
            border-radius: 12px; 
            font-size: 13px; 
            font-weight: 700; 
            text-decoration: none; 
            display: inline-flex; 
            align-items: center; 
            justify-content: center;
            gap: 8px; 
            border: none; 
            cursor: pointer;
            transition: all 0.3s ease;
        }
        .btn-print { 
            background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%); 
            color: #fff; 
            box-shadow: 0 4px 12px rgba(37, 99, 235, 0.3);
        }
        .btn-print:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 16px rgba(37, 99, 235, 0.4);
        }
        .btn-back { 
            background: linear-gradient(135deg, #10b981 0%, #059669 100%); 
            color: #fff; 
            box-shadow: 0 4px 12px rgba(16, 185, 129, 0.3);
        }
        .btn-back:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 16px rgba(16, 185, 129, 0.4);
        }
        .success-banner { 
            background: linear-gradient(135deg, #10b981 0%, #059669 100%); 
            border-radius: 12px; 
            padding: 16px; 
            margin-bottom: 20px; 
            text-align: center; 
            box-shadow: 0 4px 12px rgba(16, 185, 129, 0.3);
        }
        @media print {
            body { background: #fff; padding: 0; }
            .actions, .success-banner { display: none; }
            .receipt { box-shadow: none; border-radius: 0; max-width: none; }
        }
    </style>
</head>
<body onload="handlePrint()">
    <script>
        function handlePrint() {
            const shouldPrint = @json(($autoPrint ?? false) || session('auto_print', false) || false) || @json(request()->boolean('auto_print'));
            if (shouldPrint) {
                setTimeout(function() {
                    window.print();
                }, 500);
            }
        }
    </script>
    <div class="receipt">
        <!-- Success Banner -->
        <div class="success-banner">
            <svg style="width: 48px; height: 48px; color: white; margin: 0 auto 8px;" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
            </svg>
            <h2 style="color: white; font-size: 18px; font-weight: 700; margin: 0;">✅ Pembayaran Berhasil!</h2>
            <p style="color: rgba(255,255,255,0.9); font-size: 12px; margin: 4px 0 0;">Transaksi telah selesai diproses</p>
        </div>

        <header>
            <h1>{{ $storeName }}</h1>
            <p class="muted">{{ $order->created_at->translatedFormat('d F Y • H:i') }}</p>
            <p class="muted">Invoice: <strong>{{ $order->invoice_number }}</strong></p>
        </header>

        <section>
            <table>
                <tr>
                    <th>Customer</th>
                    <td>{{ $order->metadata['customer_name'] ?? 'Pelanggan Umum' }}</td>
                </tr>
                <tr>
                    <th>Kasir</th>
                    <td>{{ $order->cashier?->name ?? '-' }}</td>
                </tr>
                <tr>
                    <th>Metode</th>
                    <td>{{ strtoupper($order->payment_method) }}</td>
                </tr>
            </table>
        </section>

        <section>
            <table>
                <thead>
                    <tr>
                        <th>Produk</th>
                        <th style="text-align:center;">Qty</th>
                        <th style="text-align:right;">Subtotal</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($order->items as $item)
                        <tr>
                            <td>
                                <div style="font-weight:600;">{{ $item->product_name }}</div>
                                <div style="font-size:11px; color:#9ca3af;">SKU: {{ $item->sku ?? '-' }}</div>
                            </td>
                            <td style="text-align:center; font-weight:600;">{{ $item->quantity }}</td>
                            <td style="text-align:right; font-weight:600;">Rp{{ number_format($item->subtotal, 0, ',', '.') }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </section>

        <section style="margin-top:16px; border-top:1px dashed #e5e7eb; padding-top:12px;">
            <table>
                <tr>
                    <td>Subtotal</td>
                    <td style="text-align:right;">Rp{{ number_format($order->subtotal_amount, 0, ',', '.') }}</td>
                </tr>
                <tr>
                    <td>Diskon</td>
                    <td style="text-align:right;">Rp{{ number_format($order->discount_amount, 0, ',', '.') }}</td>
                </tr>
                <tr>
                    <td>Biaya Tambahan</td>
                    <td style="text-align:right;">Rp{{ number_format(($order->shipping_cost + $order->service_fee), 0, ',', '.') }}</td>
                </tr>
                @php
                    $cashReceived = (int) ($order->metadata['cash_received'] ?? ($order->payments->first()->payload['cash_received'] ?? 0));
                    $cashChange = (int) ($order->metadata['cash_change'] ?? ($order->payments->first()->payload['cash_change'] ?? 0));
                @endphp
                <tr>
                    <td>Tunai Diterima</td>
                    <td style="text-align:right;">Rp{{ number_format($cashReceived, 0, ',', '.') }}</td>
                </tr>
                <tr>
                    <td class="total">Total</td>
                    <td class="total" style="text-align:right;">Rp{{ number_format($order->grand_total, 0, ',', '.') }}</td>
                </tr>
                <tr>
                    <td>Kembalian</td>
                    <td style="text-align:right;">Rp{{ number_format($cashChange, 0, ',', '.') }}</td>
                </tr>
            </table>
        </section>

        <p class="footnote">
            Terima kasih atas kepercayaan Anda.<br/>
            Barang yang sudah dibeli tidak dapat dikembalikan.<br/>
            <small style="margin-top: 8px; display: block;">Dicetak: <span id="cashier-print-time">{{ now()->translatedFormat('d M Y, H:i:s') }}</span> WIB</small>
        </p>

        <div class="actions">
            <button class="btn-print" onclick="window.print()">
                <svg style="width: 14px; height: 14px;" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 17h2a2 2 0 002-2v-4a2 2 0 00-2-2H5a2 2 0 00-2 2v4a2 2 0 002 2h2m2 4h6a2 2 0 002-2v-4a2 2 0 00-2-2H9a2 2 0 00-2 2v4a2 2 0 002 2zm8-12V5a2 2 0 00-2-2H9a2 2 0 00-2 2v4h10z"></path>
                </svg>
                Cetak Struk
            </button>
            <a class="btn-back" href="{{ route('cashier.dashboard') }}">
                <svg style="width: 14px; height: 14px;" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                </svg>
                Transaksi Baru
            </a>
        </div>
    </div>

    {{-- Real-time Clock untuk Print Kasir --}}
    <script>
        (function() {
            function updateCashierPrintTime() {
                const now = new Date();
                const months = ['Jan', 'Feb', 'Mar', 'Apr', 'Mei', 'Jun', 'Jul', 'Agu', 'Sep', 'Okt', 'Nov', 'Des'];
                
                const day = now.getDate();
                const month = months[now.getMonth()];
                const year = now.getFullYear();
                const hours = String(now.getHours()).padStart(2, '0');
                const minutes = String(now.getMinutes()).padStart(2, '0');
                const seconds = String(now.getSeconds()).padStart(2, '0');
                
                const timeString = `${day} ${month} ${year}, ${hours}:${minutes}:${seconds}`;
                
                const element = document.getElementById('cashier-print-time');
                if (element) element.textContent = timeString;
            }
            
            updateCashierPrintTime();
            setInterval(updateCashierPrintTime, 1000);
        })();
    </script>
</body>
</html>
