<x-app-layout>
    <section class="py-10">
        <div class="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8 space-y-6">
            <header class="space-y-2">
                <h1 class="text-2xl font-semibold text-slate-900">Keranjang Belanja</h1>
                <p class="text-sm text-slate-500">Kelola produk pilihanmu dan pilih mana yang siap di checkout.</p>
            </header>

            @if (! $cart || $cart->items->isEmpty())
                <div class="rounded-3xl border border-[#FAD4C2] bg-white p-12 text-center text-slate-500">
                    Keranjangmu masih kosong. Yuk eksplor <a href="{{ route('products.index') }}" class="font-semibold text-[#C26A3D] hover:underline">katalog produk</a> kami!
                </div>
            @else
                <div class="space-y-6">
                    <div class="rounded-3xl border border-[#FAD4C2] bg-white shadow-sm">
                        <div class="grid grid-cols-[auto,1fr,auto,auto] items-center gap-4 border-b border-[#FAD4C2] px-6 py-4 text-[13px] font-semibold text-slate-500 uppercase tracking-wider">
                            <span>Pilih</span>
                            <span>Produk</span>
                            <span>Jumlah</span>
                            <span>Total</span>
                        </div>
                        <div class="divide-y divide-[#FAD4C2]/50">
                            @foreach ($cart->items as $item)
                                <div class="grid grid-cols-[auto,1fr,auto,auto] items-center gap-4 px-6 py-4 text-sm text-slate-700">
                                    <label class="flex items-center justify-center">
                                        <input type="checkbox" name="selected_items[]" value="{{ $item->id }}" form="selection-form" class="h-4 w-4 rounded border-[#FAD4C2] text-[#C26A3D] focus:ring-[#C26A3D]" {{ $item->is_selected ? 'checked' : '' }}>
                                    </label>
                                    <div class="flex items-center gap-4">
                                        <div class="h-16 w-16 overflow-hidden rounded-2xl border border-[#FAD4C2] bg-[#FFF0E6]">
                                            <img src="{{ $item->product->thumbnail }}" alt="{{ $item->product->name }}" class="h-full w-full object-cover">
                                        </div>
                                        <div>
                                            <p class="font-semibold text-slate-900">{{ $item->product->name }}</p>
                                            <p class="text-xs text-slate-500">Rp{{ number_format($item->unit_price, 0, ',', '.') }}  Stok {{ $item->product->stock }}</p>
                                        </div>
                                    </div>
                                    <div class="flex items-center gap-2">
                                        <form method="POST" action="{{ route('cart.items.update', $item) }}" class="flex items-center gap-2">
                                            @csrf
                                            @method('PATCH')
                                            <input type="number" name="quantity" value="{{ $item->quantity }}" min="{{ $item->product->min_order_qty }}" max="{{ $item->product->max_order_qty ?? $item->product->stock }}" class="w-20 rounded-full border border-[#FAD4C2] bg-[#FFF8F3] px-3 py-1 text-xs focus:border-[#C26A3D] focus:ring-0" />
                                            <button type="submit" class="rounded-full bg-[#FFE2CF] px-3 py-1 text-xs font-semibold text-[#C26A3D] hover:bg-[#FFCFAF] transition">Simpan</button>
                                        </form>
                                        <form method="POST" action="{{ route('cart.items.destroy', $item) }}">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="text-xs font-semibold text-rose-600 hover:underline">Hapus</button>
                                        </form>
                                    </div>
                                    <p class="text-sm font-semibold text-[#C26A3D]">Rp{{ number_format($item->subtotal, 0, ',', '.') }}</p>
                                </div>
                            @endforeach
                        </div>
                    </div>

                    <form id="selection-form" method="POST" action="{{ route('cart.selection.update') }}" class="flex flex-col gap-4 rounded-3xl border border-[#FAD4C2] bg-white p-6 shadow-sm md:flex-row md:items-center md:justify-between">
                        @csrf
                        <div>
                            <p class="text-sm text-slate-500">Total produk terpilih</p>
                            <p class="text-xl font-semibold text-slate-900">Rp{{ number_format($cart->items->where('is_selected', true)->sum('subtotal'), 0, ',', '.') }}</p>
                        </div>
                        <div class="flex gap-3">
                            <button type="submit" class="inline-flex items-center rounded-full border border-[#C26A3D] px-6 py-3 text-sm font-semibold text-[#C26A3D] hover:bg-[#FFE2CF] transition">Perbarui Pilihan</button>
                            <a href="{{ route('checkout.index') }}" class="inline-flex items-center rounded-full bg-[#C26A3D] px-6 py-3 text-sm font-semibold text-white hover:bg-[#a85327] transition">Checkout</a>
                        </div>
                    </form>
                </div>
            @endif
        </div>
    </section>
</x-app-layout>
