<x-admin-layout>
    <x-slot name="pageTitle">Pengiriman</x-slot>
    <x-slot name="pageSubtitle">Kelola metode pengiriman, asal kota, dan kunci API.</x-slot>

    <x-admin.card title="Pengaturan Pengiriman">
        <form method="POST" action="{{ route('admin.shipping.update') }}" class="mt-6 grid gap-5 md:grid-cols-2">
            @csrf
            @method('PATCH')
            <div class="space-y-3">
                <x-admin.input-field label="Metode Pengiriman">
                    <div class="grid grid-cols-2 gap-3 text-sm text-slate-700 dark:text-slate-300">
                        <label class="inline-flex items-center gap-2"><input type="checkbox" name="couriers[jne]" value="1" class="rounded border-slate-300 text-[#C26A3D] focus:ring-[#C26A3D]" {{ data_get($enabledCouriers, 'jne') ? 'checked' : '' }}> JNE</label>
                        <label class="inline-flex items-center gap-2"><input type="checkbox" name="couriers[pos]" value="1" class="rounded border-slate-300 text-[#C26A3D] focus:ring-[#C26A3D]" {{ data_get($enabledCouriers, 'pos') ? 'checked' : '' }}> POS</label>
                        <label class="inline-flex items-center gap-2"><input type="checkbox" name="couriers[cod]" value="1" class="rounded border-slate-300 text-[#C26A3D] focus:ring-[#C26A3D]" {{ data_get($enabledCouriers, 'cod') ? 'checked' : '' }}> COD</label>
                        <label class="inline-flex items-center gap-2"><input type="checkbox" name="couriers[internal]" value="1" class="rounded border-slate-300 text-[#C26A3D] focus:ring-[#C26A3D]" {{ data_get($enabledCouriers, 'internal') ? 'checked' : '' }}> Kurir Internal</label>
                    </div>
                </x-admin.input-field>
                <x-admin.input-field label="Kota Asal (Origin City)">
                    <input type="text" name="origin_city" value="{{ $originCity }}" class="admin-input" placeholder="cth: Tangerang" />
                </x-admin.input-field>
            </div>
            <div>
                <x-admin.input-field label="RajaOngkir API Key">
                    <input type="text" name="rajaongkir_key" value="{{ $rajaKey }}" class="admin-input" />
                    <p class="mt-1 text-xs text-slate-500">Biarkan kosong jika tidak ingin mengubah.</p>
                </x-admin.input-field>
            </div>
            <div class="md:col-span-2 flex justify-end gap-2">
                <button class="inline-flex items-center rounded-full bg-[#C26A3D] px-5 py-2 text-sm font-semibold text-white hover:bg-[#a85327]">Simpan</button>
            </div>
        </form>
    </x-admin.card>
</x-admin-layout>

