<x-admin-layout>
    <div class="space-y-8">
        <div class="flex flex-col gap-3 md:flex-row md:items-center md:justify-between">
            <div>
                <h1 class="text-2xl font-semibold text-slate-900">Kelola Produk</h1>
                <p class="text-sm text-slate-500">Tambah produk baru, perbarui stok, dan unggah foto terbaru.</p>
            </div>
            <a href="{{ route('admin.products.create') }}" class="inline-flex items-center justify-center rounded-full bg-[#C26A3D] px-5 py-3 text-sm font-semibold text-white transition hover:bg-[#a85327] md:w-auto w-full">
                Tambah Produk
            </a>
        </div>

        <div class="hidden overflow-hidden rounded-3xl border border-[#FAD4C2] bg-white shadow-lg shadow-[#FAD4C2]/30 md:block">
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-[#FAD4C2]/60 text-sm text-slate-600">
                    <thead class="bg-[#FFF0E6] text-xs font-semibold uppercase tracking-wider text-slate-500">
                        <tr>
                            <th class="px-6 py-4 text-left">Produk</th>
                            <th class="px-6 py-4 text-left">Kategori</th>
                            <th class="px-6 py-4 text-center">Stok</th>
                            <th class="px-6 py-4 text-right">Harga</th>
                            <th class="px-6 py-4 text-center">Status</th>
                            <th class="px-6 py-4 text-center">Aksi</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-[#FAD4C2]/50 bg-white">
                        @forelse ($products as $product)
                            <tr class="transition hover:bg-[#FFF7F2]">
                                <td class="px-6 py-5">
                                    <div class="flex items-center gap-4">
                                        <img src="{{ $product->thumbnail_url }}" alt="{{ $product->name }}" class="h-16 w-16 rounded-2xl object-cover shadow-sm">
                                        <div>
                                            <p class="font-semibold text-slate-900">{{ $product->name }}</p>
                                            <p class="text-xs text-slate-500">SKU: {{ $product->sku }}</p>
                                        </div>
                                    </div>
                                </td>
                                <td class="px-6 py-5">{{ $product->category->name }}</td>
                                <td class="px-6 py-5 text-center font-semibold text-slate-700">{{ $product->stock }}</td>
                                <td class="px-6 py-5 text-right font-semibold text-[#C26A3D]">Rp{{ number_format($product->price, 0, ',', '.') }}</td>
                                <td class="px-6 py-5 text-center">
                                    <span class="inline-flex items-center rounded-full bg-[#FFE2CF] px-4 py-1 text-[11px] font-semibold text-[#C26A3D]">{{ strtoupper($product->status) }}</span>
                                </td>
                                <td class="px-6 py-5 text-center">
                                    <div class="inline-flex gap-2">
                                        <a href="{{ route('admin.products.edit', $product) }}" class="inline-flex items-center rounded-full border border-[#C26A3D] px-4 py-2 text-xs font-semibold text-[#C26A3D] transition hover:bg-[#FFE2CF]">
                                            Edit
                                        </a>
                                        <form method="POST" action="{{ route('admin.products.destroy', $product) }}" onsubmit="return confirm('Hapus produk ini?');">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="inline-flex items-center rounded-full border border-rose-300 px-4 py-2 text-xs font-semibold text-rose-600 transition hover:bg-rose-50">
                                                Hapus
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6" class="px-6 py-10 text-center text-slate-500">Belum ada produk terdaftar.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>

        <div class="space-y-4 md:hidden">
            @forelse ($products as $product)
                <div class="rounded-3xl border border-[#FAD4C2] bg-white p-4 shadow-sm shadow-[#FAD4C2]/30">
                    <div class="flex items-start gap-4">
                        <img src="{{ $product->thumbnail_url }}" alt="{{ $product->name }}" class="h-20 w-20 rounded-2xl object-cover shadow-sm">
                        <div class="flex-1 space-y-1">
                            <div class="flex flex-wrap items-center justify-between gap-2">
                                <p class="text-base font-semibold text-slate-900">{{ $product->name }}</p>
                                <span class="inline-flex items-center rounded-full bg-[#FFE2CF] px-3 py-1 text-[11px] font-semibold text-[#C26A3D]">{{ strtoupper($product->status) }}</span>
                            </div>
                            <p class="text-xs text-slate-500">SKU: {{ $product->sku }}</p>
                            <p class="text-sm font-medium text-slate-600">{{ $product->category->name }}</p>
                            <div class="flex flex-wrap items-center gap-4 text-sm">
                                <span class="font-semibold text-slate-700">Stok: {{ $product->stock }}</span>
                                <span class="font-semibold text-[#C26A3D]">Rp{{ number_format($product->price, 0, ',', '.') }}</span>
                            </div>
                        </div>
                    </div>
                    <div class="mt-4 flex flex-col gap-2 sm:flex-row sm:items-center sm:justify-end">
                        <a href="{{ route('admin.products.edit', $product) }}" class="inline-flex items-center justify-center rounded-full border border-[#C26A3D] px-4 py-2 text-xs font-semibold text-[#C26A3D] transition hover:bg-[#FFE2CF]">
                            Edit
                        </a>
                        <form method="POST" action="{{ route('admin.products.destroy', $product) }}" onsubmit="return confirm('Hapus produk ini?');" class="w-full sm:w-auto">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="inline-flex w-full items-center justify-center rounded-full border border-rose-300 px-4 py-2 text-xs font-semibold text-rose-600 transition hover:bg-rose-50">
                                Hapus
                            </button>
                        </form>
                    </div>
                </div>
            @empty
                <div class="rounded-3xl border border-dashed border-[#FAD4C2] bg-white px-4 py-10 text-center text-sm text-slate-500">
                    Belum ada produk terdaftar.
                </div>
            @endforelse
        </div>

        <div>
            {{ $products->onEachSide(1)->links() }}
        </div>
    </div>
</x-admin-layout>
