<x-admin-layout>
    <x-slot name="pageTitle">Detail Pesanan {{ $order->invoice_number }}</x-slot>

    <div class="space-y-6">
        {{-- Header dengan Real-time Clock --}}
        <div class="rounded-2xl bg-gradient-to-r from-blue-50 to-indigo-50 dark:from-blue-900/20 dark:to-indigo-900/20 border border-blue-200 dark:border-blue-800 p-6">
            <div class="flex flex-col gap-4 lg:flex-row lg:items-center lg:justify-between">
                <div class="flex-1">
                    <p class="text-xs font-semibold uppercase tracking-wide text-blue-600 dark:text-blue-400">Invoice</p>
                    <h1 class="text-2xl sm:text-3xl font-bold text-slate-900 dark:text-slate-100">{{ $order->invoice_number }}</h1>
                    <p class="mt-1 text-sm text-slate-600 dark:text-slate-400">Dibuat pada {{ $order->created_at->translatedFormat('d M Y, H:i') }}</p>
                </div>
                
                {{-- Real-time Clock Display --}}
                <div class="flex items-center gap-3 rounded-xl bg-white/60 dark:bg-slate-800/60 backdrop-blur-sm px-4 py-3 border border-blue-300 dark:border-blue-700">
                    <svg class="h-8 w-8 text-blue-600 dark:text-blue-400 animate-pulse" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
            <div>
                        <div id="order-detail-clock" class="text-xl font-bold text-blue-700 dark:text-blue-300 tabular-nums">--:--:--</div>
                        <div id="order-detail-date" class="text-xs text-blue-600 dark:text-blue-400">-- --- ----</div>
                    </div>
                </div>
            </div>
            
            <div class="mt-4 flex flex-wrap items-center gap-2">
                <span class="rounded-full bg-gradient-to-r from-slate-100 to-slate-200 dark:from-slate-700 dark:to-slate-800 px-3 py-1.5 text-xs font-bold uppercase tracking-wide text-slate-700 dark:text-slate-300 shadow-sm">{{ $order->status }}</span>
                <span class="rounded-full bg-gradient-to-r from-slate-100 to-slate-200 dark:from-slate-700 dark:to-slate-800 px-3 py-1.5 text-xs font-bold uppercase tracking-wide text-slate-700 dark:text-slate-300 shadow-sm">{{ $order->payment_status }}</span>
                @if (in_array($order->status, ['completed'], true) || $order->payment_status === 'paid')
                    <a href="{{ route('admin.orders.print', $order) }}" target="_blank" class="inline-flex items-center gap-2 rounded-full bg-gradient-to-r from-[#C26A3D] to-[#F5703B] px-4 py-1.5 text-xs font-bold text-white shadow-md transition-all hover:scale-105 hover:shadow-lg">
                        <svg class="h-3.5 w-3.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 17h2a2 2 0 002-2v-4a2 2 0 00-2-2H5a2 2 0 00-2 2v4a2 2 0 002 2h2m2 4h6a2 2 0 002-2v-4a2 2 0 00-2-2H9a2 2 0 00-2 2v4a2 2 0 002 2zm8-12V5a2 2 0 00-2-2H9a2 2 0 00-2 2v4h10z"></path>
                        </svg>
                        Cetak Resi
                    </a>
                @endif
                <a href="{{ route('admin.orders.index') }}" class="inline-flex items-center gap-2 rounded-full border-2 border-[#C26A3D] bg-white dark:bg-slate-800 px-4 py-1.5 text-xs font-bold text-[#C26A3D] dark:text-[#F5703B] transition-all hover:bg-[#C26A3D] hover:text-white">
                    <svg class="h-3.5 w-3.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path>
                    </svg>
                    Kembali
                </a>
            </div>
        </div>

        <div class="grid gap-6 lg:grid-cols-[1.2fr,0.8fr]">
            <div class="space-y-4">
                <div class="rounded-3xl border border-[#FAD4C2] bg-white p-6 shadow-sm space-y-4">
                    <h2 class="text-lg font-semibold text-slate-900">Detail Produk</h2>
                    <div class="space-y-3 text-sm text-slate-600">
                        @forelse ($order->items as $item)
                            <div class="flex items-start justify-between gap-4">
                                <div>
                                    <p class="font-semibold text-slate-900">{{ $item->product_name }}</p>
                                    <span class="text-xs">{{ $item->quantity }} x Rp{{ number_format($item->unit_price, 0, ',', '.') }}</span>
                                </div>
                                <p class="font-semibold text-[#C26A3D]">Rp{{ number_format($item->subtotal, 0, ',', '.') }}</p>
                            </div>
                        @empty
                            <p class="text-xs text-slate-500">Belum ada item.</p>
                        @endforelse
                    </div>
                </div>

                <div class="rounded-3xl border border-[#FAD4C2] bg-white p-6 shadow-sm space-y-3 text-sm text-slate-600">
                    <h2 class="text-lg font-semibold text-slate-900">Pengiriman & Kontak</h2>
                    <p><strong class="text-slate-900">Pemesan:</strong> {{ $order->user ? $order->user->name : data_get($order->shipping_address, 'recipient_name', 'Pelanggan Umum') }}</p>
                    <p><strong class="text-slate-900">Email:</strong> {{ $order->user?->email ?? data_get($order->shipping_address, 'email', '-') }}</p>
                    <p><strong class="text-slate-900">Kurir:</strong> {{ strtoupper($order->shipping_courier ?? 'Pickup') }}</p>
                    <p><strong class="text-slate-900">Alamat:</strong> {{ data_get($order->shipping_address, 'address_line1', '-') }}{{ data_get($order->shipping_address, 'city') ? ', ' . data_get($order->shipping_address, 'city') : '' }}{{ data_get($order->shipping_address, 'province') ? ', ' . data_get($order->shipping_address, 'province') : '' }}</p>
                    <p><strong class="text-slate-900">Catatan:</strong> {{ $order->notes ?? '-' }}</p>
                </div>
            </div>

            <aside class="space-y-4">
                <div class="rounded-3xl border border-[#FAD4C2] bg-white p-6 shadow-sm space-y-3 text-sm text-slate-600">
                    <h2 class="text-lg font-semibold text-slate-900">Ringkasan Biaya</h2>
                    <div class="flex justify-between">
                        <span>Subtotal</span>
                        <span>Rp{{ number_format($order->subtotal_amount, 0, ',', '.') }}</span>
                    </div>
                    <div class="flex justify-between">
                        <span>Diskon</span>
                        <span>- Rp{{ number_format($order->discount_amount, 0, ',', '.') }}</span>
                    </div>
                    <div class="flex justify-between">
                        <span>Ongkos Kirim</span>
                        <span>Rp{{ number_format($order->shipping_cost, 0, ',', '.') }}</span>
                    </div>
                    <div class="flex justify-between">
                        <span>Biaya Layanan</span>
                        <span>Rp{{ number_format($order->service_fee ?? 0, 0, ',', '.') }}</span>
                    </div>
                    <hr class="border-[#FAD4C2]">
                    <div class="flex justify-between text-base font-semibold text-slate-900">
                        <span>Total Bayar</span>
                        <span>Rp{{ number_format($order->grand_total, 0, ',', '.') }}</span>
                    </div>
                    <p class="text-xs text-slate-500">Status pembayaran: {{ strtoupper($order->payment_status) }}</p>
                </div>

                <div class="rounded-3xl border border-[#FAD4C2] bg-white p-6 shadow-sm space-y-4 text-sm text-slate-600">
                    <h2 class="text-lg font-semibold text-slate-900">Aksi Admin</h2>
                    @if (!in_array($order->status, ['completed','cancelled','refunded'], true))
                        <div class="space-y-3">
                            <form method="POST" action="{{ route('admin.orders.update-status', $order) }}" class="inline">
                                @csrf
                                @method('PATCH')
                                <input type="hidden" name="status" value="processing">
                                <button type="submit" class="inline-flex items-center rounded-full bg-amber-600 px-4 py-2 text-xs font-semibold text-white hover:bg-amber-700 transition">Tandai Dikemas</button>
                            </form>

                            <form method="POST" action="{{ route('admin.orders.ship', $order) }}" class="space-y-2">
                                @csrf
                                @method('PATCH')
                                <div class="grid grid-cols-1 gap-2">
                                    <div>
                                        <label class="block text-xs text-slate-500 mb-1">Kurir</label>
                                        <input type="text" name="shipping_courier" value="{{ old('shipping_courier', strtoupper($order->shipping_courier ?? '')) }}" placeholder="JNE / JNT / SICEPAT" class="w-full rounded-xl border border-[#FAD4C2] px-3 py-2 focus:outline-none">
                                    </div>
                                    <div>
                                        <label class="block text-xs text-slate-500 mb-1">No. Resi</label>
                                        <input type="text" name="tracking_number" value="{{ old('tracking_number', $order->tracking_number) }}" placeholder="Masukkan nomor resi" class="w-full rounded-xl border border-[#FAD4C2] px-3 py-2 focus:outline-none">
                                    </div>
                                </div>
                                <button type="submit" class="inline-flex items-center rounded-full bg-blue-600 px-4 py-2 text-xs font-semibold text-white hover:bg-blue-700 transition">Tandai Dikirim</button>
                            </form>

                            <form method="POST" action="{{ route('admin.orders.update-status', $order) }}" class="inline">
                                @csrf
                                @method('PATCH')
                                <input type="hidden" name="status" value="completed">
                                <button type="submit" class="inline-flex items-center rounded-full bg-emerald-600 px-4 py-2 text-xs font-semibold text-white hover:bg-emerald-700 transition">Tandai Diterima</button>
                            </form>
                        </div>
                    @else
                        <p class="text-xs text-slate-500">Pesanan telah {{ $order->status }}.</p>
                    @endif

                    @error('status')
                        <p class="text-xs text-rose-600">{{ $message }}</p>
                    @enderror
                    @error('tracking_number')
                        <p class="text-xs text-rose-600">{{ $message }}</p>
                    @enderror
                </div>

                <div class="rounded-3xl border border-[#FAD4C2] bg-[#FFF8F3] p-6 shadow-sm space-y-3 text-sm text-slate-600">
                    <h2 class="text-lg font-semibold text-slate-900">Riwayat Pembayaran</h2>
                    @if ($order->payments->isNotEmpty())
                        <ul class="space-y-2">
                            @foreach ($order->payments as $payment)
                                <li class="rounded-2xl border border-slate-200 bg-white/80 px-3 py-2">
                                    <div class="flex items-center justify-between text-xs text-slate-500">
                                        <span>{{ strtoupper($payment->method) }}</span>
                                        <span>{{ strtoupper($payment->status) }}</span>
                                    </div>
                                    <p class="text-sm font-semibold text-slate-800">{{ $payment->reference }}</p>
                                </li>
                            @endforeach
                        </ul>
                    @else
                        <p class="text-xs text-slate-500">Belum ada pembayaran tercatat.</p>
                    @endif
                </div>
            </aside>
        </div>
    </div>

    @push('scripts')
        <script>
            // Real-time Clock untuk Detail Pesanan
            (function() {
                function updateOrderDetailClock() {
                    const now = new Date();
                    
                    // Format waktu
                    const hours = String(now.getHours()).padStart(2, '0');
                    const minutes = String(now.getMinutes()).padStart(2, '0');
                    const seconds = String(now.getSeconds()).padStart(2, '0');
                    const timeString = `${hours}:${minutes}:${seconds}`;
                    
                    // Format tanggal Indonesia
                    const days = ['Minggu', 'Senin', 'Selasa', 'Rabu', 'Kamis', 'Jumat', 'Sabtu'];
                    const months = ['Jan', 'Feb', 'Mar', 'Apr', 'Mei', 'Jun', 'Jul', 'Agu', 'Sep', 'Okt', 'Nov', 'Des'];
                    
                    const dayName = days[now.getDay()];
                    const day = now.getDate();
                    const month = months[now.getMonth()];
                    const year = now.getFullYear();
                    const dateString = `${dayName}, ${day} ${month} ${year}`;
                    
                    // Update elemen
                    const clockEl = document.getElementById('order-detail-clock');
                    const dateEl = document.getElementById('order-detail-date');
                    
                    if (clockEl) clockEl.textContent = timeString;
                    if (dateEl) dateEl.textContent = dateString;
                }
                
                // Jalankan langsung dan setiap detik
                updateOrderDetailClock();
                setInterval(updateOrderDetailClock, 1000);
            })();
        </script>
    @endpush
</x-admin-layout>
