<x-admin-layout>
    <x-slot name="pageTitle">Manajemen Pesanan Online</x-slot>
    <x-slot name="pageSubtitle">Kelola seluruh pesanan yang datang dari website dan marketplace.</x-slot>

    <div class="space-y-8">
        {{-- Quick Actions --}}
        <div class="flex flex-wrap items-center justify-between gap-3 rounded-2xl bg-gradient-to-r from-blue-50 to-indigo-50 dark:from-blue-900/20 dark:to-indigo-900/20 border border-blue-200 dark:border-blue-800 p-4">
            <div class="flex items-center gap-3">
                <div class="rounded-full bg-blue-500 p-2">
                    <svg class="h-5 w-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                    </svg>
                </div>
                <div>
                    <h3 class="text-sm font-bold text-slate-900 dark:text-slate-100">Export Laporan Penjualan</h3>
                    <p class="text-xs text-slate-600 dark:text-slate-400">Download data penjualan ke Excel dengan filter periode</p>
                </div>
            </div>
            <a href="{{ route('admin.income.index') }}" class="inline-flex items-center gap-2 rounded-xl bg-gradient-to-r from-blue-600 to-indigo-600 px-5 py-2.5 text-sm font-bold text-white shadow-lg shadow-blue-500/30 transition-all hover:scale-105 hover:shadow-xl">
                <svg class="h-4 w-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                </svg>
                Export Data
            </a>
        </div>

        <div class="grid gap-6 md:grid-cols-2 xl:grid-cols-4">
            <x-admin.metric-card title="Pesanan Hari Ini" subtitle="Pesanan via website" value="{{ $summary['todayOnline'] }}" variant="primary" />
            <x-admin.metric-card title="Total Pesanan" subtitle="Semua pesanan online" value="{{ $summary['totalOrders'] }}" variant="info" />
            <x-admin.metric-card title="Belum Lunas" subtitle="Perlu tindak lanjut" value="{{ $summary['awaitingPayment'] }}" variant="warning" />
            <x-admin.metric-card title="Total Penghasilan" subtitle="Dari pesanan online" value="Rp{{ number_format($summary['totalIncome'], 0, ',', '.') }}" variant="success" />
        </div>

        <x-admin.card title="Filter Pesanan">
            <form method="GET" class="mt-4 grid gap-4 lg:grid-cols-[2fr,1fr,1fr]">
                <x-admin.input-field label="Cari Invoice / Pelanggan">
                    <input type="text" name="search" value="{{ $filters['search'] }}" placeholder="INV123, nama pelanggan, email..." class="admin-input">
                </x-admin.input-field>

                <x-admin.input-field label="Status Order">
                    <select name="status" class="admin-input">
                        @foreach ($statusOptions as $value => $label)
                            <option value="{{ $value }}" @selected($filters['status'] === $value)>{{ $label }}</option>
                        @endforeach
                    </select>
                </x-admin.input-field>

                <x-admin.input-field label="Status Pembayaran">
                    <select name="payment_status" class="admin-input">
                        @foreach ($paymentStatusOptions as $value => $label)
                            <option value="{{ $value }}" @selected($filters['payment_status'] === $value)>{{ $label }}</option>
                        @endforeach
                    </select>
                </x-admin.input-field>

                <div class="lg:col-span-3 flex flex-wrap justify-end gap-2 pt-2">
                    <a href="{{ route('admin.orders.index') }}" class="inline-flex items-center rounded-full border border-slate-300 px-4 py-2 text-sm font-semibold text-slate-600 transition hover:bg-slate-100">Reset</a>
                    <button type="submit" class="inline-flex items-center rounded-full bg-[#C26A3D] px-5 py-2 text-sm font-semibold text-white transition hover:bg-[#a85327]">Terapkan</button>
                </div>
            </form>
        </x-admin.card>

        <x-admin.card title="Daftar Pesanan Online">
            <div class="mt-4 overflow-hidden rounded-2xl border border-[#FAD4C2]/60">
                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-[#FAD4C2]/60 text-sm text-slate-600">
                        <thead class="bg-[#FFF0E6] text-xs font-semibold uppercase tracking-wider text-slate-500">
                            <tr>
                                <th class="px-4 py-3 text-left">Invoice</th>
                                <th class="px-4 py-3 text-left">Pelanggan</th>
                                <th class="px-4 py-3 text-center">Status</th>
                                <th class="px-4 py-3 text-center">Pembayaran</th>
                                <th class="px-4 py-3 text-right">Total</th>
                                <th class="px-4 py-3 text-right">Tanggal</th>
                                <th class="px-4 py-3 text-right">Aksi</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-[#FAD4C2]/50 bg-white">
                            @forelse ($orders as $order)
                                <tr class="transition hover:bg-[#FFF7F2]">
                                    <td class="px-4 py-4 font-semibold text-slate-800">{{ $order->invoice_number }}</td>
                                    <td class="px-4 py-4 text-sm">
                                        <div class="font-semibold text-slate-800">
                                            {{ $order->user ? $order->user->name : (data_get($order->shipping_address, 'recipient_name', 'Pelanggan Umum')) }}
                                        </div>
                                        <div class="text-xs text-slate-500">
                                            @if ($order->user)
                                                <span class="inline-flex items-center gap-1">
                                                    <svg class="h-3 w-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                                                    </svg>
                                                    {{ $order->user->email }}
                                                </span>
                                            @else
                                                <span class="text-slate-400">Tamu / Non-member</span>
                                            @endif
                                        </div>
                                    </td>
                                    <td class="px-4 py-4 text-center">
                                        @php
                                            $statusLabels = [
                                                'pending' => 'Menunggu',
                                                'confirmed' => 'Dikonfirmasi',
                                                'processing' => 'Diproses',
                                                'shipped' => 'Dikirim',
                                                'delivered' => 'Sudah Tiba',
                                                'completed' => 'Selesai',
                                                'cancelled' => 'Dibatalkan',
                                                'refunded' => 'Dikembalikan',
                                            ];
                                            $statusColors = [
                                                'pending' => 'bg-slate-100 text-slate-700',
                                                'confirmed' => 'bg-blue-100 text-blue-700',
                                                'processing' => 'bg-amber-100 text-amber-700',
                                                'shipped' => 'bg-blue-100 text-blue-700',
                                                'delivered' => 'bg-purple-100 text-purple-700',
                                                'completed' => 'bg-emerald-100 text-emerald-700',
                                                'cancelled' => 'bg-rose-100 text-rose-700',
                                                'refunded' => 'bg-orange-100 text-orange-700',
                                            ];
                                            $label = $statusLabels[$order->status] ?? strtoupper($order->status);
                                            $color = $statusColors[$order->status] ?? 'bg-slate-100 text-slate-700';
                                        @endphp
                                        <span class="inline-flex items-center rounded-full px-3 py-1 text-[11px] font-semibold {{ $color }}">{{ $label }}</span>
                                    </td>
                                    <td class="px-4 py-4 text-center">
                                        <span class="inline-flex items-center rounded-full px-3 py-1 text-[11px] font-semibold
                                            @class([
                                                'bg-emerald-100 text-emerald-700' => $order->payment_status === 'paid',
                                                'bg-amber-100 text-amber-700' => $order->payment_status === 'awaiting_confirmation',
                                                'bg-rose-100 text-rose-600' => in_array($order->payment_status, ['failed', 'refunded']),
                                                'bg-slate-200 text-slate-700' => $order->payment_status === 'unpaid',
                                            ])">
                                            {{ strtoupper($order->payment_status) }}
                                        </span>
                                    </td>
                                    <td class="px-4 py-4 text-right font-semibold text-[#C26A3D]">Rp{{ number_format($order->grand_total, 0, ',', '.') }}</td>
                                    <td class="px-4 py-4 text-right text-xs text-slate-500">{{ $order->created_at->translatedFormat('d M Y, H:i') }}</td>
                                    <td class="px-4 py-4 text-right">
                                        <a href="{{ route('admin.orders.detail', $order) }}" class="inline-flex items-center rounded-full border border-[#C26A3D] px-3 py-1 text-xs font-semibold text-[#C26A3D] transition hover:bg-[#FFE2CF]">Detail</a>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="7" class="px-4 py-10 text-center text-slate-500">
                                        <div class="flex flex-col items-center justify-center">
                                            <svg class="h-12 w-12 text-slate-300 mb-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"></path>
                                            </svg>
                                            <p class="text-sm font-medium">Tidak ada pesanan online ditemukan</p>
                                            <p class="text-xs text-slate-400 mt-1">Coba ubah filter atau kata kunci pencarian</p>
                                        </div>
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>

            <div class="mt-4">
                {{ $orders->onEachSide(1)->links() }}
            </div>
        </x-admin.card>

        <!-- Info Box -->
        <div class="rounded-2xl border border-[#FAD4C2] bg-gradient-to-br from-blue-50 to-indigo-50 p-6">
            <div class="flex items-start gap-4">
                <div class="rounded-full bg-blue-500 p-3">
                    <svg class="h-6 w-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                </div>
                <div class="flex-1">
                    <h4 class="text-lg font-semibold text-slate-900 mb-2">Tentang Pesanan Online</h4>
                    <p class="text-sm text-slate-600 leading-relaxed mb-3">
                        Halaman ini menampilkan semua pesanan yang masuk melalui website dan marketplace. Untuk melihat laporan transaksi kasir offline, silakan kunjungi halaman <strong>Laporan Kasir</strong> di menu navigasi.
                    </p>
                    <a href="{{ route('cashier.dashboard') }}" class="inline-flex items-center gap-2 text-sm font-semibold text-blue-600 hover:text-blue-700 transition">
                        <svg class="h-4 w-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"></path>
                        </svg>
                        Buka Kasir / POS →
                    </a>
                </div>
            </div>
        </div>
    </div>
</x-admin-layout>
