<x-app-layout>
    <section class="py-10">
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 space-y-6">
            <header class="space-y-2">
                <h1 class="text-2xl font-semibold text-slate-900">Edit Jurnal</h1>
                <p class="text-sm text-slate-500">Perbarui konten artikel dan status publikasi.</p>
            </header>

            <form method="POST" action="{{ route('admin.journals.update', $journal) }}" enctype="multipart/form-data" class="space-y-6">
                @csrf
                @method('PUT')
                <div class="rounded-3xl border border-[#FAD4C2] bg-white p-6 shadow-sm space-y-4">
                    <div>
                        <label class="text-xs font-semibold text-slate-600">Judul</label>
                        <input type="text" name="title" value="{{ old('title', $journal->title) }}" required class="mt-1 w-full rounded-full border border-[#FAD4C2] bg-[#FFF8F3] px-4 py-2 text-sm focus:border-[#C26A3D] focus:ring-0" />
                    </div>
                    <div>
                        <label class="text-xs font-semibold text-slate-600">Subjudul</label>
                        <input type="text" name="subtitle" value="{{ old('subtitle', $journal->subtitle) }}" class="mt-1 w-full rounded-full border border-[#FAD4C2] bg-[#FFF8F3] px-4 py-2 text-sm focus:border-[#C26A3D] focus:ring-0" />
                    </div>
                    <div>
                        <label class="text-xs font-semibold text-slate-600">Ringkasan</label>
                        <textarea name="excerpt" rows="3" class="mt-1 w-full rounded-2xl border border-[#FAD4C2] bg-[#FFF8F3] px-4 py-2 text-sm focus:border-[#C26A3D] focus:ring-0">{{ old('excerpt', $journal->excerpt) }}</textarea>
                    </div>
                    <div>
                        <label class="text-xs font-semibold text-slate-600">Konten</label>
                        <textarea name="body" rows="10" required class="mt-1 w-full rounded-2xl border border-[#FAD4C2] bg-[#FFF8F3] px-4 py-2 text-sm focus:border-[#C26A3D] focus:ring-0">{{ old('body', $journal->body) }}</textarea>
                    </div>
                    <div class="grid gap-4 md:grid-cols-2">
                        <div>
                            <label class="text-xs font-semibold text-slate-600">Tag (pisahkan dengan koma)</label>
                            <input type="text" name="tags" value="{{ old('tags', $journal->tags ? implode(', ', $journal->tags) : '') }}" class="mt-1 w-full rounded-full border border-[#FAD4C2] bg-[#FFF8F3] px-4 py-2 text-sm focus:border-[#C26A3D] focus:ring-0" />
                        </div>
                        <div>
                            <label class="text-xs font-semibold text-slate-600">Tanggal Publikasi</label>
                            <input type="datetime-local" name="published_at" value="{{ old('published_at', optional($journal->published_at)->format('Y-m-d\TH:i')) }}" class="mt-1 w-full rounded-full border border-[#FAD4C2] bg-[#FFF8F3] px-4 py-2 text-sm focus:border-[#C26A3D] focus:ring-0" />
                        </div>
                    </div>
                    <div class="flex items-center gap-3">
                        <label class="text-xs font-semibold text-slate-600">Artikel unggulan?</label>
                        <input type="checkbox" name="is_featured" value="1" {{ old('is_featured', $journal->is_featured) ? 'checked' : '' }} class="h-4 w-4 rounded border-[#FAD4C2] text-[#C26A3D] focus:ring-[#C26A3D]">
                    </div>
                </div>

                <div class="rounded-3xl border border-[#FAD4C2] bg-white p-6 shadow-sm space-y-4">
                    <label class="text-xs font-semibold text-slate-600">Hero Image</label>
                    <input type="file" name="hero_image" class="block w-full text-sm text-slate-600" accept="image/*" />
                    @if ($journal->hero_image)
                        <img src="{{ $journal->hero_image }}" alt="{{ $journal->title }}" class="h-40 w-full rounded-2xl object-cover">
                    @endif
                </div>

                <button type="submit" class="inline-flex items-center rounded-full bg-[#C26A3D] px-6 py-3 text-sm font-semibold text-white hover:bg-[#a85327] transition">Simpan Perubahan</button>
            </form>
        </div>
    </section>
</x-app-layout>
