<x-app-layout>
    <section class="py-10">
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 space-y-6">
            <header class="space-y-2">
                <h1 class="text-2xl font-semibold text-slate-900">Tulis Artikel Jurnal</h1>
                <p class="text-sm text-slate-500">Bagikan insight baru untuk pelanggan dan komunitas UMKM.</p>
            </header>

            <form method="POST" action="{{ route('admin.journals.store') }}" enctype="multipart/form-data" class="space-y-6">
                @csrf
                <div class="rounded-3xl border border-[#FAD4C2] bg-white p-6 shadow-sm space-y-4">
                    <div>
                        <label class="text-xs font-semibold text-slate-600">Judul</label>
                        <input type="text" name="title" value="{{ old('title') }}" required class="mt-1 w-full rounded-full border border-[#FAD4C2] bg-[#FFF8F3] px-4 py-2 text-sm focus:border-[#C26A3D] focus:ring-0" />
                    </div>
                    <div>
                        <label class="text-xs font-semibold text-slate-600">Subjudul</label>
                        <input type="text" name="subtitle" value="{{ old('subtitle') }}" class="mt-1 w-full rounded-full border border-[#FAD4C2] bg-[#FFF8F3] px-4 py-2 text-sm focus:border-[#C26A3D] focus:ring-0" />
                    </div>
                    <div>
                        <label class="text-xs font-semibold text-slate-600">Ringkasan</label>
                        <textarea name="excerpt" rows="3" class="mt-1 w-full rounded-2xl border border-[#FAD4C2] bg-[#FFF8F3] px-4 py-2 text-sm focus:border-[#C26A3D] focus:ring-0">{{ old('excerpt') }}</textarea>
                    </div>
                    <div>
                        <label class="text-xs font-semibold text-slate-600">Konten</label>
                        <textarea name="body" rows="10" required class="mt-1 w-full rounded-2xl border border-[#FAD4C2] bg-[#FFF8F3] px-4 py-2 text-sm focus:border-[#C26A3D] focus:ring-0">{{ old('body') }}</textarea>
                    </div>
                    <div class="grid gap-4 md:grid-cols-2">
                        <div>
                            <label class="text-xs font-semibold text-slate-600">Tag (pisahkan dengan koma)</label>
                            <input type="text" name="tags" value="{{ old('tags') }}" class="mt-1 w-full rounded-full border border-[#FAD4C2] bg-[#FFF8F3] px-4 py-2 text-sm focus:border-[#C26A3D] focus:ring-0" />
                        </div>
                        <div>
                            <label class="text-xs font-semibold text-slate-600">Tanggal Publikasi</label>
                            <input type="datetime-local" name="published_at" value="{{ old('published_at') }}" class="mt-1 w-full rounded-full border border-[#FAD4C2] bg-[#FFF8F3] px-4 py-2 text-sm focus:border-[#C26A3D] focus:ring-0" />
                        </div>
                    </div>
                    <div class="flex items-center gap-3">
                        <label class="text-xs font-semibold text-slate-600">Artikel unggulan?</label>
                        <input type="checkbox" name="is_featured" value="1" {{ old('is_featured') ? 'checked' : '' }} class="h-4 w-4 rounded border-[#FAD4C2] text-[#C26A3D] focus:ring-[#C26A3D]">
                    </div>
                </div>

                <div class="rounded-3xl border border-[#FAD4C2] bg-white p-6 shadow-sm space-y-4">
                    <label class="text-xs font-semibold text-slate-600">Hero Image</label>
                    <input type="file" name="hero_image" class="block w-full text-sm text-slate-600" accept="image/*" />
                </div>

                <button type="submit" class="inline-flex items-center rounded-full bg-[#C26A3D] px-6 py-3 text-sm font-semibold text-white hover:bg-[#a85327] transition">Simpan Artikel</button>
            </form>
        </div>
    </section>
</x-app-layout>
