<x-admin-layout>
    <x-slot name="pageTitle">Laporan Penghasilan</x-slot>
    <x-slot name="pageSubtitle">Unduh laporan ke Excel dan pantau penjualan yang sudah dibayar.</x-slot>

    <div class="space-y-4 sm:space-y-6">
        {{-- Export Banner --}}
        <div class="overflow-hidden rounded-xl sm:rounded-2xl bg-gradient-to-r from-emerald-500 to-teal-600 p-4 sm:p-6 shadow-xl">
            <div class="flex flex-col gap-3 sm:gap-4">
                <div class="flex items-start gap-3 sm:gap-4">
                    <div class="rounded-lg sm:rounded-xl bg-white/20 p-2 sm:p-3 shrink-0">
                        <svg class="h-6 w-6 sm:h-8 sm:w-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                        </svg>
                    </div>
                    <div class="flex-1 min-w-0">
                        <h3 class="text-base sm:text-xl font-bold text-white">Export Laporan</h3>
                        <p class="mt-0.5 sm:mt-1 text-xs sm:text-sm text-emerald-50">
                            <span class="font-semibold">{{ \Carbon\Carbon::parse($start)->translatedFormat('d M Y') }}</span> - <span class="font-semibold">{{ \Carbon\Carbon::parse($end)->translatedFormat('d M Y') }}</span>
                        </p>
                    </div>
                </div>
                <a href="{{ route('admin.income.export', ['start' => $start, 'end' => $end]) }}" class="inline-flex items-center justify-center gap-2 rounded-lg sm:rounded-xl bg-white px-4 sm:px-6 py-2.5 sm:py-3 text-xs sm:text-sm font-bold text-emerald-600 shadow-lg transition-all hover:scale-105 hover:shadow-xl w-full sm:w-auto">
                    <svg class="h-4 w-4 sm:h-5 sm:w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                    </svg>
                    Download Excel
                </a>
            </div>
        </div>

        <x-admin.card title="Filter Periode">
            {{-- Quick Filters --}}
            <div class="mt-3 sm:mt-4 grid grid-cols-2 sm:flex sm:flex-wrap gap-2">
                <a href="{{ route('admin.income.index', ['start' => now()->toDateString(), 'end' => now()->toDateString()]) }}" class="inline-flex items-center justify-center gap-1 rounded-lg border-2 border-blue-200 bg-blue-50 px-2.5 sm:px-3 py-1.5 text-[11px] sm:text-xs font-semibold text-blue-700 transition hover:border-blue-300 hover:bg-blue-100">
                    <svg class="h-3 w-3 hidden sm:block" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                    </svg>
                    Hari Ini
                </a>
                <a href="{{ route('admin.income.index', ['start' => now()->startOfWeek()->toDateString(), 'end' => now()->endOfWeek()->toDateString()]) }}" class="inline-flex items-center justify-center gap-1 rounded-lg border-2 border-purple-200 bg-purple-50 px-2.5 sm:px-3 py-1.5 text-[11px] sm:text-xs font-semibold text-purple-700 transition hover:border-purple-300 hover:bg-purple-100">
                    <svg class="h-3 w-3 hidden sm:block" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                    </svg>
                    Minggu Ini
                </a>
                <a href="{{ route('admin.income.index', ['start' => now()->startOfMonth()->toDateString(), 'end' => now()->endOfMonth()->toDateString()]) }}" class="inline-flex items-center justify-center gap-1 rounded-lg border-2 border-emerald-200 bg-emerald-50 px-2.5 sm:px-3 py-1.5 text-[11px] sm:text-xs font-semibold text-emerald-700 transition hover:border-emerald-300 hover:bg-emerald-100">
                    <svg class="h-3 w-3 hidden sm:block" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                    </svg>
                    Bulan Ini
                </a>
                <a href="{{ route('admin.income.index', ['start' => now()->subDays(30)->toDateString(), 'end' => now()->toDateString()]) }}" class="inline-flex items-center justify-center gap-1 rounded-lg border-2 border-amber-200 bg-amber-50 px-2.5 sm:px-3 py-1.5 text-[11px] sm:text-xs font-semibold text-amber-700 transition hover:border-amber-300 hover:bg-amber-100">
                    <svg class="h-3 w-3 hidden sm:block" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                    </svg>
                    30 Hari
                </a>
            </div>

            {{-- Custom Date Range --}}
            <form method="GET" action="{{ route('admin.income.index') }}" class="mt-4 grid gap-3 sm:gap-4 sm:grid-cols-3 sm:items-end">
                <div>
                    <label class="text-[11px] sm:text-xs font-semibold text-slate-600">Mulai</label>
                    <input type="date" name="start" value="{{ $start }}" class="mt-1 w-full rounded-lg sm:rounded-xl border border-slate-300 dark:border-slate-600 bg-white dark:bg-slate-800 px-3 sm:px-4 py-2 text-xs sm:text-sm focus:border-blue-500 focus:ring-2 focus:ring-blue-500/20">
                </div>
                <div>
                    <label class="text-[11px] sm:text-xs font-semibold text-slate-600">Selesai</label>
                    <input type="date" name="end" value="{{ $end }}" class="mt-1 w-full rounded-lg sm:rounded-xl border border-slate-300 dark:border-slate-600 bg-white dark:bg-slate-800 px-3 sm:px-4 py-2 text-xs sm:text-sm focus:border-blue-500 focus:ring-2 focus:ring-blue-500/20">
                </div>
                <button type="submit" class="inline-flex items-center justify-center gap-2 rounded-lg sm:rounded-xl bg-gradient-to-r from-blue-600 to-indigo-600 px-4 sm:px-5 py-2 text-xs sm:text-sm font-bold text-white shadow-md transition-all hover:scale-105 hover:shadow-lg">
                    <svg class="h-3.5 w-3.5 sm:h-4 sm:w-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                    </svg>
                    <span class="hidden sm:inline">Filter Custom</span>
                    <span class="sm:hidden">Filter</span>
                </button>
            </form>
        </x-admin.card>

        {{-- Summary Card --}}
        <div class="rounded-xl sm:rounded-2xl border border-blue-200 bg-gradient-to-br from-blue-50 to-indigo-50 dark:from-blue-900/20 dark:to-indigo-900/20 p-4 sm:p-6">
            <div class="flex items-start gap-3 sm:items-center sm:justify-between">
                <div class="flex-1 min-w-0">
                    <p class="text-xs sm:text-sm font-semibold text-blue-600 dark:text-blue-400">Total Penghasilan Bersih</p>
                    <p class="mt-1 sm:mt-2 text-xl sm:text-3xl font-bold text-slate-900 dark:text-slate-100 break-all">Rp{{ number_format($totalIncome, 0, ',', '.') }}</p>
                    <p class="mt-1 text-[10px] sm:text-xs text-slate-600 dark:text-slate-400">{{ $orders->total() }} transaksi dibayar</p>
                </div>
                <div class="rounded-lg sm:rounded-xl bg-blue-500 p-2.5 sm:p-4 shrink-0">
                    <svg class="h-7 w-7 sm:h-10 sm:w-10 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                </div>
            </div>
        </div>

        <x-admin.card title="Detail Transaksi" subtitle="{{ $orders->total() }} pesanan lunas">
            <div class="mt-3 sm:mt-4 overflow-hidden rounded-xl sm:rounded-2xl border border-slate-200 dark:border-slate-700 shadow-sm">
                <div class="overflow-x-auto -mx-px">
                    <table class="min-w-full divide-y divide-[#FAD4C2]/60 text-sm text-slate-600">
                        <thead class="bg-[#FFF0E6] text-xs font-semibold uppercase tracking-wider text-slate-500">
                            <tr>
                                <th class="px-4 py-3 text-left">Invoice</th>
                                <th class="px-4 py-3 text-left">Tanggal</th>
                                <th class="px-4 py-3 text-left">Pelanggan</th>
                                <th class="px-4 py-3 text-left">Produk</th>
                                <th class="px-4 py-3 text-right">Items</th>
                                <th class="px-4 py-3 text-right">Subtotal</th>
                                <th class="px-4 py-3 text-right">Diskon</th>
                                <th class="px-4 py-3 text-right">Ongkir</th>
                                <th class="px-4 py-3 text-right">Total Bersih</th>
                                <th class="px-4 py-3 text-left">Metode</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-[#FAD4C2]/50 bg-white">
                            @forelse ($orders as $order)
                                <tr class="transition hover:bg-[#FFF7F2]">
                                    <td class="px-4 py-4 font-semibold text-slate-900">
                                        {{ $order->invoice_number }}
                                    </td>
                                    <td class="px-4 py-4 text-xs text-slate-500">
                                        {{ $order->paid_at?->translatedFormat('d M Y, H:i') }}
                                    </td>
                                <td class="px-4 py-4 text-sm text-slate-700">
                                    {{ $order->customer_name ?? '-' }}
                                </td>
                                @php
                                    $products = $order->items->pluck('product_name')->filter()->unique()->values();
                                    $productsLabel = $products->isNotEmpty()
                                        ? \Illuminate\Support\Str::limit($products->join(', '), 80)
                                        : '-';
                                @endphp
                                <td class="px-4 py-4 text-sm text-slate-600">
                                    {{ $productsLabel }}
                                </td>
                                <td class="px-4 py-4 text-right font-semibold text-slate-800">
                                    {{ $order->total_items }}
                                </td>
                                    <td class="px-4 py-4 text-right font-semibold text-[#C26A3D]">
                                        Rp{{ number_format($order->subtotal_amount, 0, ',', '.') }}
                                    </td>
                                    <td class="px-4 py-4 text-right text-slate-500">
                                        Rp{{ number_format($order->discount_amount ?? 0, 0, ',', '.') }}
                                    </td>
                                    <td class="px-4 py-4 text-right text-slate-500">
                                        Rp{{ number_format($order->shipping_cost ?? 0, 0, ',', '.') }}
                                    </td>
                                    <td class="px-4 py-4 text-right font-semibold text-[#C26A3D]">
                                        Rp{{ number_format($order->net_income, 0, ',', '.') }}
                                    </td>
                                    <td class="px-4 py-4 text-sm font-semibold text-slate-600">
                                        {{ strtoupper($order->payment_method) }}
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                <td colspan="10" class="px-4 py-10 text-center text-slate-500">Belum ada transaksi dibayar di periode ini.</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="mt-4">
                {{ $orders->onEachSide(1)->links() }}
            </div>
        </x-admin.card>
    </div>
</x-admin-layout>
