<x-admin-layout>
    <x-slot name="pageTitle">Pelanggan</x-slot>
    <x-slot name="pageSubtitle">Data pelanggan terdaftar dan ringkasan pembelian.</x-slot>

    <x-admin.card title="Filter & Pencarian">
        <form method="GET" class="mt-4 grid gap-4 md:grid-cols-[2fr,1fr]">
            <x-admin.input-field label="Cari nama / email">
                <input type="text" name="search" value="{{ $search }}" placeholder="Cari pelanggan..." class="admin-input" />
            </x-admin.input-field>
            <div class="flex items-end justify-end gap-2">
                <a href="{{ route('admin.customers.index') }}" class="inline-flex items-center rounded-full border px-4 py-2 text-sm">Reset</a>
                <button type="submit" class="inline-flex items-center rounded-full bg-[#C26A3D] px-5 py-2 text-sm font-semibold text-white hover:bg-[#a85327]">Terapkan</button>
            </div>
        </form>
    </x-admin.card>

    <x-admin.card title="Daftar Pelanggan">
        <div class="mt-4 overflow-hidden rounded-2xl border border-[#FAD4C2]/60 dark:border-slate-800">
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-[#FAD4C2]/60 dark:divide-slate-800 text-sm">
                    <thead class="bg-[#FFF0E6] dark:bg-slate-800 text-left text-xs uppercase text-slate-500 dark:text-slate-400">
                        <tr>
                            <th class="px-4 py-3">Nama</th>
                            <th class="px-4 py-3">Email</th>
                            <th class="px-4 py-3 text-center">Pesanan</th>
                            <th class="px-4 py-3">Terakhir Login</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-[#FAD4C2]/40 dark:divide-slate-800 bg-white dark:bg-slate-900 text-slate-700 dark:text-slate-300">
                        @forelse ($customers as $c)
                            <tr class="transition hover:bg-[#FFF7F2] dark:hover:bg-slate-800">
                                <td class="px-4 py-4 font-semibold text-slate-800 dark:text-slate-100">{{ $c->name }}</td>
                                <td class="px-4 py-4">{{ $c->email }}</td>
                                <td class="px-4 py-4 text-center">{{ $c->orders_count }}</td>
                                <td class="px-4 py-4">{{ $c->last_login_at ? $c->last_login_at->diffForHumans() : '-' }}</td>
                            </tr>
                        @empty
                            <tr><td colspan="4" class="px-4 py-8 text-center text-slate-500">Belum ada pelanggan.</td></tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
        <div class="mt-4">{{ $customers->onEachSide(1)->links() }}</div>
    </x-admin.card>
</x-admin-layout>

