<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('categories', function (Blueprint $table) {
            if (!Schema::hasColumn('categories', 'tagline')) {
                $table->string('tagline')->nullable()->after('name');
            }
            if (!Schema::hasColumn('categories', 'hero_image_url')) {
                $table->string('hero_image_url')->nullable()->after('slug');
            }
            if (!Schema::hasColumn('categories', 'carousel_image_url')) {
                $table->string('carousel_image_url')->nullable()->after('hero_image_url');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('categories', function (Blueprint $table) {
            $table->dropColumn(['tagline', 'hero_image_url', 'carousel_image_url']);
        });
    }
};
