<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('activity_logs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->nullable()->constrained()->cascadeOnDelete();
            $table->string('method', 10);
            $table->string('route')->nullable();
            $table->string('path');
            $table->string('action')->default('request');
            $table->string('ip', 64)->nullable();
            $table->string('user_agent', 512)->nullable();
            $table->json('payload_keys')->nullable();
            $table->timestamps();
            $table->index(['route', 'method']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('activity_logs');
    }
};

