<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->string('role')->default('user')->after('email')->index();
            $table->string('phone')->nullable()->after('role');
            $table->string('whatsapp_number')->nullable()->after('phone');
            $table->string('avatar_url')->nullable()->after('whatsapp_number');
            $table->string('google_id')->nullable()->after('avatar_url')->unique();
            $table->string('google_token')->nullable()->after('google_id');
            $table->string('google_refresh_token')->nullable()->after('google_token');
            $table->timestamp('last_login_at')->nullable()->after('remember_token');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn([
                'role',
                'phone',
                'whatsapp_number',
                'avatar_url',
                'google_id',
                'google_token',
                'google_refresh_token',
                'last_login_at',
            ]);
        });
    }
};
