<?php

namespace Database\Factories;

use App\Models\Category;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Product>
 */
class ProductFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $name = $this->faker->words(3, true);

        return [
            'category_id' => Category::factory(),
            'sku' => strtoupper(Str::random(8)),
            'name' => ucwords($name),
            'slug' => Str::slug($name . '-' . $this->faker->unique()->randomNumber()),
            'tagline' => $this->faker->sentence(),
            'thumbnail' => null,
            'summary' => $this->faker->paragraph(),
            'description' => $this->faker->paragraphs(3, true),
            'stock' => $this->faker->numberBetween(10, 200),
            'min_order_qty' => 1,
            'max_order_qty' => $this->faker->numberBetween(5, 20),
            'weight_grams' => $this->faker->numberBetween(100, 1500),
            'price' => $this->faker->numberBetween(20000, 200000),
            'cost_price' => $this->faker->numberBetween(15000, 150000),
            'discount_percent' => $this->faker->randomElement([0, 5, 10, 15, 20]),
            'is_featured' => $this->faker->boolean(30),
            'status' => 'active',
            'metadata' => [
                'material' => $this->faker->word(),
                'variant' => $this->faker->colorName(),
            ],
        ];
    }
}
