<?php

namespace Database\Factories;

use App\Models\Order;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Payment>
 */
class PaymentFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'order_id' => Order::factory(),
            'amount' => $this->faker->numberBetween(50000, 500000),
            'method' => $this->faker->randomElement(['cash', 'bank_transfer', 'midtrans']),
            'gateway' => $this->faker->randomElement(['manual', 'midtrans']),
            'status' => $this->faker->randomElement(['pending', 'waiting_confirmation', 'paid']),
            'reference' => strtoupper($this->faker->bothify('PAY###??')),
            'virtual_account' => $this->faker->numerify('8888########'),
            'payment_url' => $this->faker->url(),
            'snap_token' => $this->faker->uuid(),
            'payload' => ['channel' => 'testing'],
            'paid_at' => $this->faker->boolean(60) ? now() : null,
            'notes' => $this->faker->sentence(),
        ];
    }
}
