<?php

namespace Database\Factories;

use App\Models\Order;
use App\Models\Product;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\OrderItem>
 */
class OrderItemFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $quantity = $this->faker->numberBetween(1, 5);
        $price = $this->faker->numberBetween(15000, 250000);

        return [
            'order_id' => Order::factory(),
            'product_id' => Product::factory(),
            'product_name' => $this->faker->words(3, true),
            'sku' => strtoupper($this->faker->bothify('SKU###??')),
            'quantity' => $quantity,
            'unit_price' => $price,
            'discount_percent' => $this->faker->randomElement([0, 5, 10, 15]),
            'subtotal' => $quantity * $price,
            'metadata' => [
                'variant' => $this->faker->colorName(),
            ],
        ];
    }
}
