<?php

namespace Database\Factories;

use App\Models\Cart;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Order>
 */
class OrderFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $subtotal = $this->faker->numberBetween(50000, 500000);
        $shipping = $this->faker->numberBetween(10000, 30000);
        $discount = $this->faker->numberBetween(0, 50000);
        $grandTotal = $subtotal - $discount + $shipping;

        return [
            'invoice_number' => 'DS-' . now()->format('Ymd') . '-' . strtoupper(Str::random(5)),
            'user_id' => User::factory(),
            'cashier_id' => null,
            'cart_id' => Cart::factory(),
            'channel' => $this->faker->randomElement(['online', 'offline']),
            'status' => $this->faker->randomElement(['pending', 'confirmed', 'processing', 'completed']),
            'payment_status' => $this->faker->randomElement(['unpaid', 'awaiting_confirmation', 'paid']),
            'payment_method' => $this->faker->randomElement(['midtrans', 'transfer', 'cash']),
            'payment_gateway' => $this->faker->randomElement(['midtrans', 'manual']),
            'payment_reference' => strtoupper(Str::random(10)),
            'payment_charge_party' => 'buyer',
            'total_items' => $this->faker->numberBetween(1, 6),
            'subtotal_amount' => $subtotal,
            'discount_amount' => $discount,
            'shipping_cost' => $shipping,
            'service_fee' => $this->faker->numberBetween(0, 10000),
            'grand_total' => $grandTotal,
            'shipping_address' => [
                'recipient_name' => $this->faker->name(),
                'phone' => $this->faker->phoneNumber(),
                'address_line1' => $this->faker->streetAddress(),
                'city' => $this->faker->city(),
                'province' => $this->faker->state(),
            ],
            'shipping_courier' => $this->faker->randomElement(['jne', 'jnt', 'anteraja']),
            'expedition_preference' => $this->faker->randomElement(['jne', 'jnt', 'anteraja']),
            'shipping_service' => $this->faker->randomElement(['REG', 'YES', 'ECO']),
            'tracking_number' => strtoupper(Str::random(12)),
            'notes' => $this->faker->sentence(),
            'payment_due_at' => now()->addDays(2),
            'paid_at' => $this->faker->boolean(60) ? now() : null,
            'fulfilled_at' => null,
            'metadata' => [
                'source' => $this->faker->randomElement(['website', 'pos']),
            ],
        ];
    }
}
