<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Third Party Services
    |--------------------------------------------------------------------------
    |
    | This file is for storing the credentials for third party services
    | such as Mailgun, Postmark, AWS and more. This file provides the
    | conventional location for packages to look for the various service
    | credentials.
    |
    */

    'postmark' => [
        'token' => env('POSTMARK_TOKEN'),
    ],

    'resend' => [
        'key' => env('RESEND_KEY'),
    ],

    'ses' => [
        'key' => env('AWS_ACCESS_KEY_ID'),
        'secret' => env('AWS_SECRET_ACCESS_KEY'),
        'region' => env('AWS_DEFAULT_REGION', 'us-east-1'),
    ],

    'google' => [
        'client_id' => env('GOOGLE_CLIENT_ID'),
        'client_secret' => env('GOOGLE_CLIENT_SECRET'),
        'redirect' => env('GOOGLE_REDIRECT_URI', env('APP_URL', 'http://localhost') . '/auth/google/callback'),
    ],

    'midtrans' => [
        'server_key' => env('MIDTRANS_SERVER_KEY'),
        'client_key' => env('MIDTRANS_CLIENT_KEY'),
        'is_production' => env('MIDTRANS_IS_PRODUCTION', false),
        'is_sanitized' => env('MIDTRANS_IS_SANITIZED', true),
        'is_3ds' => env('MIDTRANS_IS_3DS', true),
    ],

    'rajaongkir' => [
        'api_key' => env('RAJAONGKIR_API_KEY', ''),
        'account_type' => env('RAJAONGKIR_ACCOUNT_TYPE', 'starter'), // starter, basic, atau pro
        'origin_city_id' => env('RAJAONGKIR_ORIGIN_CITY_ID', '154'), // Default Jakarta Pusat
        'base_url' => env('RAJAONGKIR_BASE_URL'),
        'offline_cost' => env('RAJAONGKIR_OFFLINE_COST', false),
        'skip_ssl_verify' => env('RAJAONGKIR_SKIP_SSL_VERIFY', false),
    ],
    'shipper' => [
        'base_url' => env('SHIPPER_BASE_URL', ''),
        'access_token' => env('SHIPPER_ACCESS_TOKEN', ''),
        'client_id' => env('SHIPPER_CLIENT_ID', ''),
        'client_secret' => env('SHIPPER_CLIENT_SECRET', ''),
        'origin_area_id' => env('SHIPPER_ORIGIN_AREA_ID'),
        'origin_area_query' => env('SHIPPER_ORIGIN_AREA_QUERY', ''),
        'couriers' => array_filter(array_map('trim', explode(',', env('SHIPPER_COURIERS', '')))),
        'pricing_path' => env('SHIPPER_PRICING_PATH', '/v3/pricing/domestic'),
        'areas_path' => env('SHIPPER_AREAS_PATH', '/v3/locations/areas'),
    ],

    'whatsapp' => [
        'access_token' => env('WHATSAPP_ACCESS_TOKEN'),
        'phone_number_id' => env('WHATSAPP_PHONE_NUMBER_ID'),
    ],

    'slack' => [
        'notifications' => [
            'bot_user_oauth_token' => env('SLACK_BOT_USER_OAUTH_TOKEN'),
            'channel' => env('SLACK_BOT_USER_DEFAULT_CHANNEL'),
        ],
    ],

];

