<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        // Share cart count to all views
        view()->composer('*', function ($view) {
            $cartCount = 0;

            try {
                $request = request();
                $cartService = app(\App\Services\Cart\CartService::class);
                $cart = $cartService->resolve($request);

                if ($cart) {
                    $cartCount = $cart->items()->sum('quantity');
                }
            } catch (\Exception $e) {
                // If there's any error, default to 0
                $cartCount = 0;
            }

            $view->with('cartCount', $cartCount);
        });
    }
}
