<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ActivityLog extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'method',
        'route',
        'path',
        'action',
        'ip',
        'user_agent',
        'payload_keys',
    ];

    protected $casts = [
        'payload_keys' => 'array',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}

