<?php

namespace App\Http\Controllers;

use App\Models\Journal;
use Illuminate\Http\Request;

class JournalController extends Controller
{
    public function index(Request $request)
    {
        $query = Journal::published()->latest('published_at');

        if ($search = $request->query('search')) {
            $query->where(function ($builder) use ($search) {
                $builder->where('title', 'like', "%{$search}%")
                    ->orWhere('body', 'like', "%{$search}%")
                    ->orWhereJsonContains('tags', $search);
            });
        }

        $journals = $query->paginate(9)->withQueryString();

        return view('journals.index', [
            'journals' => $journals,
            'search' => $search,
        ]);
    }

    public function show(Journal $journal)
    {
        abort_if(is_null($journal->published_at), 404);

        $relatedPosts = Journal::published()
            ->where('id', '!=', $journal->id)
            ->latest('published_at')
            ->take(3)
            ->get();

        return view('journals.show', [
            'journal' => $journal,
            'relatedPosts' => $relatedPosts,
        ]);
    }
}
