<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Http\Requests\Auth\LoginRequest;
use App\Enums\UserRole;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\View\View;

class AdminLoginController extends Controller
{
    /**
     * Display the admin login view.
     */
    public function create(): View
    {
        return view('auth.admin-login');
    }

    /**
     * Handle an incoming authentication request for admin.
     */
    public function store(LoginRequest $request): RedirectResponse
    {
        $request->authenticate('admin');

        $user = Auth::guard('admin')->user();

        // Cek apakah user adalah admin
        if ($user->role !== UserRole::Admin) {
            Auth::guard('admin')->logout();
            return back()->withErrors([
                'email' => 'Anda tidak memiliki akses ke halaman admin.',
            ])->withInput($request->only('email'));
        }

        // Hapus semua intended URL SEBELUM regenerate session
        $request->session()->forget('url.intended');
        $request->session()->forget('_intended.url');

        $request->session()->regenerate();

        // Redirect ke dashboard admin setelah login
        return redirect()->route('admin.dashboard')->with('status', 'Login berhasil!');
    }
}
