<?php

namespace App\Http\Controllers\Admin;

use App\Enums\UserRole;
use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\View\View;

class AdminUserController extends Controller
{
    public function index(Request $request): View
    {
        $role = (string) $request->input('role', '');
        $search = (string) $request->input('search', '');

        $users = User::query()
            ->when($role, function ($q) use ($role) {
                $q->where('role', $role);
            })
            ->when($search, function ($q) use ($search) {
                $q->where(function ($qq) use ($search) {
                    $qq->where('name', 'like', "%{$search}%")
                        ->orWhere('email', 'like', "%{$search}%");
                });
            })
            ->latest('id')
            ->paginate(15)
            ->withQueryString();

        return view('admin.users.index', [
            'users' => $users,
            'search' => $search,
            'role' => $role,
            'roleOptions' => [UserRole::Admin->value => 'Admin', UserRole::Cashier->value => 'Kasir', UserRole::Customer->value => 'User'],
        ]);
    }

    public function updateRole(Request $request, User $user)
    {
        $data = $request->validate([
            'role' => ['required', 'in:admin,cashier,customer'],
        ]);

        $user->update(['role' => $data['role']]);

        return back()->with('status', 'Peran pengguna diperbarui.');
    }
}

