<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Product;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\View\View;

class AdminDiscountController extends Controller
{
    public function index(): View
    {
        $products = Product::query()->select('id', 'name', 'sku', 'price', 'discount_percent', 'stock')
            ->orderByDesc('discount_percent')
            ->paginate(15);

        return view('admin.discounts.index', [
            'products' => $products,
        ]);
    }

    public function update(Request $request, Product $product): RedirectResponse
    {
        $data = $request->validate([
            'discount_percent' => 'nullable|numeric|min:0|max:90',
        ]);

        $product->update([
            'discount_percent' => $data['discount_percent'] ?? 0,
        ]);

        return back()->with('success', 'Diskon diperbarui');
    }
}
