# 🔧 SETUP RAJAONGKIR UNTUK KABUPATEN TANGERANG

## ⚠️ MASALAH SAAT INI:
RajaOngkir API belum dikonfigurasi, sehingga pencarian kota tidak berfungsi.

---

## ✅ SOLUSI 1: Setup RajaOngkir API (RECOMMENDED)

### **Langkah 1: Dapatkan API Key**

1. Kunjungi: **https://rajaongkir.com**
2. Klik **"Daftar"** atau **"Register"**
3. Pilih paket **"Starter"** (GRATIS)
4. Isi form pendaftaran
5. Aktivasi akun via email
6. Login dan copy **API Key** Anda

---

### **Langkah 2: Tambahkan ke File .env**

Buka file `.env` di root project (`C:\xampp\htdocs\web\dshop\.env`)

Tambahkan baris berikut:

```env
# ============================================
# RAJAONGKIR CONFIGURATION
# ============================================

RAJAONGKIR_API_KEY=paste_api_key_anda_disini
RAJAONGKIR_ACCOUNT_TYPE=starter
RAJAONGKIR_ORIGIN_CITY_ID=455
```

**CONTOH:**
```env
RAJAONGKIR_API_KEY=abc123def456ghi789jkl012
RAJAONGKIR_ACCOUNT_TYPE=starter
RAJAONGKIR_ORIGIN_CITY_ID=455
```

> **Note:** ID 455 adalah untuk Kabupaten Tangerang. Jika berbeda, akan kita update nanti.

---

### **Langkah 3: Clear Cache**

Jalankan di terminal:

```bash
cd C:\xampp\htdocs\web\dshop
php artisan config:clear
php artisan cache:clear
```

---

### **Langkah 4: Test RajaOngkir**

```bash
php test-rajaongkir.php
```

**Output yang diharapkan:**
```
✅ PASSED: API Key configured
✅ PASSED: Service is configured
✅ PASSED: Retrieved 34 provinces
✅ PASSED: Retrieved 501 cities
✅ 'tangerang': Found 3 result(s)
```

---

### **Langkah 5: Cari ID Kota Tangerang yang Tepat**

Jalankan di terminal:

```bash
php artisan tinker
```

Lalu ketik:

```php
$service = app(App\Services\Shipping\RajaOngkirService::class);
$results = $service->searchCity('tangerang');
foreach($results as $city) {
    echo "{$city['type']} {$city['city_name']} (Provinsi: {$city['province']}) - ID: {$city['city_id']}\n";
}
```

**Output akan seperti:**
```
Kabupaten Tangerang (Provinsi: Banten) - ID: 455
Kota Tangerang (Provinsi: Banten) - ID: 456
Kota Tangerang Selatan (Provinsi: Banten) - ID: 457
```

Pilih ID yang sesuai dengan lokasi toko Anda:
- **455** = Kabupaten Tangerang
- **456** = Kota Tangerang
- **457** = Kota Tangerang Selatan

Update di `.env`:
```env
RAJAONGKIR_ORIGIN_CITY_ID=455
```

Lalu:
```bash
php artisan config:clear
```

---

### **Langkah 6: Test di Browser**

1. Refresh halaman checkout
2. Ketik **"tangerang"** di field kota
3. Harus muncul hasil:
   ```
   📍 Kabupaten Tangerang
      Banten
   📍 Kota Tangerang
      Banten
   📍 Kota Tangerang Selatan
      Banten
   ```

---

## ✅ SOLUSI 2: Pakai Mode Manual (TEMPORARY - Tanpa RajaOngkir)

Jika Anda tidak ingin setup RajaOngkir sekarang, sistem sudah punya **fallback mode**.

### **Cara Menggunakan:**

1. Refresh halaman checkout
2. Sistem akan otomatis detect RajaOngkir tidak aktif
3. Field kota akan berubah jadi **input text biasa**
4. Ketik manual: **"Kabupaten Tangerang"**
5. Ketik manual provinsi: **"Banten"**

Banner akan muncul:
```
⚠️ Estimasi Ongkir Manual
Biaya dan ekspedisi akan dikonfirmasi oleh admin
setelah pesanan dibuat.
```

**Kelebihan:**
- ✓ Bisa checkout langsung tanpa setup API
- ✓ Admin konfirmasi ongkir via WhatsApp nanti

**Kekurangan:**
- ❌ Tidak bisa cek ongkir otomatis
- ❌ Customer tidak tahu ongkir saat checkout
- ❌ Admin harus manual hitung & konfirmasi

---

## 🎯 REKOMENDASI:

### **Gunakan SOLUSI 1** (Setup RajaOngkir)

**Kenapa?**
- ✅ Customer bisa cek ongkir real-time
- ✅ Pilih kurir sendiri (JNE/POS/TIKI)
- ✅ Tidak perlu konfirmasi manual
- ✅ Lebih profesional
- ✅ Gratis untuk Starter plan

**Setup hanya 10 menit!**

---

## 🔍 INFORMASI TAMBAHAN: Kota Tangerang di RajaOngkir

Ada **3 pilihan** untuk Tangerang:

| Nama | Type | City ID | Keterangan |
|------|------|---------|------------|
| Tangerang | Kabupaten | **455** | Wilayah Kab. Tangerang (termasuk Balaraja, Cikupa, Serpong lama, dll) |
| Tangerang | Kota | **456** | Wilayah Kota Tangerang (termasuk Ciledug, Karawaci, dll) |
| Tangerang Selatan | Kota | **457** | Wilayah Kota Tangsel (BSD, Pondok Aren, Pamulang, dll) |

**Pastikan pilih yang sesuai lokasi toko Anda!**

---

## 📞 Butuh Bantuan?

**Jika ada masalah saat setup:**

1. **Cek logs:** `storage/logs/laravel.log`
2. **Test API:** `php test-rajaongkir.php`
3. **Clear cache:** `php artisan cache:clear && php artisan config:clear`
4. **Cek .env:** Pastikan tidak ada spasi atau karakter aneh di API key

---

## ⚡ Quick Start (5 Menit)

```bash
# 1. Daftar di https://rajaongkir.com (dapat API key)

# 2. Edit file .env, tambahkan:
RAJAONGKIR_API_KEY=your_actual_api_key_here
RAJAONGKIR_ACCOUNT_TYPE=starter
RAJAONGKIR_ORIGIN_CITY_ID=455

# 3. Clear cache
php artisan config:clear && php artisan cache:clear

# 4. Test
php test-rajaongkir.php

# 5. Refresh browser & coba ketik "tangerang"
```

**Selesai! 🎉**

---

*Last Updated: November 8, 2025*

