<?php
    $companyName = 'Dimas Cahya Ramadhan';

    $initials = 'MY';
    $parts    = preg_split('/\s+/', trim($companyName));
    if (is_array($parts) && count($parts) > 0) {
        $initials = strtoupper(substr($parts[0], 0, 1) . substr(end($parts), 0, 1));
    }

    $uri       = service('uri');
    $current   = trim($uri->getPath(), '/');
    $isActive  = static function (array $targets) use ($current): bool {
        foreach ($targets as $target) {
            if ($target === '' && $current === '') {
                return true;
            }

            if ($target !== '' && strpos($current, $target) === 0) {
                return true;
            }
        }

        return false;
    };
?>
<nav class="navbar navbar-expand-lg navbar-dark app-navbar">
    <div class="container">
        <a class="navbar-brand d-flex align-items-center" href="<?= base_url() ?>">
            <span class="brand-initials brand-mark"><?= esc($initials) ?></span>
            <span><?= esc($companyName) ?></span>
        </a>
        <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse justify-content-end" id="navbarNav">
            <ul class="navbar-nav align-items-lg-center gap-lg-1">
                <li class="nav-item">
                    <a class="nav-link <?= $isActive(['']) ? 'active' : '' ?>" href="<?= base_url() ?>">Beranda</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?= $isActive(['cv', 'biodata']) ? 'active' : '' ?>" href="<?= base_url('cv') ?>">Biodata</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?= $isActive(['pendidikan']) ? 'active' : '' ?>" href="<?= base_url('pendidikan') ?>">Pendidikan</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?= $isActive(['aktivitas']) ? 'active' : '' ?>" href="<?= base_url('aktivitas') ?>">Aktivitas</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?= $isActive(['login']) ? 'active' : '' ?>" href="<?= base_url('login') ?>">Login</a>
                </li>
            </ul>
        </div>
    </div>
</nav>
