<?php
    $uri       = service('uri');
    $current   = trim($uri->getPath(), '/');
    $isActive  = static function (array $targets) use ($current): bool {
        foreach ($targets as $target) {
            if ($target !== '' && strpos($current, $target) === 0) {
                return true;
            }
        }
        return false;
    };

    $logoAsset   = null; // tidak memakai logo gambar
    $companyName = 'Dimas Cahya Ramadhan';
    $initials    = 'DC';
?>
<aside class="admin-sidebar" id="adminSidebar">
    <div class="admin-sidebar__header">
        <a class="admin-sidebar__brand" href="<?= base_url('admin/dashboard') ?>">
            <div class="admin-sidebar__logo">
                <span class="admin-sidebar__initials"><?= esc($initials) ?></span>
            </div>
            <div class="admin-sidebar__brand-text">
                <div class="admin-sidebar__brand-title">Admin Panel</div>
                <div class="admin-sidebar__brand-subtitle"><?= esc($companyName) ?></div>
            </div>
        </a>
        <button class="admin-sidebar__toggle d-lg-none" type="button" aria-label="Toggle sidebar" id="sidebarToggle">
            <span></span>
            <span></span>
            <span></span>
        </button>
    </div>

    <nav class="admin-sidebar__nav">
        <ul class="admin-sidebar__menu">
            <li class="admin-sidebar__item">
                <a class="admin-sidebar__link <?= $isActive(['admin/dashboard', 'admin']) ? 'active' : '' ?>" href="<?= base_url('admin/dashboard') ?>">
                    <span class="admin-sidebar__icon">DB</span>
                    <span class="admin-sidebar__text">Dashboard</span>
                </a>
            </li>
            <li class="admin-sidebar__item">
                <a class="admin-sidebar__link <?= $isActive(['admin/aktivitas']) ? 'active' : '' ?>" href="<?= base_url('admin/aktivitas') ?>">
                    <span class="admin-sidebar__icon">AK</span>
                    <span class="admin-sidebar__text">Aktivitas</span>
                    <?php if ($isActive(['admin/aktivitas'])): ?>
                        <span class="admin-sidebar__badge">Aktif</span>
                    <?php endif; ?>
                </a>
            </li>
            <li class="admin-sidebar__item">
                <a class="admin-sidebar__link <?= $isActive(['admin/biodata']) ? 'active' : '' ?>" href="<?= base_url('admin/biodata') ?>">
                    <span class="admin-sidebar__icon">BD</span>
                    <span class="admin-sidebar__text">Biodata</span>
                    <?php if ($isActive(['admin/biodata'])): ?>
                        <span class="admin-sidebar__badge">Aktif</span>
                    <?php endif; ?>
                </a>
            </li>
            <li class="admin-sidebar__item">
                <a class="admin-sidebar__link <?= $isActive(['admin/pendidikan']) ? 'active' : '' ?>" href="<?= base_url('admin/pendidikan') ?>">
                    <span class="admin-sidebar__icon">PD</span>
                    <span class="admin-sidebar__text">Pendidikan</span>
                    <?php if ($isActive(['admin/pendidikan'])): ?>
                        <span class="admin-sidebar__badge">Aktif</span>
                    <?php endif; ?>
                </a>
            </li>
        </ul>

    </nav>

    <div class="admin-sidebar__footer">
        <a class="admin-sidebar__link admin-sidebar__link--danger" href="<?= base_url('logout') ?>">
            <span class="admin-sidebar__icon admin-sidebar__icon--text">dimas cahya ramadhan</span>
            <span class="admin-sidebar__text">Keluar</span>
        </a>
    </div>
</aside>

<div class="admin-sidebar__overlay" id="sidebarOverlay"></div>
