<?= $this->extend('layout/page_layout') ?>

<?= $this->section('content') ?>
<?php
    $filters = isset($filters) && is_array($filters) ? $filters : [];
    $filters = array_merge([
        'search'     => '',
        'degree'     => 'semua',
        'start_year' => '',
        'end_year'   => '',
        'sort'       => 'start_desc',
    ], $filters);
    $degreeOptions = $degreeOptions ?? [];
?>

<div class="container app-container py-4">
    <div class="row g-4">
        <div class="col-12">
            <div class="d-flex flex-column flex-lg-row align-items-lg-center justify-content-between" style="gap: 1rem;">
                <div>
                    <p class="home-meta mb-1 text-uppercase">Riwayat Pendidikan</p>
                    <h1 class="mb-0">Data Riwayat Pendidikan</h1>
                    <p class="text-muted mb-0">Urutkan dan telusuri jenjang pendidikan dari SD hingga perguruan tinggi.</p>
                </div>
                <a href="<?= base_url('admin/pendidikan') ?>" class="btn btn-primary">Kelola di Admin</a>
            </div>
        </div>

        <div class="col-12">
            <div class="card-surface p-3 p-md-4 shadow-sm">
                <form class="row g-3 align-items-end js-loading-form">
                    <div class="col-12 col-lg-4">
                        <label for="searchEdu" class="form-label">Pencarian</label>
                        <input
                            type="search"
                            name="q"
                            id="searchEdu"
                            class="form-control"
                            placeholder="Cari institusi atau jurusan"
                            value="<?= esc($filters['search']) ?>">
                    </div>
                    <div class="col-6 col-lg-2">
                        <label for="degreeFilter" class="form-label">Jenjang</label>
                        <select class="custom-select" name="degree" id="degreeFilter">
                            <option value="semua" <?= $filters['degree'] === 'semua' ? 'selected' : '' ?>>Semua</option>
                            <?php foreach ($degreeOptions as $option): ?>
                                <option value="<?= esc($option) ?>" <?= $filters['degree'] === $option ? 'selected' : '' ?>>
                                    <?= esc($option) ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="col-6 col-lg-2">
                        <label for="startYear" class="form-label">Mulai &ge;</label>
                        <input
                            type="number"
                            name="start_year"
                            id="startYear"
                            class="form-control"
                            min="1950"
                            max="2100"
                            value="<?= esc($filters['start_year']) ?>">
                    </div>
                    <div class="col-6 col-lg-2">
                        <label for="endYear" class="form-label">Selesai &le;</label>
                        <input
                            type="number"
                            name="end_year"
                            id="endYear"
                            class="form-control"
                            min="1950"
                            max="2100"
                            value="<?= esc($filters['end_year']) ?>">
                    </div>
                    <div class="col-6 col-lg-1">
                        <label for="sortEdu" class="form-label">Urutkan</label>
                        <select class="custom-select" name="sort" id="sortEdu">
                            <option value="start_desc" <?= $filters['sort'] === 'start_desc' ? 'selected' : '' ?>>Tahun terbaru</option>
                            <option value="start_asc" <?= $filters['sort'] === 'start_asc' ? 'selected' : '' ?>>Tahun terlama</option>
                            <option value="degree" <?= $filters['sort'] === 'degree' ? 'selected' : '' ?>>Urut jenjang</option>
                        </select>
                    </div>
                    <div class="col-6 col-lg-1">
                        <button type="submit" class="btn btn-primary btn-block">Terapkan</button>
                    </div>
                    <div class="col-6 col-lg-1">
                        <a href="<?= base_url('pendidikan') ?>" class="btn btn-outline-secondary btn-block">Reset</a>
                    </div>
                </form>
            </div>
        </div>

        <div class="col-12">

<div class="col-12">
    <div class="page-loading-shell">
        <div class="page-loading-shell__skeleton" aria-hidden="true">
            <div class="timeline">
                <?php for ($i = 0; $i < 3; $i++): ?>
                    <div class="timeline-item card mb-3 shadow-sm border-0">
                        <div class="card-body">
                            <div class="d-flex align-items-center justify-content-between flex-wrap" style="gap: .5rem;">
                                <div class="d-flex align-items-center gap-2">
                                    <div class="skeleton skeleton-pill" style="width: 90px;"></div>
                                    <div class="skeleton skeleton-pill" style="width: 70px;"></div>
                                </div>
                                <div class="skeleton skeleton-pill" style="width: 80px;"></div>
                            </div>
                            <div class="skeleton-line skeleton-lg" style="width: 60%; margin-top: 12px;"></div>
                            <div class="skeleton-line" style="width: 80%;"></div>
                        </div>
                    </div>
                <?php endfor; ?>
            </div>
        </div>
        <div class="page-loading-shell__content" data-loading-links>
            <?php if (empty($records)): ?>
                <div class="empty-state">Belum ada riwayat pendidikan.</div>
            <?php else: ?>
                <div class="timeline">
                    <?php foreach ($records as $record): ?>
                        <?php
                            $start = $record['start_year'] ?? '';
                            $end   = $record['end_year'] ?? '';
                            $period = $start ? $start . ' - ' . ($end ?: 'Sekarang') : '-';
                        ?>
                        <div class="timeline-item card mb-3 shadow-sm border-0">
                            <div class="card-body">
                                <div class="d-flex align-items-center justify-content-between flex-wrap" style="gap: .5rem;">
                                    <div>
                                        <span class="badge badge-primary mr-2"><?= esc($record['degree'] ?? '-') ?></span>
                                        <span class="text-muted small"><?= esc($period) ?></span>
                                    </div>
                                    <?php if (! empty($record['city'])): ?>
                                        <span class="badge badge-light text-muted border"><?= esc($record['city']) ?></span>
                                    <?php endif; ?>
                                </div>
                                <h3 class="h5 mt-2 mb-1"><?= esc($record['institution'] ?? '-') ?></h3>
                                <?php if (! empty($record['field_of_study'])): ?>
                                    <div class="text-muted mb-2"><?= esc($record['field_of_study']) ?></div>
                                <?php endif; ?>
                                <?php if (! empty($record['description'])): ?>
                                    <p class="mb-0 text-muted"><?= esc($record['description']) ?></p>
                                <?php endif; ?>
                            </div>
                            <div class="card-footer bg-white d-flex justify-content-between align-items-center">
                                <span class="small text-muted">Dibuat: <?= esc(isset($record['created_at']) ? date('d M Y', strtotime($record['created_at'])) : '-') ?></span>
                                <a href="<?= base_url('admin/pendidikan/' . ($record['id'] ?? 0) . '/edit') ?>" class="btn btn-link p-0">Detail</a>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
                <div class="mt-3">
                    <?= $pager->links('education', 'default_full') ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<?= $this->endSection() ?>
