<?= $this->extend('layout/admin/admin_layout') ?>

<?= $this->section('content') ?>
<?php
    $this->setVar('pageTitle', 'Manajemen Perusahaan');
?>

<?php if ($message = session()->getFlashdata('message')): ?>
    <div class="alert alert-success alert-dismissible fade show mb-4" role="alert">
        <strong>Berhasil!</strong> <?= esc($message) ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Tutup"></button>
    </div>
<?php endif; ?>

<div class="admin-card mb-4">
    <div class="admin-card__header">
        <div>
            <h2 class="admin-card__title mb-1">Daftar Pegawai</h2>
            <p class="text-muted mb-0 small">Kelola data pegawai beserta foto profilnya.</p>
        </div>
        <a class="btn btn-admin btn-admin-primary" href="<?= base_url('admin/perusahaan/new') ?>">
            <span aria-hidden="true">+</span>
            <span>Tambah Pegawai</span>
        </a>
    </div>

    <div class="admin-card__body">
        <?php
            $divisiLabels = [
                'Direktur Utama' => 'Direktur Utama',
                'IT'             => 'IT (Information Technology)',
                'Produksi'       => 'Produksi',
                'Marketing'      => 'Marketing',
                'HR'             => 'HR (Human Resource)',
            ];

            $filters = isset($filters) && is_array($filters) ? $filters : [];
            $filters = array_merge([
                'search'        => '',
                'divisi'        => 'semua',
                'jenis_kelamin' => 'semua',
            ], $filters);
        ?>

        <form class="row g-3 align-items-end mb-4" method="get" action="<?= base_url('admin/perusahaan') ?>">
            <div class="col-12 col-lg-4">
                <label for="filterSearch" class="form-label">Cari Pegawai</label>
                <div class="input-group">
                    <span class="input-group-text bg-white border-end-0"><span class="text-muted" aria-hidden="true">🔍</span></span>
                    <input
                        type="search"
                        name="q"
                        id="filterSearch"
                        class="form-control border-start-0"
                        placeholder="Cari nama pegawai"
                        value="<?= esc($filters['search']) ?>">
                </div>
            </div>
            <div class="col-6 col-lg-3">
                <label for="filterDivisi" class="form-label">Divisi</label>
                <select class="form-select" name="divisi" id="filterDivisi">
                    <option value="semua" <?= $filters['divisi'] === 'semua' ? 'selected' : '' ?>>Semua Divisi</option>
                    <?php foreach ($divisiLabels as $value => $label): ?>
                        <option value="<?= esc($value) ?>" <?= $filters['divisi'] === $value ? 'selected' : '' ?>>
                            <?= esc($label) ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="col-6 col-lg-3">
                <label for="filterGender" class="form-label">Jenis Kelamin</label>
                <select class="form-select" name="jenis_kelamin" id="filterGender">
                    <option value="semua" <?= $filters['jenis_kelamin'] === 'semua' ? 'selected' : '' ?>>Semua Jenis Kelamin</option>
                    <option value="laki-laki" <?= $filters['jenis_kelamin'] === 'laki-laki' ? 'selected' : '' ?>>Laki-laki</option>
                    <option value="perempuan" <?= $filters['jenis_kelamin'] === 'perempuan' ? 'selected' : '' ?>>Perempuan</option>
                </select>
            </div>
            <div class="col-12 col-lg-2 d-flex gap-2">
                <button type="submit" class="btn btn-admin btn-admin-primary w-100">Terapkan</button>
                <a href="<?= base_url('admin/perusahaan') ?>" class="btn btn-admin btn-admin-outline w-100">Reset</a>
            </div>
        </form>

        <?php if (empty($pegawai)): ?>
            <div class="admin-empty">
                <div class="admin-empty__icon" aria-hidden="true">👥</div>
                <div class="admin-empty__title">Belum ada data pegawai</div>
                <div class="admin-empty__text">Tambahkan data pegawai pertama Anda untuk memulai.</div>
            </div>
        <?php else: ?>
            <div class="table-responsive">
                <table class="admin-table">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Foto</th>
                            <th>Nama Pegawai</th>
                            <th>Tanggal Lahir</th>
                            <th>Divisi</th>
                            <th>Jenis Kelamin</th>
                            <th class="text-end">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($pegawai as $row): ?>
                            <?php $previewUrl = base_url('admin/perusahaan/'.$row['id_pegawai'].'/preview'); ?>
                            <?php $photoUrl   = base_url('admin/perusahaan/'.$row['id_pegawai'].'/photo'); ?>
                            <tr>
                                <td class="fw-semibold"><?= esc($row['id_pegawai']) ?></td>
                                <td>
                                    <?php if (! empty($row['foto_pegawai'])): ?>
                                        <a href="<?= $photoUrl ?>" class="d-inline-block" title="Lihat foto pegawai">
                                            <img
                                                src="<?= base_url($row['foto_pegawai']) ?>"
                                                alt="Foto <?= esc($row['nama_pegawai']) ?>"
                                                class="rounded"
                                                style="width: 56px; height: 56px; object-fit: cover; border: 2px solid var(--admin-border);">
                                        </a>
                                    <?php else: ?>
                                        <?php
                                            $name = (string) ($row['nama_pegawai'] ?? '');
                                            $initials = '';
                                            foreach (preg_split('/\s+/', trim($name)) as $part) {
                                                if ($part === '') {
                                                    continue;
                                                }
                                                $initials .= strtoupper(substr($part, 0, 1));
                                                if (strlen($initials) >= 2) {
                                                    break;
                                                }
                                            }
                                            if ($initials === '') {
                                                $initials = 'NF';
                                            }
                                        ?>
                                        <div class="d-inline-flex align-items-center justify-content-center rounded-circle"
                                             style="width: 56px; height: 56px; font-size: 16px; background: linear-gradient(135deg, #e0f2fe, #dbeafe); color: #1d4ed8; border: 1px solid #e2e8f0; box-shadow: 0 6px 14px rgba(0,0,0,0.06);"
                                             title="Belum ada foto">
                                            <span class="fw-semibold"><?= esc($initials) ?></span>
                                        </div>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <div class="fw-semibold text-dark mb-1"><?= esc($row['nama_pegawai']) ?></div>
                                    <div class="text-muted small">
                                        <?php
                                            $createdAt = $row['created_at'] ?? null;
                                            if ($createdAt) {
                                                echo esc(date('d M Y', strtotime($createdAt)));
                                            } else {
                                                echo '-';
                                            }
                                        ?>
                                    </div>
                                </td>
                                <td>
                                    <?php
                                        $tanggalLahir = $row['tanggal_lahir'] ?? null;
                                        if ($tanggalLahir) {
                                            echo esc(date('d M Y', strtotime($tanggalLahir)));
                                        } else {
                                            echo '-';
                                        }
                                    ?>
                                </td>
                                <td>
                                    <span class="admin-badge admin-badge--primary">
                                        <?= esc($divisiLabels[$row['divisi'] ?? ''] ?? ($row['divisi'] ?? '-')) ?>
                                    </span>
                                </td>
                                <td>
                                    <?php
                                        $gender = strtolower($row['jenis_kelamin'] ?? '');
                                        $badgeClass = $gender === 'laki-laki' ? 'admin-badge--primary' : 'admin-badge--secondary';
                                    ?>
                                    <span class="admin-badge <?= $badgeClass ?> text-uppercase">
                                        <?= esc($row['jenis_kelamin']) ?>
                                    </span>
                                </td>
                                <td class="text-end">
                                    <div class="d-flex gap-2 justify-content-end">
                                        <a href="<?= $previewUrl ?>" class="btn btn-sm btn-admin btn-admin-primary" target="_blank">
                                            Preview
                                        </a>
                                        <a href="<?= base_url('admin/perusahaan/'.$row['id_pegawai'].'/edit') ?>" class="btn btn-sm btn-admin btn-admin-outline">
                                            Edit
                                        </a>
                                        <form action="<?= base_url('admin/perusahaan/'.$row['id_pegawai'].'/delete') ?>" method="post" class="d-inline" onsubmit="return confirm('Hapus data pegawai ini secara permanen?');">
                                            <?= csrf_field() ?>
                                            <button type="submit" class="btn btn-sm btn-admin btn-admin-danger">Hapus</button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
    </div>
</div>

<?= $this->endSection() ?>
