<?= $this->extend('layout/admin/admin_layout') ?>

<?= $this->section('content') ?>
<?php
    $this->setVar('pageTitle', 'Biodata & CV');
    $filters = isset($filters) && is_array($filters) ? $filters : [];
    $filters = array_merge([
        'search'   => '',
        'headline' => 'semua',
        'sort'     => 'newest',
    ], $filters);
    $headlineOptions = $headlineOptions ?? [];
?>

<?php if ($message = session()->getFlashdata('message')): ?>
    <div class="alert alert-success alert-dismissible fade show mb-4" role="alert">
        <?= esc($message) ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Tutup"></button>
    </div>
<?php endif; ?>

<div class="admin-card mb-4">
    <div class="admin-card__header">
        <div>
            <h2 class="admin-card__title mb-1">Biodata / CV</h2>
            <p class="text-muted mb-0 small">Kelola data biodata atau CV lengkap dengan kontak dan skill.</p>
        </div>
        <a class="btn btn-admin btn-admin-primary" href="<?= base_url('admin/biodata/new') ?>">
            <span aria-hidden="true">+</span>
            <span>Tambah Biodata</span>
        </a>
    </div>

    <div class="admin-card__body">
        <form class="row g-3 align-items-end mb-4" method="get" action="<?= base_url('admin/biodata') ?>">
            <div class="col-12 col-lg-5">
                <label for="filterSearchBiodata" class="form-label">Pencarian</label>
                <div class="input-group">
                    <span class="input-group-text bg-white border-end-0"><span aria-hidden="true">🔍</span></span>
                    <input
                        type="search"
                        name="q"
                        id="filterSearchBiodata"
                        class="form-control border-start-0"
                        placeholder="Cari nama, skill, atau headline"
                        value="<?= esc($filters['search']) ?>">
                </div>
            </div>
            <div class="col-6 col-lg-3">
                <label for="filterHeadline" class="form-label">Headline</label>
                <select class="form-select" name="headline" id="filterHeadline">
                    <option value="semua" <?= $filters['headline'] === 'semua' ? 'selected' : '' ?>>Semua Headline</option>
                    <?php foreach ($headlineOptions as $headline): ?>
                        <option value="<?= esc($headline) ?>" <?= $filters['headline'] === $headline ? 'selected' : '' ?>>
                            <?= esc($headline) ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="col-6 col-lg-2">
                <label for="filterSortBiodata" class="form-label">Urutkan</label>
                <select class="form-select" name="sort" id="filterSortBiodata">
                    <option value="newest" <?= $filters['sort'] === 'newest' ? 'selected' : '' ?>>Terbaru</option>
                    <option value="name_asc" <?= $filters['sort'] === 'name_asc' ? 'selected' : '' ?>>Nama A-Z</option>
                    <option value="name_desc" <?= $filters['sort'] === 'name_desc' ? 'selected' : '' ?>>Nama Z-A</option>
                </select>
            </div>
            <div class="col-6 col-lg-1">
                <button type="submit" class="btn btn-admin btn-admin-primary w-100">Terapkan</button>
            </div>
            <div class="col-6 col-lg-1">
                <a href="<?= base_url('admin/biodata') ?>" class="btn btn-admin btn-admin-outline w-100">Reset</a>
            </div>
        </form>

        <?php if (empty($profiles)): ?>
            <div class="admin-empty">
                <div class="admin-empty__icon" aria-hidden="true">👤</div>
                <div class="admin-empty__title">Belum ada biodata</div>
                <div class="admin-empty__text">Tambahkan biodata pertama untuk memulai.</div>
            </div>
        <?php else: ?>
            <div class="table-responsive">
                <table class="admin-table">
                    <thead>
                        <tr>
                            <th>Foto</th>
                            <th>Nama</th>
                            <th>Headline</th>
                            <th>Kontak</th>
                            <th>Skills</th>
                            <th class="text-end">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($profiles as $profile): ?>
                            <?php
                                $skills = array_filter(array_map('trim', explode(',', (string) ($profile['skills'] ?? ''))));
                            ?>
                            <tr>
                                <td>
                                    <?php if (! empty($profile['photo_path'])): ?>
                                        <img src="<?= esc(base_url($profile['photo_path'])) ?>" alt="<?= esc($profile['full_name'] ?? 'Foto') ?>" style="width: 48px; height: 48px; object-fit: cover;" class="rounded-circle">
                                    <?php else: ?>
                                        <div class="d-inline-flex align-items-center justify-content-center rounded-circle bg-light text-muted" style="width: 48px; height: 48px;">
                                            <?= esc(substr((string) ($profile['full_name'] ?? 'NF'), 0, 2)) ?>
                                        </div>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <div class="fw-semibold text-dark"><?= esc($profile['full_name'] ?? '-') ?></div>
                                    <div class="text-muted small"><?= esc(isset($profile['updated_at']) ? date('d M Y', strtotime($profile['updated_at'])) : '-') ?></div>
                                </td>
                                <td><?= esc($profile['headline'] ?? '-') ?></td>
                                <td class="small">
                                    <?php if (! empty($profile['email'])): ?>
                                        <div>Email: <?= esc($profile['email']) ?></div>
                                    <?php endif; ?>
                                    <?php if (! empty($profile['phone'])): ?>
                                        <div>Telp: <?= esc($profile['phone']) ?></div>
                                    <?php endif; ?>
                                    <?php if (! empty($profile['address'])): ?>
                                        <div><?= esc($profile['address']) ?></div>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <div class="d-flex flex-wrap gap-1">
                                        <?php foreach ($skills as $skill): ?>
                                            <span class="admin-badge admin-badge--secondary"><?= esc($skill) ?></span>
                                        <?php endforeach; ?>
                                    </div>
                                </td>
                                <td class="text-end">
                                    <div class="d-flex justify-content-end gap-2">
                                        <a href="<?= base_url('admin/biodata/' . $profile['id'] . '/edit') ?>" class="btn btn-sm btn-admin btn-admin-outline">Edit</a>
                                        <form action="<?= base_url('admin/biodata/' . $profile['id'] . '/delete') ?>" method="post" class="d-inline" onsubmit="return confirm('Hapus biodata ini secara permanen?');">
                                            <?= csrf_field() ?>
                                            <button type="submit" class="btn btn-sm btn-admin btn-admin-danger">Hapus</button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
            <div class="d-flex justify-content-between align-items-center mt-3 flex-wrap" style="gap: .75rem;">
                <div class="text-muted small">Pagination 10 data per halaman.</div>
                <?= $pager->links('biodata', 'default_full') ?>
            </div>
        <?php endif; ?>
    </div>
</div>

<?= $this->endSection() ?>
