<?= $this->extend('layout/admin/admin_layout') ?>

<?= $this->section('content') ?>
<?php
    $mode       = $mode ?? 'create';
    $isEdit     = $mode === 'edit';
    $this->setVar('pageTitle', $isEdit ? 'Edit Aktivitas' : 'Tambah Aktivitas');
    $activity   = $activity ?? [];
    $validation = $validation ?? null;
    $oldInput   = $oldInput ?? [];
    $data       = array_merge($activity, $oldInput);
?>

<div class="admin-card">
    <div class="admin-card__header">
        <div>
            <h2 class="admin-card__title mb-1"><?= $isEdit ? 'Edit Aktivitas' : 'Tambah Aktivitas' ?></h2>
            <p class="text-muted mb-0 small">Catat tanggal, jam, lokasi, dan dokumentasi aktivitas harian.</p>
        </div>
        <a href="<?= base_url('admin/aktivitas') ?>" class="btn btn-admin btn-admin-outline">
            ← Kembali
        </a>
    </div>
    <div class="admin-card__body">
        <form action="" method="post" enctype="multipart/form-data" class="needs-validation" novalidate>
            <?= csrf_field() ?>

            <div class="mb-3">
                <label for="title" class="form-label">Judul Aktivitas</label>
                <input
                    type="text"
                    name="title"
                    id="title"
                    class="form-control <?= $validation && $validation->hasError('title') ? 'is-invalid' : '' ?>"
                    value="<?= esc($data['title'] ?? '') ?>"
                    required>
                <?php if ($validation && $validation->hasError('title')): ?>
                    <div class="invalid-feedback"><?= esc($validation->getError('title')) ?></div>
                <?php endif; ?>
            </div>

            <div class="row g-3">
                <div class="col-md-4">
                    <label for="activity_date" class="form-label">Tanggal</label>
                    <input
                        type="date"
                        name="activity_date"
                        id="activity_date"
                        class="form-control <?= $validation && $validation->hasError('activity_date') ? 'is-invalid' : '' ?>"
                        value="<?= esc($data['activity_date'] ?? '') ?>"
                        required>
                    <?php if ($validation && $validation->hasError('activity_date')): ?>
                        <div class="invalid-feedback"><?= esc($validation->getError('activity_date')) ?></div>
                    <?php endif; ?>
                </div>
                <div class="col-md-4">
                    <label for="activity_time" class="form-label">Jam</label>
                    <input
                        type="time"
                        name="activity_time"
                        id="activity_time"
                        class="form-control <?= $validation && $validation->hasError('activity_time') ? 'is-invalid' : '' ?>"
                        value="<?= esc($data['activity_time'] ?? '') ?>">
                    <?php if ($validation && $validation->hasError('activity_time')): ?>
                        <div class="invalid-feedback"><?= esc($validation->getError('activity_time')) ?></div>
                    <?php endif; ?>
                </div>
                <div class="col-md-4">
                    <label for="location" class="form-label">Lokasi</label>
                    <input
                        type="text"
                        name="location"
                        id="location"
                        class="form-control <?= $validation && $validation->hasError('location') ? 'is-invalid' : '' ?>"
                        placeholder="Contoh: Ruang Rapat A"
                        value="<?= esc($data['location'] ?? '') ?>">
                    <?php if ($validation && $validation->hasError('location')): ?>
                        <div class="invalid-feedback"><?= esc($validation->getError('location')) ?></div>
                    <?php endif; ?>
                </div>
            </div>

            <div class="mb-3 mt-3">
                <label for="description" class="form-label">Deskripsi</label>
                <textarea
                    name="description"
                    id="description"
                    rows="4"
                    class="form-control <?= $validation && $validation->hasError('description') ? 'is-invalid' : '' ?>"
                    placeholder="Jelaskan aktivitas yang dilakukan"><?= esc($data['description'] ?? '') ?></textarea>
                <?php if ($validation && $validation->hasError('description')): ?>
                    <div class="invalid-feedback"><?= esc($validation->getError('description')) ?></div>
                <?php endif; ?>
            </div>

            <div class="mb-3">
                <label for="media" class="form-label">Media (foto/video, opsional)</label>
                <input
                    type="file"
                    name="media"
                    id="media"
                    class="form-control <?= $validation && $validation->hasError('media') ? 'is-invalid' : '' ?>"
                    accept=".jpg,.jpeg,.png,.webp,.mp4,.mov,.avi,.mkv">
                <?php if ($validation && $validation->hasError('media')): ?>
                    <div class="invalid-feedback"><?= esc($validation->getError('media')) ?></div>
                <?php else: ?>
                    <div class="form-text text-muted">Format gambar: JPG, JPEG, PNG, WEBP. Video: MP4, MOV, AVI, MKV. Maks. 10 MB.</div>
                <?php endif; ?>

                <?php if ($isEdit && ! empty($activity['media_path'])): ?>
                    <div class="mt-3">
                        <label class="form-label d-block">Media saat ini</label>
                        <?php if (($activity['media_type'] ?? '') === 'video'): ?>
                            <video class="w-100 rounded" controls preload="metadata">
                                <source src="<?= esc(base_url($activity['media_path'])) ?>" type="video/mp4">
                                Browser tidak mendukung pemutar video.
                            </video>
                        <?php else: ?>
                            <img src="<?= esc(base_url($activity['media_path'])) ?>" alt="Media aktivitas" class="img-fluid rounded">
                        <?php endif; ?>
                        <div class="form-check mt-2">
                            <input class="form-check-input" type="checkbox" value="1" id="remove_media" name="remove_media">
                            <label class="form-check-label" for="remove_media">Hapus media ini</label>
                        </div>
                    </div>
                <?php endif; ?>
            </div>

            <div class="admin-card__footer">
                <div class="d-flex gap-2 justify-content-end">
                    <a href="<?= base_url('admin/aktivitas') ?>" class="btn btn-admin btn-admin-outline">Batal</a>
                    <button type="submit" class="btn btn-admin btn-admin-primary">
                        <?= $isEdit ? 'Simpan Perubahan' : 'Simpan Aktivitas' ?>
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>

<?= $this->endSection() ?>
