﻿<?= $this->extend('layout/admin/admin_layout') ?>

<?= $this->section('content') ?>
<?php
    $this->setVar('pageTitle', 'Dashboard');
    $currentAdmin = [
        'name'  => session()->get('admin_name') ?? 'Administrator',
        'email' => session()->get('admin_email') ?? 'admin@example.com',
    ];
    $now = \CodeIgniter\I18n\Time::now();
?>
<style>
@keyframes adminScaleIn {
    from {
        opacity: 0;
        transform: scale(0.95);
    }
    to {
        opacity: 1;
        transform: scale(1);
    }
}

.dashboard-welcome {
    background: linear-gradient(135deg, #1d4ed8 0%, #8b5cf6 100%);
    border-radius: 24px;
    padding: 2.5rem;
    color: #fff;
    margin-bottom: 2rem;
    box-shadow: 0 20px 40px rgba(29, 78, 216, 0.25);
    position: relative;
    overflow: hidden;
}
.dashboard-welcome::before {
    content: "";
    position: absolute;
    top: -50%;
    right: -10%;
    width: 300px;
    height: 300px;
    background: radial-gradient(circle, rgba(255, 255, 255, 0.15), transparent 70%);
    border-radius: 50%;
}
.dashboard-welcome__content {
    position: relative;
    z-index: 1;
}
.dashboard-welcome__greeting {
    font-size: 14px;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.1em;
    opacity: 0.9;
    margin-bottom: 0.5rem;
}
.dashboard-welcome__title {
    font-size: clamp(24px, 3vw, 32px);
    font-weight: 700;
    margin-bottom: 0.75rem;
}
.dashboard-welcome__desc {
    font-size: 15px;
    opacity: 0.9;
    margin-bottom: 0;
}
.dashboard-welcome__meta {
    position: relative;
    z-index: 1;
    margin-top: 1.5rem;
    padding-top: 1.5rem;
    border-top: 1px solid rgba(255, 255, 255, 0.2);
    font-size: 13px;
    opacity: 0.85;
}
.dashboard-stats {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(240px, 1fr));
    gap: 1.5rem;
    margin-bottom: 2rem;
}
.dashboard-stat-card {
    background: #fff;
    border-radius: 20px;
    padding: 1.75rem;
    box-shadow: 0 8px 24px rgba(15, 23, 42, 0.08);
    border: 1px solid rgba(148, 163, 184, 0.15);
    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    position: relative;
    overflow: hidden;
    animation: adminScaleIn 0.5s ease-out both;
}

.dashboard-stat-card:nth-child(1) { animation-delay: 0.1s; }
.dashboard-stat-card:nth-child(2) { animation-delay: 0.2s; }
.dashboard-stat-card:nth-child(3) { animation-delay: 0.3s; }
.dashboard-stat-card:nth-child(4) { animation-delay: 0.4s; }

.dashboard-stat-card::before {
    content: "";
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 4px;
    background: var(--stat-gradient);
    opacity: 0;
    transition: opacity 0.3s ease;
}
.dashboard-stat-card:hover {
    transform: translateY(-6px) scale(1.02);
    box-shadow: 0 16px 32px rgba(15, 23, 42, 0.12);
    border-color: rgba(148, 163, 184, 0.25);
}
.dashboard-stat-card:hover::before {
    opacity: 1;
}
.dashboard-stat-card--primary {
    --stat-gradient: linear-gradient(90deg, #3b82f6, #8b5cf6);
}
.dashboard-stat-card--success {
    --stat-gradient: linear-gradient(90deg, #10b981, #34d399);
}
.dashboard-stat-card--warning {
    --stat-gradient: linear-gradient(90deg, #f59e0b, #fbbf24);
}
.dashboard-stat-card--info {
    --stat-gradient: linear-gradient(90deg, #06b6d4, #22d3ee);
}
.dashboard-stat-card__header {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 1rem;
}
.dashboard-stat-card__icon {
    width: 48px;
    height: 48px;
    border-radius: 14px;
    display: grid;
    place-items: center;
    font-size: 24px;
    background: var(--stat-icon-bg);
    transition: transform 0.3s ease, scale 0.3s ease;
}

.dashboard-stat-card:hover .dashboard-stat-card__icon {
    transform: scale(1.2) rotate(5deg);
}
.dashboard-stat-card--primary .dashboard-stat-card__icon {
    --stat-icon-bg: rgba(59, 130, 246, 0.15);
}
.dashboard-stat-card--success .dashboard-stat-card__icon {
    --stat-icon-bg: rgba(16, 185, 129, 0.15);
}
.dashboard-stat-card--warning .dashboard-stat-card__icon {
    --stat-icon-bg: rgba(245, 158, 11, 0.15);
}
.dashboard-stat-card--info .dashboard-stat-card__icon {
    --stat-icon-bg: rgba(6, 182, 212, 0.15);
}
.dashboard-stat-card__label {
    font-size: 13px;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.05em;
    color: var(--admin-gray-500);
    margin-bottom: 0.5rem;
}
.dashboard-stat-card__value {
    font-size: 36px;
    font-weight: 700;
    color: var(--admin-gray-900);
    margin-bottom: 0.5rem;
    line-height: 1;
}
.dashboard-stat-card__desc {
    font-size: 13px;
    color: var(--admin-gray-500);
    margin: 0;
}
.dashboard-stat-card__desc--success {
    color: var(--admin-success);
    font-weight: 600;
}
.dashboard-stat-card__desc--warning {
    color: var(--admin-warning);
    font-weight: 600;
}
.dashboard-section {
    margin-bottom: 2rem;
}
.dashboard-section__header {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 1.5rem;
}
.dashboard-section__title {
    font-size: 20px;
    font-weight: 700;
    color: var(--admin-gray-900);
    margin: 0;
}
.dashboard-news-list {
    display: grid;
    gap: 1rem;
}
.dashboard-news-item {
    background: #fff;
    border-radius: 16px;
    padding: 1.5rem;
    box-shadow: 0 4px 12px rgba(15, 23, 42, 0.06);
    border: 1px solid rgba(148, 163, 184, 0.15);
    transition: all 0.2s ease;
    display: grid;
    grid-template-columns: 1fr auto;
    gap: 1.5rem;
    align-items: center;
}
.dashboard-news-item:hover {
    transform: translateX(4px);
    box-shadow: 0 8px 20px rgba(15, 23, 42, 0.1);
    border-color: rgba(148, 163, 184, 0.25);
}
.dashboard-news-item__content {
    flex: 1;
}
.dashboard-news-item__title {
    font-size: 16px;
    font-weight: 600;
    color: var(--admin-gray-900);
    margin-bottom: 0.5rem;
}
.dashboard-news-item__meta {
    display: flex;
    align-items: center;
    gap: 1rem;
    font-size: 13px;
    color: var(--admin-gray-500);
    flex-wrap: wrap;
}
.dashboard-news-item__excerpt {
    font-size: 13px;
    color: var(--admin-gray-500);
    margin-top: 0.5rem;
    display: -webkit-box;
    -webkit-line-clamp: 2;
    -webkit-box-orient: vertical;
    overflow: hidden;
}
.dashboard-news-item__actions {
    display: flex;
    align-items: center;
    gap: 0.75rem;
    flex-shrink: 0;
}
.dashboard-empty {
    background: #fff;
    border-radius: 20px;
    padding: 3rem 2rem;
    text-align: center;
    border: 2px dashed rgba(148, 163, 184, 0.3);
}
.dashboard-empty__icon {
    font-size: 48px;
    margin-bottom: 1rem;
    opacity: 0.5;
}
.dashboard-empty__title {
    font-size: 18px;
    font-weight: 600;
    color: var(--admin-gray-700);
    margin-bottom: 0.5rem;
}
.dashboard-empty__text {
    font-size: 14px;
    color: var(--admin-gray-500);
    margin-bottom: 1.5rem;
}
.dashboard-cta {
    margin-top: 2rem;
    text-align: center;
}
@media (max-width: 768px) {
    .dashboard-welcome {
        padding: 2rem 1.5rem;
    }
    .dashboard-stats {
        grid-template-columns: 1fr;
    }
    .dashboard-news-item {
        grid-template-columns: 1fr;
    }
    .dashboard-news-item__actions {
        justify-content: flex-start;
    }
}
</style>

<?php if (session()->getFlashdata('message')): ?>
    <div class="alert alert-success alert-dismissible fade show mb-4" role="alert">
        <strong>Berhasil!</strong> <?= esc(session()->getFlashdata('message')) ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Tutup"></button>
    </div>
<?php endif; ?>

<div class="dashboard-welcome">
    <div class="dashboard-welcome__content">
        <div class="dashboard-welcome__greeting">Dasbor Admin</div>
        <h1 class="dashboard-welcome__title">Selamat datang kembali, <?= esc($currentAdmin['name']) ?></h1>
        <p class="dashboard-welcome__desc">Kelola berita dan pantau aktivitas portal dari satu tempat terpusat.</p>
    </div>
    <div class="dashboard-welcome__meta">
        Terakhir masuk: <?= esc($now->toLocalizedString('dd MMMM yyyy HH:mm')) ?>
    </div>
</div>

<div class="dashboard-stats">
    <div class="dashboard-stat-card dashboard-stat-card--primary">
        <div class="dashboard-stat-card__header">
            <div>
                <div class="dashboard-stat-card__label">Total Berita</div>
                <div class="dashboard-stat-card__value"><?= esc($stats['totalNews']) ?></div>
                <p class="dashboard-stat-card__desc">Semua status</p>
            </div>
            <div class="dashboard-stat-card__icon">📰</div>
        </div>
    </div>

    <div class="dashboard-stat-card dashboard-stat-card--success" style="animation-delay: 0.2s;">
        <div class="dashboard-stat-card__header">
            <div>
                <div class="dashboard-stat-card__label">Terbit</div>
                <div class="dashboard-stat-card__value"><?= esc($stats['publishedNews']) ?></div>
                <p class="dashboard-stat-card__desc dashboard-stat-card__desc--success">Siap dibaca pengguna</p>
            </div>
            <div class="dashboard-stat-card__icon">✅</div>
        </div>
    </div>

    <div class="dashboard-stat-card dashboard-stat-card--warning" style="animation-delay: 0.3s;">
        <div class="dashboard-stat-card__header">
            <div>
                <div class="dashboard-stat-card__label">Draft</div>
                <div class="dashboard-stat-card__value"><?= esc($stats['draftNews']) ?></div>
                <p class="dashboard-stat-card__desc dashboard-stat-card__desc--warning">Menunggu aksi editor</p>
            </div>
            <div class="dashboard-stat-card__icon">📝</div>
        </div>
    </div>

    <div class="dashboard-stat-card dashboard-stat-card--info" style="animation-delay: 0.4s;">
        <div class="dashboard-stat-card__header">
            <div>
                <div class="dashboard-stat-card__label">Admin Aktif</div>
                <div class="dashboard-stat-card__value">1</div>
                <p class="dashboard-stat-card__desc"><?= esc($currentAdmin['email']) ?></p>
            </div>
            <div class="dashboard-stat-card__icon">👤</div>
        </div>
    </div>
</div>

<div class="dashboard-section">
    <div class="dashboard-section__header">
        <h2 class="dashboard-section__title">Berita Terbaru</h2>
        <a class="btn btn-admin btn-admin-outline btn-sm" href="<?= base_url('admin/news') ?>">
            Kelola semua →
        </a>
    </div>

    <?php if (empty($latestNews)): ?>
        <div class="dashboard-empty">
            <div class="dashboard-empty__icon">📰</div>
            <div class="dashboard-empty__title">Belum ada berita</div>
            <div class="dashboard-empty__text">Mulai publikasi pertama Anda sekarang.</div>
            <a class="btn btn-admin btn-admin-primary" href="<?= base_url('admin/news/new') ?>">
                ➕ Tambah Berita Baru
            </a>
        </div>
    <?php else: ?>
        <div class="dashboard-news-list">
            <?php foreach ($latestNews as $news): ?>
                <div class="dashboard-news-item">
                    <div class="dashboard-news-item__content">
                        <div class="dashboard-news-item__title"><?= esc($news['title']) ?></div>
                        <div class="dashboard-news-item__meta">
                            <span>📅 
                                <?php
                                    $createdAt = $news['created_at'] ?? null;
                                    if ($createdAt) {
                                        echo esc(date('d M Y', strtotime($createdAt)));
                                    } else {
                                        echo 'Tanggal tidak diketahui';
                                    }
                                ?>
                            </span>
                            <span class="admin-badge admin-badge--<?= $news['status'] === 'published' ? 'success' : 'secondary' ?>">
                                <?= esc(ucfirst($news['status'])) ?>
                            </span>
                        </div>
                        <?php if (! empty($news['content'])): ?>
                            <div class="dashboard-news-item__excerpt">
                                <?= esc(character_limiter(strip_tags($news['content']), 100)) ?>
                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="dashboard-news-item__actions">
                        <a class="btn btn-sm btn-admin btn-admin-outline" href="<?= base_url('admin/news/'.$news['id'].'/edit') ?>">
                            ✏️ Edit
                        </a>
                        <?php if ($news['status'] === 'published'): ?>
                            <a class="btn btn-sm btn-admin btn-admin-outline" href="<?= base_url('news/'.$news['slug']) ?>" target="_blank">
                                👁️ Preview
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>

        <div class="dashboard-cta">
            <a class="btn btn-admin btn-admin-primary" href="<?= base_url('admin/news/new') ?>">
                ➕ Tambah Berita Baru
            </a>
        </div>
    <?php endif; ?>
</div>

<?= $this->endSection() ?>
