<?= $this->extend('layout/admin/admin_layout') ?>

<?= $this->section('content') ?>
<div class="mb-4">
    <h1 class="h4 mb-1">Tambah Berita</h1>
    <p class="text-muted mb-0">Tulis judul dan isi, kemudian pilih status publikasi.</p>
    <a href="<?= base_url('admin/news') ?>" class="btn btn-link ps-0">&larr; Kembali ke daftar</a>
</div>

<?php
    $validation = $validation ?? null;
    $oldInput   = $oldInput ?? [];
    $imageColumnAvailable = $imageColumnAvailable ?? false;
?>

<div class="card shadow-sm">
    <div class="card-body">
        <form action="" method="post" class="needs-validation" enctype="multipart/form-data" novalidate>
            <?= csrf_field() ?>
            <input type="hidden" name="status" id="status-field" value="<?= esc($oldInput['status'] ?? 'draft') ?>" />

            <div class="mb-3">
                <label for="title" class="form-label">Judul</label>
                <input
                    type="text"
                    name="title"
                    id="title"
                    class="form-control <?= $validation && $validation->hasError('title') ? 'is-invalid' : '' ?>"
                    placeholder="Judul berita"
                    value="<?= esc($oldInput['title'] ?? '') ?>"
                    required>
                <?php if ($validation && $validation->hasError('title')): ?>
                    <div class="invalid-feedback"><?= esc($validation->getError('title')) ?></div>
                <?php endif; ?>
            </div>

            <div class="mb-3">
                <label for="content" class="form-label">Isi Berita</label>
                <textarea
                    name="content"
                    id="content"
                    class="form-control <?= $validation && $validation->hasError('content') ? 'is-invalid' : '' ?>"
                    rows="8"
                    placeholder="Tulis konten berita di sini"
                    required><?= esc($oldInput['content'] ?? '') ?></textarea>
                <?php if ($validation && $validation->hasError('content')): ?>
                    <div class="invalid-feedback"><?= esc($validation->getError('content')) ?></div>
                <?php endif; ?>
            </div>

            <?php if ($imageColumnAvailable): ?>
                <div class="mb-3">
                    <label for="image" class="form-label">Gambar Berita (opsional)</label>
                    <input
                        type="file"
                        name="image"
                        id="image"
                        accept=".jpg,.jpeg,.png,.webp"
                        class="form-control <?= $validation && $validation->hasError('image') ? 'is-invalid' : '' ?>">
                    <?php if ($validation && $validation->hasError('image')): ?>
                        <div class="invalid-feedback"><?= esc($validation->getError('image')) ?></div>
                    <?php else: ?>
                        <div class="form-text text-muted">Format: JPG, PNG, atau WEBP maksimum 2 MB.</div>
                    <?php endif; ?>
                </div>
            <?php else: ?>
                <div class="alert alert-warning" role="alert">
                    Fitur unggah gambar memerlukan kolom <code>image_path</code> pada tabel <code>news</code>.
                    Tambahkan kolom tersebut dengan perintah SQL:
                    <code>ALTER TABLE news ADD image_path VARCHAR(255) NULL AFTER content;</code>
                </div>
            <?php endif; ?>

            <div class="d-flex gap-2">
                <button type="submit" name="action" value="published" class="btn btn-primary" data-set-status="published">Terbitkan</button>
                <button type="submit" name="action" value="draft" class="btn btn-outline-secondary" data-set-status="draft">Simpan sebagai Draft</button>
            </div>
        </form>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', () => {
    const statusField = document.getElementById('status-field');
    if (!statusField) {
        return;
    }

    document.querySelectorAll('[data-set-status]').forEach((button) => {
        button.addEventListener('click', () => {
            statusField.value = button.getAttribute('data-set-status');
        });
    });
});
</script>

<?= $this->endSection() ?>
