<?php

namespace App\Database\Seeds;

use CodeIgniter\Database\Seeder;

/**
 * Seeder untuk membuat / memperbarui admin utama.
 */
class AdminSeeder extends Seeder
{
    public function run()
    {
        // Baca kredensial admin dari environment untuk fleksibilitas
        $adminEmail = trim((string) env('ADMIN_EMAIL', 'admin@example.com'));
        $adminName  = trim((string) env('ADMIN_NAME', 'Administrator'));
        $adminPass  = (string) env('ADMIN_PASSWORD', 'admin123');

        $builder = $this->db->table('admins');
        $existing = $builder->where('email', $adminEmail)->get()->getRowArray();

        // Data admin yang akan disisipkan / diperbarui
        $payload = [
            'name'          => $adminName,
            'email'         => $adminEmail,
            'role'          => 'admin',
            'password_hash' => password_hash($adminPass, PASSWORD_DEFAULT),
            'is_active'     => 1,
            'last_login_at' => null,
            'last_password_reset_at' => null,
            'created_at'    => date('Y-m-d H:i:s'),
            'updated_at'    => date('Y-m-d H:i:s'),
            'deleted_at'    => null,
        ];

        if ($existing) {
            // Jika admin dengan email sama sudah ada, perbarui saja
            $builder->where('email', $adminEmail)->update($payload);
            return;
        }

        // Jika belum ada, insert record baru
        $builder->insert($payload);
    }
}
