<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreateDailyActivities extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type'           => 'INT',
                'constraint'     => 10,
                'unsigned'       => true,
                'auto_increment' => true,
            ],
            'activity_date' => [
                'type' => 'DATE',
            ],
            'activity_time' => [
                'type' => 'TIME',
                'null' => true,
            ],
            'title' => [
                'type'       => 'VARCHAR',
                'constraint' => 200,
            ],
            'description' => [
                'type' => 'TEXT',
                'null' => true,
            ],
            'location' => [
                'type'       => 'VARCHAR',
                'constraint' => 150,
                'null'       => true,
            ],
            'media_type' => [
                'type'       => 'ENUM',
                'constraint' => ['image', 'video', 'none'],
                'default'    => 'none',
            ],
            'media_path' => [
                'type'       => 'VARCHAR',
                'constraint' => 255,
                'null'       => true,
            ],
            'created_at DATETIME DEFAULT CURRENT_TIMESTAMP',
            'updated_at DATETIME NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP',
        ]);

        $this->forge->addKey('id', true);
        $this->forge->addKey('activity_date');
        $this->forge->createTable('daily_activities', true);
    }

    public function down()
    {
        $this->forge->dropTable('daily_activities', true);
    }
}
