<?php

namespace App\Controllers;

use App\Models\BiodataModel;

class Biodata extends BaseController
{
    private BiodataModel $biodata;

    public function __construct()
    {
        helper(['text']);
        $this->biodata = new BiodataModel();
    }

    public function index(): string
    {
        $request        = $this->request;
        $search         = trim((string) $request->getGet('q'));
        $headlineFilter = trim((string) $request->getGet('headline'));
        $sort           = (string) $request->getGet('sort');

        $query = $this->biodata;

        if ($search !== '') {
            $query->groupStart()
                ->like('full_name', $search)
                ->orLike('headline', $search)
                ->orLike('skills', $search)
                ->orLike('summary', $search)
                ->groupEnd();
        }

        if ($headlineFilter !== '' && $headlineFilter !== 'semua') {
            $query->where('headline', $headlineFilter);
        }

        $sort = $sort !== '' ? $sort : 'newest';
        switch ($sort) {
            case 'name_asc':
                $query->orderBy('full_name', 'asc');
                break;
            case 'name_desc':
                $query->orderBy('full_name', 'desc');
                break;
            default:
                $query->orderBy('created_at', 'desc');
                $sort = 'newest';
        }

        $profiles = $query->paginate(10, 'biodata');

        $headlineOptions = (new BiodataModel())
            ->select('headline')
            ->distinct()
            ->orderBy('headline', 'asc')
            ->findAll();
        $headlineOptions = array_values(array_filter(array_map(static function ($row) {
            return $row['headline'] ?? null;
        }, $headlineOptions)));

        return view('biodata', [
            'profiles'        => $profiles,
            'pager'           => $this->biodata->pager,
            'filters'         => [
                'search'   => $search,
                'headline' => $headlineFilter !== '' ? $headlineFilter : 'semua',
                'sort'     => $sort,
            ],
            'headlineOptions' => $headlineOptions,
        ]);
    }

    public function show(?int $id = null): string
    {
        $profile = $id
            ? $this->biodata->find($id)
            : $this->biodata->orderBy('id', 'asc')->first();

        if (! $profile) {
            throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
        }

        return view('biodata_detail', [
            'profile' => $profile,
        ]);
    }
}
